/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.client.particles;

import com.aranaira.arcanearchives.client.render.RenderUtils;
import com.aranaira.arcanearchives.items.gems.ArcaneGemItem;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class ParticleGenerator {
    public static Random rng = new Random();

    public static void makeDefaultLine(World world, Vec3d start, Vec3d end, int count, double shiftIntensity) {
        double dist = start.func_72438_d(end);
        end = end.func_72441_c(0.5, 0.5, 0.5);
        double xShiftMult1 = rng.nextDouble() - 0.5;
        double xShiftMult2 = rng.nextDouble() - 0.5;
        double zShiftMult1 = rng.nextDouble() - 0.5;
        double zShiftMult2 = rng.nextDouble() - 0.5;
        double yShiftMult = rng.nextDouble() * 0.3;
        double distMagnifier = 1.0 + dist * 0.1;
        ArrayList<Vec3d> verts = new ArrayList<Vec3d>();
        for (int i = 0; i <= count; ++i) {
            double prog = (double)i / (double)count;
            Vec3d pos = ParticleGenerator.veclerp(start, end, prog);
            if (shiftIntensity > 0.0) {
                double x1 = Math.sin(prog * Math.PI * 2.0) * shiftIntensity * xShiftMult1;
                double x2 = Math.sin(prog * Math.PI) * shiftIntensity * xShiftMult2;
                double z1 = Math.sin(prog * Math.PI * 2.0) * shiftIntensity * zShiftMult1;
                double z2 = Math.sin(prog * Math.PI) * shiftIntensity * zShiftMult2;
                pos = pos.func_72441_c((x1 + x2) * prog * distMagnifier, Math.sin(prog * Math.PI) * shiftIntensity * yShiftMult * prog * distMagnifier, (z1 + z2) * prog * distMagnifier);
            }
            double sx = (rng.nextDouble() * 2.0 - 1.0) * 0.1;
            double sz = (rng.nextDouble() * 2.0 - 1.0) * 0.1;
            double sy = (rng.nextDouble() * 0.7 + 0.3) * 0.1;
            verts.add(pos);
        }
        RenderUtils.drawSegmentedLine(world.func_72820_D(), ArcaneGemItem.GemColor.getColor(ArcaneGemItem.GemColor.ORANGE), 1.0f, start, verts);
    }

    public static void makeDefaultBurst(World world, Vec3d point, int radialCount, int heightCount, double radius, double speedMin, double speedMax) {
        for (int h = 0; h < heightCount; ++h) {
            double py = (double)h / (double)heightCount;
            for (int i = 0; i < radialCount; ++i) {
                double segment = Math.PI * 2 / (double)radialCount;
                double theta = (double)i * segment;
                double ax = Math.cos(theta) * radius;
                double az = Math.sin(theta) * radius;
                double px = point.field_72450_a + ax + 0.5;
                double pz = point.field_72449_c + az + 0.5;
                double sx = ax * (speedMax - speedMin + speedMin);
                double sz = az * (speedMax - speedMin + speedMin);
                double sy = (rng.nextDouble() * 0.7 + 0.3) * 0.1;
                world.func_175688_a(EnumParticleTypes.CLOUD, px, point.field_72448_b + 0.5, pz, sx, sy * 2.0, sz, new int[0]);
            }
        }
    }

    public static void makeDefaultBurstOnEntity(World world, Vec3d point, int radialCount, int heightCount, double radius, double speedMin, double speedMax) {
        for (int h = 0; h < heightCount; ++h) {
            double py = (double)h / (double)heightCount;
            for (int i = 0; i < radialCount; ++i) {
                double segment = Math.PI * 2 / (double)radialCount;
                double theta = (double)i * segment;
                double ax = Math.cos(theta) * radius;
                double az = Math.sin(theta) * radius;
                double px = point.field_72450_a + ax;
                double pz = point.field_72449_c + az;
                double sx = ax * (speedMax - speedMin + speedMin);
                double sz = az * (speedMax - speedMin + speedMin);
                double sy = Math.abs(rng.nextDouble() * 14.5 * (speedMax - speedMin + speedMin));
                world.func_175688_a(EnumParticleTypes.CLOUD, px, point.field_72448_b + 0.5, pz, sx, sy, sz, new int[0]);
            }
        }
    }

    private static Vec3d veclerp(Vec3d start, Vec3d end, double prog) {
        if (prog < 0.0) {
            prog = 0.0;
        }
        if (prog > 1.0) {
            prog = 1.0;
        }
        double x = (end.field_72450_a - start.field_72450_a) * prog;
        double y = (end.field_72448_b - start.field_72448_b) * prog;
        double z = (end.field_72449_c - start.field_72449_c) * prog;
        return new Vec3d(x += start.field_72450_a, y += start.field_72448_b, z += start.field_72449_c);
    }
}

