/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.client.gui.controls;

import com.aranaira.arcanearchives.client.gui.controls.InvisibleButton;
import com.aranaira.arcanearchives.client.gui.controls.TexturedButton;
import com.aranaira.arcanearchives.client.gui.framework.IScrollabe;
import com.aranaira.arcanearchives.client.gui.framework.IScrollableContainer;
import com.aranaira.arcanearchives.client.gui.framework.ScrollEventManager;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;

public class ScrollBar
extends InvisibleButton
implements IScrollableContainer {
    public ScrollBarNub mNub;
    private int maxNubTopOffset;
    private ScrollEventManager scrollEventManager;

    public ScrollBar(int startId, int leftOffset, int topOffset, int bottomOffset) {
        super(startId, leftOffset, topOffset, TexturedButton.getWidth(0), bottomOffset - topOffset, "");
        this.mNub = new ScrollBarNub(startId + 1, 0, leftOffset, topOffset);
        this.maxNubTopOffset = this.field_146121_g - this.mNub.field_146121_g;
        this.scrollEventManager = null;
    }

    @Override
    public void registerScrollEventManager(ScrollEventManager scrollEventManager) {
        if (this.scrollEventManager != null) {
            this.scrollEventManager.unregisterListener(this);
        }
        this.scrollEventManager = scrollEventManager;
    }

    @Override
    public List<? extends IScrollabe> getScrollable() {
        return Collections.singletonList(this.mNub);
    }

    @Override
    public int getMaxYOffset() {
        return this.maxNubTopOffset;
    }

    public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
        boolean interacted = super.func_146116_c(mc, mouseX, mouseY);
        if (interacted && !this.mNub.func_146116_c(mc, mouseX, mouseY)) {
            if (mouseY < this.mNub.field_146129_i) {
                this.scrollEventManager.pageUp();
            } else {
                this.scrollEventManager.pageDown();
            }
        }
        return interacted;
    }

    private class ScrollBarNub
    extends TexturedButton
    implements IScrollabe {
        private boolean isBeingDragged;

        public ScrollBarNub(int buttonId, int textureId, int x, int y) {
            super(buttonId, textureId, x, y);
            this.isBeingDragged = false;
        }

        @Override
        public void updateY(int yOffset) {
            this.field_146129_i = ScrollBar.this.field_146129_i + yOffset;
        }

        private float getScrollPercent(int mouseY) {
            return (float)(mouseY - this.field_146121_g / 2 - ScrollBar.this.field_146129_i) / (float)ScrollBar.this.getMaxYOffset();
        }

        public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
            boolean interacted = super.func_146116_c(mc, mouseX, mouseY);
            if (this.field_146125_m && interacted) {
                this.isBeingDragged = true;
                ScrollBar.this.scrollEventManager.setScrollPercent(this.getScrollPercent(mouseY));
            }
            return interacted;
        }

        protected void func_146119_b(Minecraft mc, int mouseX, int mouseY) {
            super.func_146119_b(mc, mouseX, mouseY);
            if (this.field_146125_m && this.isBeingDragged) {
                ScrollBar.this.scrollEventManager.setScrollPercent(this.getScrollPercent(mouseY));
            }
        }

        public void func_146118_a(int mouseX, int mouseY) {
            super.func_146118_a(mouseX, mouseY);
            this.isBeingDragged = false;
        }
    }
}

