/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.client.gui;

import com.aranaira.arcanearchives.api.IGCTRecipe;
import com.aranaira.arcanearchives.client.CycleTimer;
import com.aranaira.arcanearchives.client.gui.AbstractGuiContainerTracking;
import com.aranaira.arcanearchives.client.gui.controls.InvisibleButton;
import com.aranaira.arcanearchives.config.ConfigHandler;
import com.aranaira.arcanearchives.inventory.ContainerGemCuttersTable;
import com.aranaira.arcanearchives.inventory.slots.SlotRecipeHandler;
import com.aranaira.arcanearchives.network.Networking;
import com.aranaira.arcanearchives.network.PacketGemCutters;
import com.aranaira.arcanearchives.recipe.IngredientStack;
import com.aranaira.arcanearchives.recipe.gct.GCTRecipeList;
import com.aranaira.arcanearchives.tileentities.GemCuttersTableTileEntity;
import com.aranaira.arcanearchives.util.ManifestTrackingUtils;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import yalter.mousetweaks.api.MouseTweaksDisableWheelTweak;

@MouseTweaksDisableWheelTweak
public class GUIGemCuttersTable
extends AbstractGuiContainerTracking {
    private static final ResourceLocation GUI_TEXTURES = new ResourceLocation("arcanearchives:textures/gui/gemcutterstable.png");
    private static final ResourceLocation GUI_TEXTURES_SIMPLE = new ResourceLocation("arcanearchives:textures/gui/simple/gemcutterstable.png");
    private static final int OVERLAY = -1440861376;
    private static final int OVERLAY_SIMPLE = -2139062144;
    private final ContainerGemCuttersTable container;
    private final EntityPlayer player;
    private final Object2BooleanMap<IGCTRecipe> recipeStatus = new Object2BooleanOpenHashMap();
    private final GemCuttersTableTileEntity tile;
    private InvisibleButton prevPageButton;
    private InvisibleButton nextPageButton;
    private int timesChanged;
    private List<ItemStack> tracked;
    private CycleTimer cycleTimer;
    private Map<IGCTRecipe, List<List<ItemStack>>> recipeIngredients = new HashMap<IGCTRecipe, List<List<ItemStack>>>();
    private Map<IGCTRecipe, IntArrayList> recipeCounts = new HashMap<IGCTRecipe, IntArrayList>();
    public static final int DOWN = -120;
    public static final int UP = 120;

    public GUIGemCuttersTable(EntityPlayer player, ContainerGemCuttersTable container) {
        super(container);
        this.container = container;
        container.setUpdateRecipeGUI(this::updateRecipeStatus);
        this.tile = container.getTile();
        this.field_146999_f = 206;
        this.field_147000_g = 254;
        this.player = player;
        this.updateRecipeStatus();
        this.timesChanged = this.player.field_71071_by.func_194015_p();
        this.cycleTimer = new CycleTimer(-1);
        this.tracked = ManifestTrackingUtils.get(player.field_71093_bK, this.tile.func_174877_v());
    }

    public void updateRecipeStatus() {
        this.recipeStatus.clear();
        this.recipeStatus.putAll(this.container.updateRecipeStatus());
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.prevPageButton = new InvisibleButton(0, this.field_147003_i + 26, this.field_147009_r + 69, 10, 18, "");
        this.nextPageButton = new InvisibleButton(1, this.field_147003_i + 170, this.field_147009_r + 69, 10, 18, "");
        this.field_146292_n.add(this.prevPageButton);
        this.field_146292_n.add(this.nextPageButton);
        this.updateRecipeStatus();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.cycleTimer.onDraw();
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
        int nextChanged = this.player.field_71071_by.func_194015_p();
        if (nextChanged != this.timesChanged) {
            this.updateRecipeStatus();
            this.timesChanged = nextChanged;
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179142_g();
        if (ConfigHandler.UsePrettyGUIs) {
            this.field_146297_k.func_110434_K().func_110577_a(GUI_TEXTURES);
        } else {
            this.field_146297_k.func_110434_K().func_110577_a(GUI_TEXTURES_SIMPLE);
        }
        GUIGemCuttersTable.func_146110_a((int)this.field_147003_i, (int)this.field_147009_r, (float)0.0f, (float)0.0f, (int)206, (int)256, (float)256.0f, (float)256.0f);
    }

    public void func_146977_a(Slot slot) {
        ItemStack stack;
        IGCTRecipe recipe = null;
        boolean recipeSlot = false;
        if (slot instanceof SlotRecipeHandler) {
            recipe = ((SlotRecipeHandler)slot).getRecipe();
            recipeSlot = true;
        }
        if (!(stack = slot.func_75211_c()).func_190926_b() && (this.tracked != null && !this.tracked.isEmpty() && ManifestTrackingUtils.matches(stack, this.tracked) && !recipeSlot || recipeSlot && ManifestTrackingUtils.matches(stack) && this.recipeStatus.getBoolean((Object)recipe) && recipe.craftable(this.player, this.tile))) {
            this.glowSlot(slot);
        }
        super.func_146977_a(slot);
        boolean wasEnabled = false;
        if (recipeSlot) {
            if (recipe == null) {
                return;
            }
            if (recipe == this.tile.getCurrentRecipe()) {
                wasEnabled = true;
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179142_g();
                if (ConfigHandler.UsePrettyGUIs) {
                    this.field_146297_k.func_110434_K().func_110577_a(GUI_TEXTURES);
                } else {
                    this.field_146297_k.func_110434_K().func_110577_a(GUI_TEXTURES_SIMPLE);
                }
                this.func_73729_b(slot.field_75223_e - 2, slot.field_75221_f - 2, 206, 0, 20, 20);
            }
            if (!this.recipeStatus.getBoolean((Object)recipe) || !recipe.craftable((EntityPlayer)this.field_146297_k.field_71439_g, this.tile)) {
                this.dimSlot(slot, wasEnabled);
            }
        }
    }

    private void dimSlot(Slot slot, boolean wasEnabled) {
        if (wasEnabled) {
            if (ConfigHandler.UsePrettyGUIs) {
                this.field_146297_k.func_110434_K().func_147645_c(GUI_TEXTURES);
            } else {
                this.field_146297_k.func_110434_K().func_147645_c(GUI_TEXTURES_SIMPLE);
            }
        }
        GlStateManager.func_179097_i();
        if (ConfigHandler.UsePrettyGUIs) {
            GUIGemCuttersTable.func_73734_a((int)slot.field_75223_e, (int)slot.field_75221_f, (int)(slot.field_75223_e + 16), (int)(slot.field_75221_f + 16), (int)-1440861376);
        } else {
            GUIGemCuttersTable.func_73734_a((int)slot.field_75223_e, (int)slot.field_75221_f, (int)(slot.field_75223_e + 16), (int)(slot.field_75221_f + 16), (int)-2139062144);
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    protected void func_146285_a(ItemStack stack, int x, int y) {
        Slot slot = this.getSlotUnderMouse();
        if (slot instanceof SlotRecipeHandler) {
            FontRenderer font = stack.func_77973_b().getFontRenderer(stack);
            ArrayList<String> tooltip = new ArrayList<String>();
            IGCTRecipe recipe = ((SlotRecipeHandler)slot).getRecipe();
            if (recipe != null) {
                if (this.recipeStatus.getBoolean((Object)recipe)) {
                    tooltip.add(TextFormatting.GREEN + stack.func_82833_r());
                } else {
                    tooltip.add(TextFormatting.RED + stack.func_82833_r());
                }
                List<List<ItemStack>> ingredients = this.recipeIngredients.get(recipe);
                IntArrayList counts = this.recipeCounts.get(recipe);
                if (ingredients == null || counts == null) {
                    ingredients = new ArrayList<List<ItemStack>>();
                    counts = new IntArrayList();
                    for (IngredientStack ing : recipe.getIngredients()) {
                        ItemStack[] stacks = ing.getMatchingStacks();
                        assert (stacks.length != 0);
                        ingredients.add(Stream.of(stacks).map(ItemStack::func_77946_l).collect(Collectors.toList()));
                        counts.add(ing.getCount());
                    }
                    this.recipeIngredients.put(recipe, ingredients);
                    this.recipeCounts.put(recipe, counts);
                }
                for (int i = 0; i < ingredients.size(); ++i) {
                    ItemStack item = this.cycleTimer.getCycledItem(ingredients.get(i));
                    tooltip.add(TextFormatting.BOLD + item.func_82833_r() + " : " + counts.getInt(i));
                }
            }
            this.drawHoveringText(tooltip, x, y, font == null ? this.field_146289_q : font);
        } else {
            super.func_146285_a(stack, x, y);
        }
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146127_k == 0) {
            this.tile.previousPage();
        }
        if (button.field_146127_k == 1) {
            this.tile.nextPage();
        }
        super.func_146284_a(button);
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int wheel = Mouse.getEventDWheel();
        int button = Mouse.getEventButton();
        if (wheel != 0 && button == -1) {
            IGCTRecipe newRecipe = null;
            if (this.recipeStatus.values().stream().anyMatch(o -> o)) {
                int index;
                block0 : switch (wheel) {
                    case -120: {
                        IGCTRecipe temp;
                        int originalIndex;
                        for (index = originalIndex = (currentRecipe = this.tile.getCurrentRecipe()) == null ? 0 : currentRecipe.getIndex(); index < GCTRecipeList.instance.size(); ++index) {
                            temp = GCTRecipeList.instance.getRecipeByIndex(index);
                            if (index == originalIndex || temp == null || !((Boolean)this.recipeStatus.get((Object)temp)).booleanValue()) continue;
                            newRecipe = temp;
                            break;
                        }
                        if (newRecipe != null) break;
                        for (index = 0; index < originalIndex; ++index) {
                            temp = GCTRecipeList.instance.getRecipeByIndex(index);
                            if (index == originalIndex || temp == null || !((Boolean)this.recipeStatus.get((Object)temp)).booleanValue()) continue;
                            newRecipe = temp;
                            break block0;
                        }
                        break;
                    }
                    case 120: {
                        IGCTRecipe temp;
                        int originalIndex;
                        --index;
                        while (index >= 0) {
                            temp = GCTRecipeList.instance.getRecipeByIndex(index);
                            if (index != originalIndex && temp != null && ((Boolean)this.recipeStatus.get((Object)temp)).booleanValue()) {
                                newRecipe = temp;
                                break;
                            }
                            --index;
                        }
                        if (newRecipe != null) break;
                        for (index = GCTRecipeList.instance.size(); index > originalIndex; --index) {
                            temp = GCTRecipeList.instance.getRecipeByIndex(index);
                            if (index == originalIndex || temp == null || !((Boolean)this.recipeStatus.get((Object)temp)).booleanValue()) continue;
                            newRecipe = temp;
                            break block0;
                        }
                        break;
                    }
                    default: {
                        return;
                    }
                }
                if (newRecipe != null) {
                    int newPage = index / 7;
                    this.tile.setPage(newPage);
                    PacketGemCutters.SetRecipeIndex message = new PacketGemCutters.SetRecipeIndex(this.tile.getUuid(), index);
                    Networking.CHANNEL.sendToServer((IMessage)message);
                    this.tile.setRecipe(index);
                    this.container.updateRecipe();
                }
            }
        }
    }
}

