/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.client.gui;

import com.aranaira.arcanearchives.client.gui.controls.InvisibleButton;
import com.aranaira.arcanearchives.client.gui.controls.RightClickTextField;
import com.aranaira.arcanearchives.config.ConfigHandler;
import com.aranaira.arcanearchives.inventory.ContainerBrazier;
import com.aranaira.arcanearchives.network.Messages;
import com.aranaira.arcanearchives.network.Networking;
import com.aranaira.arcanearchives.network.PacketBrazier;
import java.io.IOException;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiPageButtonList;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.opengl.GL11;

public class GUIBrazier
extends GuiContainer
implements GuiPageButtonList.GuiResponder {
    private static final ResourceLocation TEXTURE_BRAZIER = new ResourceLocation("arcanearchives:textures/gui/brazier_hoarding.png");
    private static final int BACKGROUND_X = 0;
    private static final int BACKGROUND_Y = 0;
    private static final int BACKGROUND_W = 98;
    private static final int BACKGROUND_H = 41;
    private static final int EYE_OPEN_X = 222;
    private static final int EYE_OPEN_Y = 0;
    private static final int EYE_CLOSED_X = 210;
    private static final int EYE_CLOSED_Y = 0;
    private static final int EYE_W = 12;
    private static final int EYE_H = 10;
    private static final int SLASH_X = 240;
    private static final int SLASH_Y = 0;
    private static final int SLASH_S = 16;
    private static final int CHECK_X = 234;
    private static final int CHECK_Y = 0;
    private static final int CHECK_S = 6;
    private static final int ROUTING_TOOLTIP_X = 67;
    private static final int ROUTING_TOOLTIP_Y = 28;
    private static final int ROUTING_TOOLTIP_W = 31;
    private static final int ROUTING_TOOLTIP_H = 16;
    private static final int VISUALIZER_TOOLTIP_X = 6;
    private static final int VISUALIZER_TOOLTIP_Y = 7;
    private static final int VISUALIZER_TOOLTIP_W = 13;
    private static final int VISUALIZER_TOOLTIP_H = 12;
    private static final int RADIUS_LEFT_TOOLTIP_X = 29;
    private static final int RADIUS_LEFT_TOOLTIP_Y = 6;
    private static final int RADIUS_LEFT_TOOLTIP_W = 8;
    private static final int RADIUS_LEFT_TOOLTIP_H = 16;
    private static final int RADIUS_RIGHT_TOOLTIP_X = 85;
    private static final int RADIUS_RIGHT_TOOLTIP_Y = 6;
    private static final int RADIUS_RIGHT_TOOLTIP_W = 8;
    private static final int RADIUS_RIGHT_TOOLTIP_H = 16;
    private GuiButton reduceButton;
    private GuiButton expandButton;
    private GuiButton fullNetworkToggleButton;
    private GuiButton visualizerButton;
    private GuiTextField radiusField;
    private ContainerBrazier containerBrazier;

    public GUIBrazier(@Nonnull ContainerBrazier containerBrazier) {
        super((Container)containerBrazier);
        this.containerBrazier = containerBrazier;
        this.field_146999_f = 98;
        this.field_147000_g = 41;
        this.containerBrazier.getTile().addUpdateHook(this::updateHook);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.radiusField = new RightClickTextField(0, this.field_146289_q, this.field_147003_i + 45, this.field_147009_r + 9, 36, 12);
        this.radiusField.func_146180_a("" + this.containerBrazier.getTile().getRadius());
        this.radiusField.func_175207_a((GuiPageButtonList.GuiResponder)this);
        this.radiusField.func_146185_a(false);
        this.radiusField.func_175205_a(input -> input.matches("[0-9]+") && input.length() <= 3 || input.isEmpty());
        this.reduceButton = new InvisibleButton(0, this.field_147003_i + 29, this.field_147009_r + 2, 8, 16, "");
        this.expandButton = new InvisibleButton(1, this.field_147003_i + 85, this.field_147009_r + 2, 8, 16, "");
        this.fullNetworkToggleButton = new InvisibleButton(2, this.field_147003_i + 67, this.field_147009_r + 27, 12, 12, "");
        this.visualizerButton = new InvisibleButton(3, this.field_147003_i + 6, this.field_147009_r + 6, 14, 14, "");
        this.func_189646_b(this.reduceButton);
        this.func_189646_b(this.expandButton);
        this.func_189646_b(this.fullNetworkToggleButton);
        this.func_189646_b(this.visualizerButton);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        Messages.EmptyTileMessageServer packet;
        if (button.field_146127_k == 0) {
            packet = new PacketBrazier.DecrementRadius(this.containerBrazier.getTile().getUuid());
            Networking.CHANNEL.sendToServer((IMessage)packet);
        }
        if (button.field_146127_k == 1) {
            packet = new PacketBrazier.IncrementRadius(this.containerBrazier.getTile().getUuid());
            Networking.CHANNEL.sendToServer((IMessage)packet);
        }
        if (button.field_146127_k == 2) {
            boolean newMode = !this.containerBrazier.getTile().getNetworkMode();
            PacketBrazier.SetSubnetworkMode packet2 = new PacketBrazier.SetSubnetworkMode(newMode, this.containerBrazier.getTile().getUuid());
            Networking.CHANNEL.sendToServer((IMessage)packet2);
        }
        if (button.field_146127_k == 3) {
            this.containerBrazier.getTile().toggleShowRange();
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        boolean wasEnabled = GL11.glIsEnabled((int)2896);
        GlStateManager.func_179140_f();
        this.radiusField.func_146194_f();
        if (wasEnabled) {
            GlStateManager.func_179145_e();
        }
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float i = (this.field_146294_l - this.field_146999_f) / 2;
        float j = (this.field_146295_m - this.field_147000_g) / 2;
        if (ConfigHandler.UsePrettyGUIs) {
            this.field_146297_k.func_110434_K().func_110577_a(TEXTURE_BRAZIER);
            this.func_175174_a(i, j, 0, 0, 98, 41);
        }
        if (this.containerBrazier.getTile().getNetworkMode()) {
            this.func_175174_a(i + 70.0f, j + 30.0f, 234, 0, 6, 6);
            this.func_175174_a(i + 82.0f, j + 25.0f, 240, 0, 16, 16);
        }
        if (this.containerBrazier.getTile().isShowingRange()) {
            this.func_175174_a(i + 7.0f, j + 8.0f, 222, 0, 12, 10);
        } else {
            this.func_175174_a(i + 7.0f, j + 8.0f, 210, 0, 12, 10);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (this.radiusField.func_146192_a(mouseX, mouseY, mouseButton)) {
            return;
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (this.radiusField.func_146206_l() && this.radiusField.func_146201_a(typedChar, keyCode)) {
            return;
        }
        super.func_73869_a(typedChar, keyCode);
    }

    public void func_175321_a(int id, boolean value) {
    }

    public void func_175320_a(int id, float value) {
    }

    public void func_175319_a(int id, String value) {
        int newRadius;
        if (value.isEmpty()) {
            return;
        }
        try {
            newRadius = Integer.parseInt(value);
        }
        catch (NumberFormatException exception) {
            return;
        }
        if (newRadius > 0 && newRadius <= 300) {
            PacketBrazier.SetRadius packet = new PacketBrazier.SetRadius(newRadius, this.containerBrazier.getTile().getUuid());
            Networking.CHANNEL.sendToServer((IMessage)packet);
        }
    }

    public void updateHook() {
        this.radiusField.func_146180_a("" + this.containerBrazier.getTile().getRadius());
    }

    public void func_146281_b() {
        this.containerBrazier.getTile().removeUpdateHook(this::updateHook);
    }

    protected void func_191948_b(int mouseX, int mouseY) {
        if (mouseY >= this.field_147009_r + 28 && mouseY <= this.field_147009_r + 28 + 16 && mouseX >= this.field_147003_i + 67 && mouseX <= this.field_147003_i + 67 + 31) {
            ArrayList<String> tooltip = new ArrayList<String>();
            if (this.containerBrazier.getTile().getNetworkMode()) {
                tooltip.add(I18n.func_135052_a((String)"arcanearchives.tooltip.brazier.routingmode.mine1", (Object[])new Object[0]));
                tooltip.add(I18n.func_135052_a((String)"arcanearchives.tooltip.brazier.routingmode.mine2", (Object[])new Object[0]));
            } else {
                tooltip.add(I18n.func_135052_a((String)"arcanearchives.tooltip.brazier.routingmode.all1", (Object[])new Object[0]));
                tooltip.add(I18n.func_135052_a((String)"arcanearchives.tooltip.brazier.routingmode.all2", (Object[])new Object[0]));
            }
            this.func_146283_a(tooltip, mouseX, mouseY);
            return;
        }
        if (mouseY >= this.field_147009_r + 7 && mouseY <= this.field_147009_r + 7 + 12 && mouseX >= this.field_147003_i + 6 && mouseX <= this.field_147003_i + 6 + 13) {
            ArrayList<String> tooltip = new ArrayList<String>();
            if (this.containerBrazier.getTile().isShowingRange()) {
                tooltip.add(I18n.func_135052_a((String)"arcanearchives.tooltip.brazier.visualizer.hide", (Object[])new Object[0]));
            } else {
                tooltip.add(I18n.func_135052_a((String)"arcanearchives.tooltip.brazier.visualizer.show1", (Object[])new Object[0]));
                tooltip.add(I18n.func_135052_a((String)"arcanearchives.tooltip.brazier.visualizer.show2", (Object[])new Object[0]));
            }
            this.func_146283_a(tooltip, mouseX, mouseY);
            return;
        }
        if (mouseY >= this.field_147009_r + 6 && mouseY <= this.field_147009_r + 6 + 16 && mouseX >= this.field_147003_i + 29 && mouseX <= this.field_147003_i + 29 + 8) {
            ArrayList<String> tooltip = new ArrayList<String>();
            tooltip.add(I18n.func_135052_a((String)"arcanearchives.tooltip.brazier.radius.decrease", (Object[])new Object[0]));
            this.func_146283_a(tooltip, mouseX, mouseY);
            return;
        }
        if (mouseY >= this.field_147009_r + 6 && mouseY <= this.field_147009_r + 6 + 16 && mouseX >= this.field_147003_i + 85 && mouseX <= this.field_147003_i + 85 + 8) {
            ArrayList<String> tooltip = new ArrayList<String>();
            tooltip.add(I18n.func_135052_a((String)"arcanearchives.tooltip.brazier.radius.increase", (Object[])new Object[0]));
            this.func_146283_a(tooltip, mouseX, mouseY);
            return;
        }
    }
}

