/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.client;

import com.aranaira.arcanearchives.client.render.LineHandler;
import com.aranaira.arcanearchives.config.ConfigHandler;
import com.aranaira.arcanearchives.data.ClientNetwork;
import com.aranaira.arcanearchives.data.DataHelper;
import com.aranaira.arcanearchives.init.ItemRegistry;
import com.aranaira.arcanearchives.integration.jei.JEIUnderMouse;
import com.aranaira.arcanearchives.items.ManifestItem;
import com.aranaira.arcanearchives.network.Networking;
import com.aranaira.arcanearchives.network.PacketArcaneGems;
import com.aranaira.arcanearchives.util.ManifestTrackingUtils;
import com.aranaira.arcanearchives.util.ManifestUtils;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

@Mod.EventBusSubscriber(modid="arcanearchives")
public class Keybinds {
    public static final String ARCARC_GROUP = "arcanearchives.gui.keygroup";
    public static final String ARCARC_BINDS = "arcanearchives.gui.keybinds";
    public static KeyBinding manifestKey = null;
    public static KeyBinding socketKey = null;

    public static void initKeybinds() {
        KeyBinding kb = new KeyBinding("arcanearchives.gui.keybinds.manifest", 0, ARCARC_GROUP);
        ClientRegistry.registerKeyBinding((KeyBinding)kb);
        manifestKey = kb;
        if (ConfigHandler.ArsenalConfig.EnableArsenal) {
            kb = new KeyBinding("arcanearchives.gui.keybinds.socket", 0, ARCARC_GROUP);
            ClientRegistry.registerKeyBinding((KeyBinding)kb);
            socketKey = kb;
        }
    }

    @SideOnly(value=Side.CLIENT)
    @Nullable
    private static ItemStack underMouse(Minecraft mc) {
        GuiContainer container;
        Slot underMouse;
        ItemStack jei = JEIUnderMouse.underMouse();
        if (jei != null) {
            return jei;
        }
        if (mc.field_71462_r instanceof GuiContainer && (underMouse = (container = (GuiContainer)mc.field_71462_r).getSlotUnderMouse()) != null) {
            return underMouse.func_75211_c();
        }
        return null;
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onKeyInputManifest(InputEvent.KeyInputEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (manifestKey.func_151470_d() && mc.field_71415_G) {
            boolean foundManifest = false;
            if (ConfigHandler.ManifestConfig.ManifestPresence) {
                for (int i = 0; i < 36; ++i) {
                    ItemStack item = mc.field_71439_g.field_71071_by.func_70301_a(i);
                    if (item.func_77973_b() != ItemRegistry.MANIFEST) continue;
                    foundManifest = true;
                    break;
                }
            }
            if (foundManifest || !ConfigHandler.ManifestConfig.ManifestPresence) {
                if (mc.field_71439_g.func_70093_af()) {
                    LineHandler.clearChests(mc.field_71439_g.field_71093_bK);
                } else {
                    ManifestItem.openManifest(mc.field_71439_g.field_70170_p, (EntityPlayer)mc.field_71439_g);
                }
            } else {
                mc.field_71439_g.func_145747_a(new TextComponentTranslation("arcanearchives.gui.missing_manifest", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW)));
            }
        } else if (socketKey != null && socketKey.func_151470_d() && mc.field_71415_G) {
            PacketArcaneGems.OpenSocket packet = new PacketArcaneGems.OpenSocket();
            Networking.CHANNEL.sendToServer((IMessage)packet);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onKeypress(GuiScreenEvent.KeyboardInputEvent.Pre event) {
        if (Keyboard.getEventKeyState() && manifestKey.isActiveAndMatches(Keyboard.getEventKey())) {
            ItemStack stack;
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71462_r != null && (stack = Keybinds.underMouse(mc)) != null && !stack.func_190926_b()) {
                ClientNetwork network = DataHelper.getClientNetwork();
                network.synchroniseManifest(handler -> {
                    handler.setSearchItem(stack);
                    boolean addedValues = false;
                    for (int i = 0; i < handler.getSlots(); ++i) {
                        ManifestUtils.CollatedEntry entry = handler.getManifestEntryInSlot(i);
                        if (entry == null || entry.outOfDimension || entry.outOfRange) continue;
                        ManifestTrackingUtils.add(entry);
                        addedValues = true;
                    }
                    if (!GuiScreen.func_146272_n() && addedValues) {
                        mc.field_71439_g.func_71053_j();
                    }
                });
            }
        }
    }
}

