/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.blocks.templates;

import com.aranaira.arcanearchives.ArcaneArchives;
import com.aranaira.arcanearchives.blocks.IHasModel;
import com.aranaira.arcanearchives.blocks.MultiblockSize;
import com.aranaira.arcanearchives.blocks.templates.BlockDirectionalTemplate;
import com.aranaira.arcanearchives.init.BlockRegistry;
import com.aranaira.arcanearchives.tileentities.AATileEntity;
import com.aranaira.arcanearchives.tileentities.ImmanenceTileEntity;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;

public class BlockTemplate
extends Block
implements IHasModel {
    public static PropertyBool ACCESSOR = PropertyBool.func_177716_a((String)"accessor");
    public MultiblockSize size;
    private int placeLimit = -1;
    private Class<? extends AATileEntity> entityClass;
    private ItemBlock itemBlock = null;

    public BlockTemplate(String name, Material materialIn) {
        super(materialIn);
        this.func_149663_c(name);
        this.setRegistryName(new ResourceLocation("arcanearchives", name));
        this.func_149647_a(ArcaneArchives.TAB);
        this.setHarvestLevel("pickaxe", 0);
    }

    public ItemBlock getItemBlock() {
        return this.itemBlock;
    }

    public void setItemBlock(ItemBlock itemBlock) {
        this.itemBlock = itemBlock;
        assert (this.getRegistryName() != null);
        this.itemBlock.setRegistryName(this.getRegistryName());
    }

    public ITextComponent getNameComponent() {
        return new TextComponentTranslation(String.format("%s.name", this.func_149739_a()), new Object[0]);
    }

    public Class<? extends AATileEntity> getEntityClass() {
        return this.entityClass;
    }

    public void setEntityClass(Class<? extends AATileEntity> clazz) {
        this.entityClass = clazz;
    }

    public int getPlaceLimit() {
        return this.placeLimit;
    }

    public void setPlaceLimit(int newPlaceLimit) {
        this.placeLimit = newPlaceLimit;
    }

    public void setSize(int w, int h, int l) {
        this.size = new MultiblockSize(w, h, l);
    }

    public boolean hasOBJModel() {
        return false;
    }

    @Override
    public void registerModels() {
        if (Item.func_150898_a((Block)this) != Items.field_190931_a) {
            ArcaneArchives.proxy.registerItemRenderer(Item.func_150898_a((Block)this), 0, "inventory");
        }
    }

    public void func_180633_a(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityLivingBase placer, @Nonnull ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        if (!world.field_72995_K) {
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof AATileEntity) {
                if (placer instanceof FakePlayer) {
                    ArcaneArchives.logger.error(String.format("TileEntity placed by FakePlayer at %d,%d,%d is invalid and not linked to the network.", pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()));
                } else {
                    if (te instanceof ImmanenceTileEntity) {
                        ImmanenceTileEntity ite = (ImmanenceTileEntity)te;
                        UUID newId = placer.func_110124_au();
                        ite.setNetworkId(newId);
                        ite.dimension = placer.field_71093_bK;
                    }
                    AATileEntity ate = (AATileEntity)te;
                    ate.setSize(this.getSize());
                }
            }
            if (this.hasAccessors() || this == BlockRegistry.LECTERN_MANIFEST) {
                for (BlockPos point : this.calculateAccessors(world, pos)) {
                    world.func_175656_a(point, this.func_176223_P().func_177226_a((IProperty)ACCESSOR, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)BlockDirectionalTemplate.FACING, (Comparable)EnumFacing.func_176733_a((double)(placer.field_70177_z - 90.0f))));
                }
            }
        }
    }

    public MultiblockSize getSize() {
        if (this.size == null) {
            return new MultiblockSize(0, 0, 0);
        }
        return this.size;
    }

    public void setSize(MultiblockSize newSize) {
        this.size = newSize;
    }

    public boolean hasAccessors() {
        return this.size != null && this.size.hasAccessors();
    }

    public List<BlockPos> calculateAccessors(World world, BlockPos pos) {
        return this.calculateAccessors(world, pos, null);
    }

    public List<BlockPos> calculateAccessors(World world, BlockPos pos, @Nullable EnumFacing facing) {
        int steps;
        BlockPos stop;
        MultiblockSize size = this.getSize();
        if (facing == null) {
            facing = this.getFacing(world, pos);
        }
        EnumFacing curOffset = EnumFacing.func_176733_a((double)(facing.func_185119_l() - (float)(size.width == size.length ? 90 : 180)));
        BlockPos start = pos;
        if (size.width == 2) {
            stop = pos.func_177967_a(curOffset, 1);
        } else {
            steps = (size.width - 1) / 2;
            stop = pos.func_177967_a(curOffset, steps);
            start = pos.func_177967_a(curOffset.func_176734_d(), steps);
        }
        if (size.length == 2) {
            stop = stop.func_177967_a(facing, 1);
        } else {
            steps = (size.length - 1) / 2;
            stop = stop.func_177967_a(facing, steps);
            start = start.func_177967_a(facing.func_176734_d(), steps);
        }
        for (int i = 1; i < size.height; ++i) {
            stop = stop.func_177984_a();
        }
        ArrayList output = Lists.newArrayList((Iterable)BlockPos.func_177980_a((BlockPos)start, (BlockPos)stop));
        output.removeIf(f -> f.equals((Object)pos));
        return output;
    }

    @Nonnull
    public EnumFacing getFacing(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() instanceof BlockDirectionalTemplate) {
            return (EnumFacing)state.func_177229_b((IProperty)BlockDirectionalTemplate.FACING);
        }
        return EnumFacing.WEST;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[0]);
    }
}

