/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.blocks;

import com.aranaira.arcanearchives.blocks.templates.BlockDirectionalTemplate;
import com.aranaira.arcanearchives.client.render.LineHandler;
import com.aranaira.arcanearchives.init.BlockRegistry;
import com.aranaira.arcanearchives.inventory.handlers.OptionalUpgradesHandler;
import com.aranaira.arcanearchives.inventory.handlers.SizeUpgradeItemHandler;
import com.aranaira.arcanearchives.items.templates.IItemScepter;
import com.aranaira.arcanearchives.tileentities.RadiantTroveTileEntity;
import com.aranaira.arcanearchives.util.ItemUtils;
import com.aranaira.arcanearchives.util.WorldUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class RadiantTrove
extends BlockDirectionalTemplate {
    public static final String NAME = "radiant_trove";

    public RadiantTrove() {
        super(NAME, Material.field_151573_f);
        this.setSize(1, 1, 1);
        this.func_149715_a(1.0f);
        this.func_149711_c(3.0f);
        this.func_149752_b(6000.0f);
        this.setHarvestLevel("pickaxe", 0);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(TextFormatting.GOLD + I18n.func_135052_a((String)"arcanearchives.tooltip.device.radiant_trove", (Object[])new Object[0]));
    }

    public boolean func_176214_u(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Items.field_190931_a;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (player.field_71075_bZ.field_75098_d && !(player.func_184614_ca().func_77973_b() instanceof IItemScepter)) {
            this.func_180649_a(world, pos, player);
            return false;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        player.func_71029_a(StatList.func_188055_a((Block)this));
        player.func_71020_j(0.005f);
        if (worldIn.field_72995_K) {
            return;
        }
        this.harvesters.set(player);
        if (player.field_71071_by.func_70448_g().func_77973_b() instanceof IItemScepter && player.func_70093_af() && te instanceof RadiantTroveTileEntity) {
            RadiantTroveTileEntity rte = (RadiantTroveTileEntity)te;
            if (rte != null) {
                ItemStack s;
                int i;
                RadiantTroveTileEntity.TroveItemHandler handler = rte.getInventory();
                while (!handler.isEmpty()) {
                    ItemStack s2 = handler.extractItem(0, 64, false);
                    RadiantTrove.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)s2);
                }
                OptionalUpgradesHandler optionals = rte.getOptionalUpgradesHandler();
                SizeUpgradeItemHandler size = rte.getSizeUpgradesHandler();
                for (i = 0; i < optionals.getSlots(); ++i) {
                    s = optionals.getStackInSlot(i);
                    if (stack.func_190926_b()) continue;
                    RadiantTrove.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)s);
                }
                for (i = 0; i < size.getSlots(); ++i) {
                    s = size.getStackInSlot(i);
                    if (stack.func_190926_b()) continue;
                    RadiantTrove.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)s);
                }
                RadiantTrove.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((Item)this.getItemBlock()));
            }
        } else {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            items.add(RadiantTrove.generateStack(te, (IBlockAccess)worldIn, pos));
            ForgeEventFactory.fireBlockHarvesting(items, (World)worldIn, (BlockPos)pos, (IBlockState)state, (int)0, (float)1.0f, (boolean)true, (EntityPlayer)player);
            for (ItemStack item : items) {
                RadiantTrove.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)item);
            }
        }
        this.harvesters.set(null);
    }

    private static ItemStack generateStack(TileEntity incomingTe, IBlockAccess world, BlockPos pos) {
        if (!(incomingTe instanceof RadiantTroveTileEntity)) {
            return new ItemStack((Item)BlockRegistry.RADIANT_TROVE.getItemBlock());
        }
        RadiantTroveTileEntity te = (RadiantTroveTileEntity)incomingTe;
        if (te.wasCreativeDrop) {
            return ItemStack.field_190927_a;
        }
        NBTTagCompound tag = new NBTTagCompound();
        te.serializeStack(tag);
        ItemStack stack = new ItemStack((Item)BlockRegistry.RADIANT_TROVE.getItemBlock());
        stack.func_77982_d(tag);
        return stack;
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        RadiantTroveTileEntity te = WorldUtil.getTileEntity(RadiantTroveTileEntity.class, (IBlockAccess)worldIn, pos);
        if (te != null) {
            te.wasCreativeDrop = player.field_71075_bZ.field_75098_d;
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        LineHandler.removeLine(pos, player.field_71093_bK);
        if (!world.field_72995_K && hand == EnumHand.MAIN_HAND) {
            RadiantTroveTileEntity te = WorldUtil.getTileEntity(RadiantTroveTileEntity.class, (IBlockAccess)world, pos);
            if (te == null) {
                return false;
            }
            te.onRightClickTrove(player);
            return true;
        }
        return true;
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        IBlockState state = world.func_180495_p(pos);
        LineHandler.removeLine(pos, player.field_71093_bK);
        if (state.func_177230_c() == BlockRegistry.RADIANT_TROVE && !world.field_72995_K) {
            EnumFacing facing = EnumFacing.func_176733_a((double)((double)((EnumFacing)state.func_177229_b((IProperty)FACING)).func_185119_l() - 90.0));
            RayTraceResult rayResult = ForgeHooks.rayTraceEyes((EntityLivingBase)player, (double)(((EntityPlayerMP)player).field_71134_c.getBlockReachDistance() + 1.0));
            if (rayResult == null) {
                return;
            }
            EnumFacing side = rayResult.field_178784_b;
            if (side == facing || side == EnumFacing.UP) {
                RadiantTroveTileEntity te = WorldUtil.getTileEntity(RadiantTroveTileEntity.class, (IBlockAccess)world, pos);
                if (te == null) {
                    return;
                }
                te.onLeftClickTrove(player);
            }
        }
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new RadiantTroveTileEntity();
    }

    @ParametersAreNonnullByDefault
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        LineHandler.removeLine(pos, world.field_73011_w.getDimension());
        world.func_175666_e(pos, (Block)this);
        super.func_180663_b(world, pos, state);
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return new AxisAlignedBB(0.2, 0.0, 0.2, 0.8, 1.0, 0.8);
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        return ItemUtils.calculateRedstoneFromTileEntity(worldIn.func_175625_s(pos));
    }

    @Override
    public void func_180633_a(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityLivingBase placer, @Nonnull ItemStack stack) {
        RadiantTroveTileEntity te;
        super.func_180633_a(world, pos, state, placer, stack);
        if (stack.func_77942_o() && (te = WorldUtil.getTileEntity(RadiantTroveTileEntity.class, (IBlockAccess)world, pos)) != null) {
            te.deserializeStack(stack.func_77978_p());
            te.func_70296_d();
            te.defaultServerSideUpdate();
        }
    }

    public float func_180647_a(IBlockState state, EntityPlayer player, World worldIn, BlockPos pos) {
        if (player.field_71071_by.func_70448_g().func_77973_b() instanceof IItemScepter) {
            float hardness = state.func_185887_b(worldIn, pos);
            return 5.0f / hardness / 30.0f;
        }
        return super.func_180647_a(state, player, worldIn, pos);
    }
}

