/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.blocks;

import com.aranaira.arcanearchives.blocks.templates.BlockTemplate;
import com.aranaira.arcanearchives.config.ConfigHandler;
import com.aranaira.arcanearchives.tileentities.RadiantResonatorTileEntity;
import com.aranaira.arcanearchives.util.WorldUtil;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class RadiantResonator
extends BlockTemplate {
    public static final String name = "radiant_resonator";

    public RadiantResonator() {
        super(name, Material.field_151573_f);
        this.setPlaceLimit(ConfigHandler.serverSideConfig.ResonatorLimit);
        this.func_149711_c(3.0f);
        this.setHarvestLevel("pickaxe", 0);
        this.setEntityClass(RadiantResonatorTileEntity.class);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(TextFormatting.GOLD + I18n.func_135052_a((String)"arcanearchives.tooltip.device.radiant_resonator", (Object[])new Object[0]));
    }

    @Override
    public boolean hasOBJModel() {
        return true;
    }

    public boolean func_176214_u(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        super.func_180650_b(worldIn, pos, state, rand);
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        RadiantResonatorTileEntity te = WorldUtil.getTileEntity(RadiantResonatorTileEntity.class, (IBlockAccess)worldIn, pos);
        if (te == null) {
            return 0;
        }
        RadiantResonatorTileEntity.TickResult tr = te.canTick();
        if (tr == RadiantResonatorTileEntity.TickResult.OFFLINE || tr == RadiantResonatorTileEntity.TickResult.OBSTRUCTION) {
            return 0;
        }
        if (te.canTick() == RadiantResonatorTileEntity.TickResult.HARVEST_WAITING) {
            return 15;
        }
        return Math.max(1, Math.min((int)Math.floor((double)te.getPercentageComplete() / 7.14) + 1, 14));
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new RadiantResonatorTileEntity();
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof RadiantResonatorTileEntity) {
            ((RadiantResonatorTileEntity)te).breakBlock(state, true);
        }
        super.func_180663_b(world, pos, state);
    }
}

