/*
 * Decompiled with CFR 0.152.
 */
package rocks.gameonthe.rockytweaks.crafttweaker.anvil;

import com.blamejared.mtlib.helpers.LogHelper;
import com.blamejared.mtlib.utils.BaseListAddition;
import com.blamejared.mtlib.utils.BaseListRemoval;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.recipes.IRecipeFunction;
import java.util.List;
import rocks.gameonthe.rockytweaks.crafttweaker.anvil.AnvilListener;
import rocks.gameonthe.rockytweaks.crafttweaker.anvil.AnvilRecipe;
import rocks.gameonthe.rockytweaks.crafttweaker.anvil.AnvilRestriction;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.rockytweaks.Anvil")
@ZenRegister
public class AnvilRecipeHandler {
    protected static final String NAME = "Anvil";
    private static boolean removeAll = false;
    private static final List<AnvilRecipe> recipes = Lists.newArrayList();
    private static final List<AnvilRestriction> blacklist = Lists.newArrayList();

    @ZenMethod
    public static void removeAll() {
        removeAll = true;
    }

    @ZenMethod
    public static void addRecipe(IIngredient left, IIngredient right, IItemStack output, int cost, @Optional IRecipeFunction function) {
        Preconditions.checkNotNull((Object)left);
        Preconditions.checkNotNull((Object)right);
        Preconditions.checkNotNull((Object)output);
        Preconditions.checkArgument((cost > 0 ? 1 : 0) != 0);
        CraftTweakerAPI.apply((IAction)new Add(new AnvilRecipe(left, right, output, cost, function)));
    }

    @ZenMethod
    public static void remove(IIngredient[] input) {
        Preconditions.checkNotNull((Object)input);
        Preconditions.checkArgument((input.length >= 1 && input.length <= 2 ? 1 : 0) != 0);
        CraftTweakerAPI.apply((IAction)new Remove(new AnvilRestriction(input)));
    }

    @ZenMethod
    public static void remove(IIngredient output) {
        Preconditions.checkNotNull((Object)output);
        CraftTweakerAPI.apply((IAction)new Remove(new AnvilRestriction(output)));
    }

    public static boolean isRemoveAll() {
        return removeAll;
    }

    public static List<AnvilRecipe> getRecipes() {
        return recipes;
    }

    public static List<AnvilRestriction> getBlacklist() {
        return blacklist;
    }

    static {
        new AnvilListener();
    }

    private static class Remove
    extends BaseListRemoval<AnvilRestriction> {
        public Remove(AnvilRestriction restriction) {
            super(AnvilRecipeHandler.NAME, blacklist);
            this.recipes.add(restriction);
        }

        public void apply() {
            if (!this.recipes.isEmpty()) {
                for (AnvilRestriction restriction : this.recipes) {
                    if (restriction != null) {
                        if (blacklist.add(restriction)) {
                            this.successful.add(restriction);
                            continue;
                        }
                        LogHelper.logError((String)String.format("Error blacklisting anvil input %s", this.getRecipeInfo(restriction)));
                        continue;
                    }
                    LogHelper.logError((String)"Error adding anvil input: null object");
                }
            }
        }

        public String getRecipeInfo(AnvilRestriction restriction) {
            return LogHelper.getStackDescription((Object)restriction);
        }
    }

    private static class Add
    extends BaseListAddition<AnvilRecipe> {
        public Add(AnvilRecipe recipe) {
            super(AnvilRecipeHandler.NAME, recipes);
            this.recipes.add(recipe);
        }

        public void apply() {
            if (!this.recipes.isEmpty()) {
                for (AnvilRecipe recipe : this.recipes) {
                    if (recipe != null) {
                        if (recipes.add(recipe)) {
                            this.successful.add(recipe);
                            recipe.setValid(true);
                            continue;
                        }
                        LogHelper.logError((String)String.format("Error adding %s Recipe for %s", this.name, this.getRecipeInfo(recipe)));
                        continue;
                    }
                    LogHelper.logError((String)String.format("Error adding %s Recipe: null object", this.name));
                }
            }
        }

        public String getRecipeInfo(AnvilRecipe recipe) {
            return LogHelper.getStackDescription((Object)recipe.getOutputStack());
        }
    }
}

