/*
 * Decompiled with CFR 0.152.
 */
package serenetweaks.handlers;

import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import sereneseasons.api.season.BiomeHooks;
import sereneseasons.api.season.Season;
import sereneseasons.api.season.SeasonHelper;
import serenetweaks.config.ModOptions;
import serenetweaks.data.TimeStampsWorldSavedData;

public class SnowRecalculationHandler {
    private static ArrayList<Chunk> recalculationQueue = new ArrayList();

    @SubscribeEvent
    public void onTick(TickEvent.WorldTickEvent event) {
        TickEvent.Type type = event.type;
        Side side = event.side;
        TickEvent.Phase phase = event.phase;
        World world = event.world;
        if (world.field_73011_w.getDimension() != 0) {
            return;
        }
        if (type != TickEvent.Type.WORLD || side != Side.SERVER) {
            return;
        }
        if (world.field_72995_K) {
            return;
        }
        if (recalculationQueue.size() == 0) {
            return;
        }
        int i = 0;
        int c = 0;
        while (recalculationQueue.size() > i && c < 20) {
            Chunk chunk = recalculationQueue.get(i);
            if (chunk.func_177410_o() && chunk.func_150802_k()) {
                boolean success = true;
                BlockPos pos = new BlockPos(chunk.field_76635_g * 16, 0, chunk.field_76647_h * 16);
                for (int k2 = 0; k2 < 16; ++k2) {
                    for (int j3 = 0; j3 < 16; ++j3) {
                        BlockPos blockpos1 = chunk.func_177440_h(pos.func_177982_a(k2, 0, j3));
                        BlockPos blockpos2 = blockpos1.func_177977_b();
                        if (world.func_175675_v(blockpos2)) {
                            boolean bl = success = success && world.func_180501_a(blockpos2, Blocks.field_150432_aD.func_176223_P(), 2);
                        }
                        if (world.func_175708_f(blockpos1, true)) {
                            boolean bl = success = success && world.func_180501_a(blockpos1, Blocks.field_150431_aC.func_176223_P(), 2);
                        }
                        if (!this.shouldMelt(world, blockpos2)) continue;
                        if (world.func_180495_p(blockpos2).func_177230_c() == Blocks.field_150432_aD) {
                            boolean bl = success = success && world.func_180501_a(blockpos2, Blocks.field_150355_j.func_176223_P(), 2);
                        }
                        if (world.func_180495_p(blockpos1).func_177230_c() != Blocks.field_150431_aC) continue;
                        success = success && world.func_180501_a(blockpos1, Blocks.field_150350_a.func_176223_P(), 2);
                    }
                }
                if (success) {
                    recalculationQueue.remove(i);
                    ++c;
                    continue;
                }
                ++i;
                continue;
            }
            ++i;
        }
    }

    @SubscribeEvent
    public void onChunkLoaded(ChunkEvent.Load event) {
        int savedTime;
        if (!ModOptions.Settings.shouldRecalculateSnow) {
            return;
        }
        World world = event.getWorld();
        if (world.field_72995_K) {
            return;
        }
        Chunk chunk = event.getChunk();
        if (world.field_73011_w.getDimension() != 0) {
            return;
        }
        int currentTime = (int)(System.currentTimeMillis() / 1000L / 60L);
        if (currentTime - (savedTime = TimeStampsWorldSavedData.getChunkTimeStamp(chunk)) > ModOptions.Settings.timeToRecalculateSnow) {
            recalculationQueue.add(chunk);
        }
    }

    @SubscribeEvent
    public void playerJoinedWorld(PlayerEvent.PlayerLoggedInEvent event) {
        if (!ModOptions.Settings.shouldRecalculateSnow) {
            return;
        }
        EntityPlayer player = event.player;
        World world = player.field_70170_p;
        if (world.field_73011_w.getDimension() != 0) {
            return;
        }
        if (world.field_72995_K) {
            return;
        }
        for (int i = -5; i < 5; ++i) {
            for (int j = -5; j < 5; ++j) {
                int savedTime;
                Chunk chunk = world.func_72964_e((int)player.field_70165_t / 16 + i, (int)player.field_70161_v / 16 + j);
                int currentTime = (int)(System.currentTimeMillis() / 1000L / 60L);
                if (currentTime - (savedTime = TimeStampsWorldSavedData.getChunkTimeStamp(chunk)) <= ModOptions.Settings.timeToRecalculateSnow) continue;
                recalculationQueue.add(chunk);
            }
        }
    }

    @SubscribeEvent
    public void onChunkUnLoaded(ChunkEvent.Unload event) {
        World world = event.getWorld();
        if (world.field_72995_K) {
            return;
        }
        Chunk chunk = event.getChunk();
        if (world.field_73011_w.getDimension() != 0) {
            return;
        }
        if (!this.removeFromRecalculationQueue(chunk)) {
            int currentTime = (int)(System.currentTimeMillis() / 1000L / 60L);
            TimeStampsWorldSavedData.setChunkTimeStamp(chunk, currentTime);
        }
    }

    @SubscribeEvent
    public void playerLeftWorld(PlayerEvent.PlayerLoggedOutEvent event) {
        EntityPlayer player = event.player;
        World world = player.field_70170_p;
        if (world.field_73011_w.getDimension() != 0) {
            return;
        }
        if (world.field_72995_K) {
            return;
        }
        int currentTime = (int)(System.currentTimeMillis() / 1000L / 60L);
        for (int i = -5; i < 5; ++i) {
            for (int j = -5; j < 5; ++j) {
                Chunk chunk = world.func_72964_e((int)player.field_70165_t / 16 + i, (int)player.field_70161_v / 16 + j);
                if (this.removeFromRecalculationQueue(chunk)) continue;
                TimeStampsWorldSavedData.setChunkTimeStamp(chunk, currentTime);
            }
        }
    }

    private boolean shouldMelt(World world, BlockPos pos) {
        Biome biome = world.func_180494_b(pos);
        Season.SubSeason subSeason = SeasonHelper.getSeasonState((World)world).getSubSeason();
        float f = BiomeHooks.getFloatTemperature((Season.SubSeason)subSeason, (Biome)biome, (BlockPos)pos);
        return f >= 0.15f;
    }

    private boolean removeFromRecalculationQueue(Chunk chunk) {
        for (int i = 0; i < recalculationQueue.size(); ++i) {
            Chunk queueChunk = recalculationQueue.get(i);
            if (chunk.func_76632_l().field_77276_a != queueChunk.func_76632_l().field_77276_a || chunk.func_76632_l().field_77275_b != queueChunk.func_76632_l().field_77275_b) continue;
            recalculationQueue.remove(i);
            --i;
            return true;
        }
        return false;
    }
}

