/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.artisanintegrations.modules.patchouli;

import com.codetaylor.mc.athenaeum.module.ModuleBase;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import vazkii.patchouli.api.PatchouliAPI;

public class ModulePatchouli
extends ModuleBase {
    public static final String MOD_ID = "artisanintegrations";
    private static final String TEMPLATE_FOLDER = "patchouli/templates/";
    private static final Logger LOGGER = LogManager.getLogger(ModulePatchouli.class);

    public ModulePatchouli() {
        super(0, MOD_ID);
    }

    public void onClientPreInitializationEvent(FMLPreInitializationEvent event) {
        super.onClientPreInitializationEvent(event);
        this.registerIncludes("worktable", "workstation", "workshop");
    }

    private void registerIncludes(String ... names) {
        for (String name : names) {
            this.registerInclude(name);
        }
    }

    private void registerInclude(String name) {
        ResourceLocation internalResourceLocation = new ResourceLocation(MOD_ID, TEMPLATE_FOLDER + name + ".json");
        ResourceLocation externalResourceLocation = new ResourceLocation(MOD_ID, name);
        PatchouliAPI.instance.registerTemplateAsBuiltin(externalResourceLocation, () -> {
            try {
                Minecraft minecraft = Minecraft.func_71410_x();
                IResourceManager resourceManager = minecraft.func_110442_L();
                IResource resource = resourceManager.func_110536_a(internalResourceLocation);
                return resource.func_110527_b();
            }
            catch (Exception e) {
                LOGGER.error("Error loading template: " + internalResourceLocation, (Throwable)e);
                return null;
            }
        });
    }
}

