/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.artisanintegrations.modules.gregtech.tool;

import com.codetaylor.mc.artisanintegrations.modules.gregtech.ModuleGregTech;
import com.codetaylor.mc.artisanworktables.api.recipe.IToolHandler;
import gregtech.api.items.IToolItem;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class ToolHandler
implements IToolHandler {
    private GTCEMethodHandleWrapper methodHandleWrapper;

    public ToolHandler() {
        MethodHandle methodHandle;
        ReflectiveOperationException errorGTCE = null;
        ReflectiveOperationException errorGTCEu = null;
        try {
            methodHandle = MethodHandles.publicLookup().findVirtual(IToolItem.class, "damageItem", MethodType.methodType(Boolean.TYPE, ItemStack.class, Integer.TYPE, Boolean.TYPE));
            this.methodHandleWrapper = new GTCEMethodHandleWrapper(methodHandle){

                @Override
                boolean damageItem(IToolItem item, ItemStack itemStack, int damage, boolean simulate) {
                    try {
                        return this.methodHandle.invoke(item, itemStack, damage, simulate);
                    }
                    catch (Throwable e) {
                        ModuleGregTech.LOGGER.error("Unable to invoke GTCE API method handle: " + this.methodHandle.toString(), e);
                        return false;
                    }
                }
            };
            ModuleGregTech.LOGGER.info("Bound GTCE method handle for gregtech.api.items.IToolItem$damageItem: " + methodHandle.toString());
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            this.methodHandleWrapper = null;
            errorGTCE = e;
        }
        if (this.methodHandleWrapper == null) {
            try {
                methodHandle = MethodHandles.publicLookup().findVirtual(IToolItem.class, "damageItem", MethodType.methodType(Boolean.TYPE, ItemStack.class, EntityLivingBase.class, Integer.TYPE, Boolean.TYPE));
                this.methodHandleWrapper = new GTCEMethodHandleWrapper(methodHandle){

                    @Override
                    boolean damageItem(IToolItem item, ItemStack itemStack, int damage, boolean simulate) {
                        try {
                            return this.methodHandle.invoke(item, itemStack, null, damage, simulate);
                        }
                        catch (Throwable e) {
                            ModuleGregTech.LOGGER.error("Unable to invoke GTCEu API method handle: " + this.methodHandle.toString(), e);
                            return false;
                        }
                    }
                };
                ModuleGregTech.LOGGER.info("Bound GTCEu method handle for gregtech.api.items.IToolItem$damageItem: " + methodHandle.toString());
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                this.methodHandleWrapper = null;
                errorGTCEu = e;
            }
        }
        if (this.methodHandleWrapper == null) {
            ModuleGregTech.LOGGER.error("Unable to bind API method IToolItem$damageItem for GTCE", (Throwable)errorGTCE);
            ModuleGregTech.LOGGER.error("Unable to bind API method IToolItem$damageItem for GTCEu", (Throwable)errorGTCEu);
        }
    }

    public boolean matches(ItemStack itemStack) {
        return itemStack.func_77973_b() instanceof IToolItem;
    }

    public boolean matches(ItemStack tool, ItemStack toolToMatch) {
        return tool.func_77973_b() == toolToMatch.func_77973_b() && tool.func_77960_j() == toolToMatch.func_77960_j();
    }

    public boolean canAcceptAllDamage(ItemStack itemStack, int damage) {
        return this.damageItem(itemStack, damage, true);
    }

    public boolean applyDamage(World world, ItemStack itemStack, int damage, @Nullable EntityPlayer player, boolean simulate) {
        if (!simulate && world.field_72995_K && itemStack.func_77978_p() != null) {
            itemStack.func_77982_d(itemStack.func_77978_p().func_74737_b());
        }
        return !this.damageItem(itemStack, damage, simulate);
    }

    private boolean damageItem(ItemStack itemStack, int damage, boolean simulate) {
        Item item = itemStack.func_77973_b();
        if (item instanceof IToolItem) {
            return this.methodHandleWrapper.damageItem((IToolItem)item, itemStack, damage, simulate);
        }
        return false;
    }

    private static abstract class GTCEMethodHandleWrapper {
        protected final MethodHandle methodHandle;

        protected GTCEMethodHandleWrapper(MethodHandle methodHandle) {
            this.methodHandle = methodHandle;
        }

        abstract boolean damageItem(IToolItem var1, ItemStack var2, int var3, boolean var4);
    }
}

