/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.artisanintegrations.modules.ftgu.requirement;

import com.codetaylor.mc.artisanintegrations.modules.ftgu.ModuleFTGU;
import com.codetaylor.mc.artisanworktables.api.internal.recipe.ICraftingContext;
import com.codetaylor.mc.artisanworktables.api.recipe.requirement.IRequirementContext;
import ftgumod.api.FTGUAPI;
import ftgumod.api.technology.ITechnology;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;

public class FTGURequirementContext
implements IRequirementContext {
    private List<String> researchedTechnologies;

    public void initialize(ICraftingContext craftingContext) {
        Optional optionalPlayer = craftingContext.getPlayer();
        if (optionalPlayer.isPresent()) {
            this.initialize((EntityPlayer)optionalPlayer.get());
        } else {
            this.researchedTechnologies = Collections.emptyList();
        }
    }

    void initialize(EntityPlayer player) {
        Collection technologies = FTGUAPI.technologyManager.getTechnologies();
        ArrayList<String> researched = new ArrayList<String>(technologies.size());
        for (ITechnology technology : technologies) {
            if (!technology.isResearched(player)) continue;
            ResourceLocation registryName = technology.getRegistryName();
            if (registryName != null) {
                researched.add(registryName.toString());
                continue;
            }
            ModuleFTGU.LOGGER.error("Technology missing registry name: " + technology);
        }
        this.researchedTechnologies = Collections.unmodifiableList(researched);
    }

    public List<String> getResearchedTechnologies() {
        return this.researchedTechnologies;
    }
}

