/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.artisanintegrations.modules.ftgu.requirement;

import com.codetaylor.mc.artisanintegrations.modules.ftgu.requirement.FTGURequirementContext;
import com.codetaylor.mc.artisanworktables.api.recipe.requirement.IRequirement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class FTGURequirement
implements IRequirement<FTGURequirementContext> {
    public static final String REQUIREMENT_ID = "ftgumod";
    public static final ResourceLocation LOCATION = new ResourceLocation("artisanintegrations", "ftgumod");
    private final List<String> requireAll;
    private final List<String> requireOne;
    private final List<String> excluded;

    FTGURequirement(@Nonnull Collection<String> requireAll, @Nonnull Collection<String> requireOne, @Nonnull Collection<String> excluded) {
        this.requireAll = new ArrayList<String>(requireAll);
        this.requireOne = new ArrayList<String>(requireOne);
        this.excluded = new ArrayList<String>(excluded);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldJEIHideOnLoad() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldJEIHideOnUpdate() {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        FTGURequirementContext context = new FTGURequirementContext();
        context.initialize((EntityPlayer)player);
        return !this.match(context);
    }

    public ResourceLocation getResourceLocation() {
        return LOCATION;
    }

    public boolean match(FTGURequirementContext context) {
        List<String> researchedTechnologies = context.getResearchedTechnologies();
        for (String excluded : this.excluded) {
            if (!researchedTechnologies.contains(excluded)) continue;
            return false;
        }
        if (!this.requireAll.isEmpty() && !researchedTechnologies.containsAll(this.requireAll)) {
            return false;
        }
        for (String oneStage : this.requireOne) {
            if (!researchedTechnologies.contains(oneStage)) continue;
            return true;
        }
        return this.requireOne.isEmpty();
    }
}

