/*
 * Decompiled with CFR 0.152.
 */
package connor135246.simplyhotsprings.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import connor135246.simplyhotsprings.SimplyHotSprings;
import connor135246.simplyhotsprings.common.blocks.BlockHotSpringWater;
import connor135246.simplyhotsprings.util.GenerationReason;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

@Mod.EventBusSubscriber(modid="simplyhotsprings")
public class SimplyHotSpringsConfig {
    private static final Set<BiomeDictionary.Type> biomeTypeWhitelist = new HashSet<BiomeDictionary.Type>();
    private static final Set<BiomeDictionary.Type> biomeTypeBlacklist = new HashSet<BiomeDictionary.Type>();
    private static final Set<ResourceLocation> biomeNameWhitelist = new HashSet<ResourceLocation>();
    private static final Set<ResourceLocation> biomeNameBlacklist = new HashSet<ResourceLocation>();
    private static final String NO_WARN_DUMMY_ENTRY = ".";
    public static final Object2ObjectOpenHashMap<ResourceLocation, GenerationReason> biomeReasons = new Object2ObjectOpenHashMap(255, 1.0f);
    private static final JsonParser jsonParser;
    private static Boolean bopSprings;

    public static void warnInvalidEntry(String config, String input) {
        SimplyHotSprings.modlog.warn("Config: \"" + config + "\" entry with \"" + input + "\" is invalid");
    }

    public static void fillBiomeSets() {
        ResourceLocation name;
        if (!Config.WorldGen.worldGen) {
            return;
        }
        biomeTypeWhitelist.clear();
        boolean invalidEntries = false;
        block0: for (String input : Config.WorldGen.biomeTypeWhitelist) {
            if (!input.equals(NO_WARN_DUMMY_ENTRY)) {
                for (BiomeDictionary.Type type : BiomeDictionary.Type.getAll()) {
                    if (!type.getName().equalsIgnoreCase(input)) continue;
                    biomeTypeWhitelist.add(type);
                    continue block0;
                }
                SimplyHotSpringsConfig.warnInvalidEntry("Biome Type Whitelist", input);
                invalidEntries = true;
                continue;
            }
            invalidEntries = true;
        }
        if (biomeTypeWhitelist.isEmpty() && invalidEntries) {
            biomeTypeWhitelist.add(null);
        }
        biomeTypeBlacklist.clear();
        block2: for (String input : Config.WorldGen.biomeTypeBlacklist) {
            for (BiomeDictionary.Type type : BiomeDictionary.Type.getAll()) {
                if (!type.getName().equalsIgnoreCase(input)) continue;
                biomeTypeBlacklist.add(type);
                continue block2;
            }
            SimplyHotSpringsConfig.warnInvalidEntry("Biome Type Blacklist", input);
        }
        biomeNameWhitelist.clear();
        invalidEntries = false;
        for (String input : Config.WorldGen.biomeNameWhitelist) {
            if (!input.equals(NO_WARN_DUMMY_ENTRY)) {
                name = new ResourceLocation(input);
                if (ForgeRegistries.BIOMES.containsKey(name)) {
                    biomeNameWhitelist.add(name);
                    continue;
                }
                SimplyHotSpringsConfig.warnInvalidEntry("Biome Name Whitelist", name.toString());
                invalidEntries = true;
                continue;
            }
            invalidEntries = true;
        }
        if (biomeNameWhitelist.isEmpty() && invalidEntries) {
            biomeNameWhitelist.add(null);
        }
        biomeNameBlacklist.clear();
        for (String input : Config.WorldGen.biomeNameBlacklist) {
            name = new ResourceLocation(input);
            if (ForgeRegistries.BIOMES.containsKey(name)) {
                biomeNameBlacklist.add(name);
                continue;
            }
            SimplyHotSpringsConfig.warnInvalidEntry("Biome Name Blacklist", name.toString());
        }
    }

    public static void serverAboutToStart(FMLServerAboutToStartEvent event) {
        bopSprings = null;
        biomeReasons.clear();
        for (Biome biome : ForgeRegistries.BIOMES.getValuesCollection()) {
            biomeReasons.put((Object)biome.getRegistryName(), (Object)SimplyHotSpringsConfig.getGenerationReasonBiome(biome));
        }
    }

    public static GenerationReason getGenerationReasonWorld(World world) {
        if (!Config.WorldGen.worldGen) {
            return GenerationReason.NO_WORLD_GEN;
        }
        if (!Config.WorldGen.worldGenIfBOPSprings && SimplyHotSpringsConfig.areBOPHotSpringsEnabled(world)) {
            return GenerationReason.BOP_SPRINGS;
        }
        if (!Config.WorldGen.worldGenIfSuperflat && world.func_175624_G() == WorldType.field_77138_c && world.field_73011_w.func_186058_p() == DimensionType.OVERWORLD) {
            return GenerationReason.SUPERFLAT;
        }
        if (ArrayUtils.contains((int[])Config.WorldGen.dimWhitelist, (int)world.field_73011_w.getDimension())) {
            return GenerationReason.ALLOW_WORLD;
        }
        if (ArrayUtils.contains((int[])Config.WorldGen.dimBlacklist, (int)world.field_73011_w.getDimension())) {
            return GenerationReason.IN_DIM_BLACKLIST;
        }
        if (Config.WorldGen.dimWhitelist.length != 0) {
            return GenerationReason.NOT_DIM_WHITELISTED;
        }
        return GenerationReason.ALLOW_WORLD;
    }

    public static GenerationReason getGenerationReasonBiome(Biome biome) {
        if (biomeNameWhitelist.contains(biome.getRegistryName())) {
            return GenerationReason.IN_NAME_WHITELIST;
        }
        if (biomeNameBlacklist.contains(biome.getRegistryName())) {
            return GenerationReason.IN_NAME_BLACKLIST;
        }
        Set biomeTypes = BiomeDictionary.getTypes((Biome)biome);
        if (biomeTypeBlacklist.stream().anyMatch(biomeTypes::contains)) {
            return GenerationReason.IN_TYPE_BLACKLIST;
        }
        if (biomeTypeWhitelist.stream().anyMatch(biomeTypes::contains)) {
            return GenerationReason.IN_TYPE_WHITELIST;
        }
        if (biomeNameWhitelist.isEmpty()) {
            return GenerationReason.EMPTY_NAME_WHITELIST;
        }
        if (biomeTypeWhitelist.isEmpty()) {
            return GenerationReason.EMPTY_TYPE_WHITELIST;
        }
        return GenerationReason.NOT_WHITELISTED;
    }

    public static boolean allowedWorld(World world) {
        return SimplyHotSpringsConfig.getGenerationReasonWorld(world).allowsGeneration();
    }

    public static boolean allowedBiome(Biome biome) {
        return ((GenerationReason)((Object)biomeReasons.get((Object)biome.getRegistryName()))).allowsGeneration();
    }

    private static boolean areBOPHotSpringsEnabled(World world) {
        WorldServer overworld;
        if (bopSprings != null) {
            return bopSprings;
        }
        MinecraftServer server = world.func_73046_m();
        if (server != null && (overworld = server.func_71218_a(0)) != null) {
            bopSprings = false;
            if (overworld.func_175624_G().func_77127_a().equals("BIOMESOP")) {
                bopSprings = true;
                String genOptions = overworld.func_72912_H().func_82571_y();
                if (!StringUtils.isBlank((CharSequence)genOptions)) {
                    try {
                        JsonElement parsed = jsonParser.parse(genOptions);
                        if (parsed.isJsonObject()) {
                            bopSprings = JsonUtils.func_151212_i((JsonObject)parsed.getAsJsonObject(), (String)"generateHotSprings");
                        }
                    }
                    catch (JsonParseException jsonParseException) {
                        // empty catch block
                    }
                }
            }
            return bopSprings;
        }
        return false;
    }

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("simplyhotsprings")) {
            ConfigManager.sync((String)"simplyhotsprings", (Config.Type)Config.Type.INSTANCE);
            BlockHotSpringWater.updateConfigSettings();
            if (!event.isWorldRunning()) {
                SimplyHotSpringsConfig.fillBiomeSets();
            }
        }
    }

    public static void removeOldOptions() {
        try {
            Method getMethod = ConfigManager.class.getDeclaredMethod("getConfiguration", String.class, String.class);
            getMethod.setAccessible(true);
            Configuration config = (Configuration)getMethod.invoke(null, "simplyhotsprings", "");
            if (config.renameProperty("general.worldgen", "Generate in Biomes O' Plenty World Type", "Generate Alongside Biomes O' Plenty Hot Springs")) {
                ConfigManager.sync((String)"simplyhotsprings", (Config.Type)Config.Type.INSTANCE);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        biomeReasons.defaultReturnValue((Object)GenerationReason.UNKNOWN_BIOME);
        jsonParser = new JsonParser();
        bopSprings = null;
    }

    @net.minecraftforge.common.config.Config(modid="simplyhotsprings")
    public static class Config {
        @Config.Ignore
        public static final String LANG_CONFIG = "simplyhotsprings.config.";
        @Config.Name(value="Alternate Particles")
        @Config.Comment(value={"Client-side option. If true, Hot Spring Water makes smaller, less obtrusive steam particles instead. ", "Note: these particles are affected by your particle video setting, and won't appear at all if it's set to Minimal."})
        @Config.LangKey(value="simplyhotsprings.config.client.alternateParticles")
        public static boolean alternateParticles = false;
        @Config.Name(value="Creates Source Blocks")
        @Config.Comment(value={"If true, Hot Spring Water makes infinite water sources, like vanilla water does."})
        @Config.LangKey(value="simplyhotsprings.config.createsSources")
        public static boolean createsSources = true;
        @Config.Name(value="Potion Effect")
        @Config.Comment(value={"The namespaced effect that Hot Spring Water applies to entities. If the given effect isn't found (or left blank), no effect is applied."})
        @Config.LangKey(value="simplyhotsprings.config.potionEffect")
        public static String potionEffect = "minecraft:regeneration";
        @Config.Name(value="Potion Effect Settings")
        @Config.Comment(value={"The first value is the duration of the effect (in ticks). The second value is the amplifier of the effect (0 is level 1)."})
        @Config.RangeInt(min=0)
        @Config.LangKey(value="simplyhotsprings.config.potionEffectSettings")
        public static int[] potionEffectSettings = new int[]{50, 0};
        @Config.Comment(value={"Most of these settings can't be changed while a world is open."})
        @Config.LangKey(value="simplyhotsprings.config.worldgen")
        public static WorldGen worldgen;

        public static class WorldGen {
            @Config.Ignore
            public static final String LANG_CONFIG_WORLDGEN = "simplyhotsprings.config.worldgen.";
            @Config.Name(value="#How to fill Whitelists and Blacklists")
            @Config.Comment(value={"The command \"/simplyhotsprings\" has a few subcommands that will help you fill in your whitelists and blacklists and test to see if they work. For example, \"/simplyhotsprings locationinfo\" will tell you your current dimension ID, the name and types of the biome you're currently in, and whether hot springs can generate there. To see how to use \"/simplyhotsprings\", run the command \"/simplyhotsprings help\".", "(Also, this config setting does nothing, so put whatever you want in here.)"})
            @Config.LangKey(value="simplyhotsprings.config.worldgen.info")
            public static String[] info = new String[]{"Run \"/simplyhotsprings biometypes\" to see a list of all Biome Types!", "Run \"/forge dimensions\" to see a list of all currently registered dimensions!"};
            @Config.RequiresWorldRestart
            @Config.Name(value="World Generation")
            @Config.Comment(value={"Set to false to stop hot springs from generating."})
            @Config.LangKey(value="simplyhotsprings.config.worldgen.worldGen")
            public static boolean worldGen = true;
            @Config.Ignore
            public static final String oldBOPGenConfigName = "Generate in Biomes O' Plenty World Type";
            @Config.Ignore
            public static final String newBOPGenConfigName = "Generate Alongside Biomes O' Plenty Hot Springs";
            @Config.RequiresWorldRestart
            @Config.Name(value="Generate Alongside Biomes O' Plenty Hot Springs")
            @Config.Comment(value={"If a world has Biomes O' Plenty hot springs enabled, the hot springs from this mod won't generate. Set this to true to make them generate anyway."})
            @Config.LangKey(value="simplyhotsprings.config.worldgen.worldGenIfBOPSprings")
            public static boolean worldGenIfBOPSprings = false;
            @Config.RequiresWorldRestart
            @Config.Name(value="Generate in Superflat World Type")
            @Config.Comment(value={"If the world type is Superflat, the hot springs from this mod won't generate in the overworld. Set this to true to make them generate anyway."})
            @Config.LangKey(value="simplyhotsprings.config.worldgen.worldGenIfSuperflat")
            public static boolean worldGenIfSuperflat = false;
            @Config.RequiresWorldRestart
            @Config.Name(value="Generation Chance")
            @Config.Comment(value={"The chance for a hot spring to generate is 1 over this value. So lower values are more likely."})
            @Config.RangeInt(min=1)
            @Config.LangKey(value="simplyhotsprings.config.worldgen.chance")
            public static int chance = 275;
            @Config.Name(value="Generation Debug")
            @Config.Comment(value={"When a hot spring generates, prints the location to console."})
            @Config.LangKey(value="simplyhotsprings.config.worldgen.debug")
            public static boolean debug = false;
            @Config.RequiresWorldRestart
            @Config.Name(value="Dimension Whitelist")
            @Config.Comment(value={"The dimension IDs where hot springs are allowed to generate. If empty, all dimensions are allowed."})
            @Config.LangKey(value="simplyhotsprings.config.worldgen.dimWhitelist")
            public static int[] dimWhitelist = new int[]{0};
            @Config.RequiresWorldRestart
            @Config.Name(value="Dimension Blacklist")
            @Config.Comment(value={"The dimension IDs where hot springs are NOT allowed to generate."})
            @Config.LangKey(value="simplyhotsprings.config.worldgen.dimBlacklist")
            public static int[] dimBlacklist = new int[0];
            @Config.RequiresWorldRestart
            @Config.Name(value="Biome Type Whitelist")
            @Config.Comment(value={"The biome types where hot springs are allowed to generate. If empty, all biome types are allowed. ", "The Biome Type Whitelist and Biome Name Whitelist are not both required to be satisfied. You can use a period as a dummy entry. "})
            @Config.LangKey(value="simplyhotsprings.config.worldgen.biomeTypeWhitelist")
            public static String[] biomeTypeWhitelist = new String[0];
            @Config.RequiresWorldRestart
            @Config.Name(value="Biome Type Blacklist")
            @Config.Comment(value={"The biome types where hot springs are NOT allowed to generate."})
            @Config.LangKey(value="simplyhotsprings.config.worldgen.biomeTypeBlacklist")
            public static String[] biomeTypeBlacklist = new String[]{"DRY", "SAVANNA", "NETHER", "END", "OCEAN", "RIVER", "SANDY", "BEACH", "VOID"};
            @Config.RequiresWorldRestart
            @Config.Name(value="Biome Name Whitelist")
            @Config.Comment(value={"The individual biomes where hot springs are allowed to generate. If empty, all biomes are allowed. ", "The Biome Type Whitelist and Biome Name Whitelist are not both required to be satisfied. You can use a period as a dummy entry. "})
            @Config.LangKey(value="simplyhotsprings.config.worldgen.biomeNameWhitelist")
            public static String[] biomeNameWhitelist = new String[0];
            @Config.RequiresWorldRestart
            @Config.Name(value="Biome Name Blacklist")
            @Config.Comment(value={"The individual biomes where hot springs are NOT allowed to generate."})
            @Config.LangKey(value="simplyhotsprings.config.worldgen.biomeNameBlacklist")
            public static String[] biomeNameBlacklist = new String[]{"biomesoplenty:origin_beach", "biomesoplenty:origin_island"};
        }
    }
}

