/*
 * Decompiled with CFR 0.152.
 */
package connor135246.simplyhotsprings.util;

import connor135246.simplyhotsprings.common.world.HotSpringsWorldGen;
import connor135246.simplyhotsprings.util.GenerationReason;
import connor135246.simplyhotsprings.util.SimplyHotSpringsConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandResultStats;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.NumberInvalidException;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class CommandSimplyHotSprings
implements ICommand {
    public static final CommandSimplyHotSprings INSTANCE = new CommandSimplyHotSprings();
    public static final String COMMAND = "simplyhotsprings";
    public static final String HELP = "help";
    public static final String LOCATIONINFO = "locationinfo";
    public static final String BIOMESLIST = "biomeslist";
    public static final String ALL = "all";
    public static final String WITH = "with";
    public static final String WITHOUT = "without";
    public static final String BIOMETYPES = "biometypes";
    public static final String PLACESPRING = "placespring";
    public static final String LANG_COMMAND = "simplyhotsprings.command.";
    public static final String LANG_LOCATIONINFO = "simplyhotsprings.command.locationinfo.";
    public static final String LANG_BIOMESLIST = "simplyhotsprings.command.biomeslist.";
    public static final String LANG_BIOMETYPES = "simplyhotsprings.command.biometypes.";
    public static final String LANG_PLACESPRING = "simplyhotsprings.command.placespring.";
    public static final String LANG_HELP = "simplyhotsprings.command.help.";
    private static final HoverEvent clickForSuggest = new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentTranslation("simplyhotsprings.command.locationinfo.click", new Object[0]));
    private static final HoverEvent clickForInfo = new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentTranslation("simplyhotsprings.command.biomeslist.click", new Object[0]));
    private static final HoverEvent clickForList = new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentTranslation("simplyhotsprings.command.biometypes.click", new Object[0]));
    private static final HoverEvent clickForTeleport = new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentTranslation("simplyhotsprings.command.placespring.click", new Object[0]));
    private static final HoverEvent clickForHelp = new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentTranslation("simplyhotsprings.command.help.click", new Object[0]));
    private static final HoverEvent clickForNext = new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentTranslation("simplyhotsprings.command.next_page", new Object[0]));
    private static final HoverEvent clickForPrevious = new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentTranslation("simplyhotsprings.command.previous_page", new Object[0]));

    public int compareTo(ICommand ico) {
        return this.func_71517_b().compareTo(ico.func_71517_b());
    }

    public String func_71517_b() {
        return COMMAND;
    }

    public String func_71518_a(ICommandSender sender) {
        return "/simplyhotsprings help";
    }

    public List<String> func_71514_a() {
        return Collections.emptyList();
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 1) {
            throw new WrongUsageException(this.func_71518_a(null), new Object[0]);
        }
        if (args[0].equals(HELP)) {
            this.sendHelp(server, sender, args);
        } else if (args[0].equals(LOCATIONINFO)) {
            this.sendLocationInfo(server, sender, args);
        } else if (args[0].equals(BIOMESLIST)) {
            this.sendBiomesList(server, sender, args);
        } else if (args[0].equals(BIOMETYPES)) {
            this.sendBiomeTypes(server, sender, args);
        } else if (args[0].equals(PLACESPRING)) {
            this.placeSpring(server, sender, args);
        } else {
            throw new WrongUsageException(this.func_71518_a(null), new Object[0]);
        }
    }

    public void sendHelp(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        String subcommand = "";
        int helps = 3;
        if (args.length > 1) {
            if (args[1].equals(LOCATIONINFO)) {
                subcommand = LOCATIONINFO;
                helps = 7;
            } else if (args[1].equals(BIOMESLIST)) {
                subcommand = BIOMESLIST;
                helps = 5;
            } else if (args[1].equals(BIOMETYPES)) {
                subcommand = BIOMETYPES;
                helps = 3;
            } else if (args[1].equals(PLACESPRING)) {
                subcommand = PLACESPRING;
                helps = 1;
            }
        }
        if (subcommand.isEmpty()) {
            sender.func_145747_a(new TextComponentString("--- " + this.func_71518_a(sender) + " ---").func_150255_a(new Style().func_150238_a(TextFormatting.GOLD)));
            sender.func_145747_a(CommandSimplyHotSprings.makeHelpComponent(LOCATIONINFO));
            sender.func_145747_a(CommandSimplyHotSprings.makeHelpComponent(BIOMESLIST));
            sender.func_145747_a(CommandSimplyHotSprings.makeHelpComponent(BIOMETYPES));
            sender.func_145747_a(CommandSimplyHotSprings.makeHelpComponent(PLACESPRING));
        } else {
            sender.func_145747_a(new TextComponentString("--- " + this.func_71518_a(sender) + " " + subcommand + " ---").func_150255_a(new Style().func_150238_a(TextFormatting.GOLD)));
            for (int i = 0; i <= helps; ++i) {
                sender.func_145747_a(new TextComponentTranslation(LANG_HELP + subcommand + "." + i, new Object[0]).func_150255_a(new Style().func_150238_a(i % 2 == 1 ? TextFormatting.GRAY : TextFormatting.WHITE)));
            }
        }
        sender.func_174794_a(CommandResultStats.Type.QUERY_RESULT, helps + 1);
    }

    public void sendLocationInfo(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        BlockPos pos;
        World world;
        Biome biome = null;
        if (args.length < 4) {
            if (args.length > 1) {
                ResourceLocation id = new ResourceLocation(args[1]);
                if (ForgeRegistries.BIOMES.containsKey(id)) {
                    world = sender.func_130014_f_();
                    pos = sender.func_180425_c();
                    biome = (Biome)ForgeRegistries.BIOMES.getValue(id);
                } else {
                    if (args[1].contains(":")) {
                        throw new CommandException("simplyhotsprings.command.locationinfo.biome_not_found", new Object[]{args[1]});
                    }
                    Entity entity = CommandBase.func_184885_b((MinecraftServer)server, (ICommandSender)sender, (String)args[1]);
                    world = entity.func_130014_f_();
                    pos = entity.func_180425_c();
                }
            } else {
                world = sender.func_130014_f_();
                pos = sender.func_180425_c();
            }
        } else {
            world = sender.func_130014_f_();
            pos = CommandBase.func_175757_a((ICommandSender)sender, (String[])args, (int)1, (boolean)true);
        }
        if (biome == null) {
            if (!world.func_175667_e(pos)) {
                throw new CommandException("simplyhotsprings.command.locationinfo.block_out_of_world", new Object[0]);
            }
            biome = world.getBiomeForCoordsBody(pos);
        }
        sender.func_145747_a(CommandSimplyHotSprings.makeAquaTranslatable("simplyhotsprings.command.locationinfo.dim_id", new Object[0]).func_150257_a(CommandSimplyHotSprings.makeSuggestComponent(world.field_73011_w.getDimension() + "")));
        GenerationReason reason = SimplyHotSpringsConfig.getGenerationReasonWorld(world);
        if (reason.allowsGeneration()) {
            reason = (GenerationReason)((Object)SimplyHotSpringsConfig.biomeReasons.get((Object)biome.getRegistryName()));
            sender.func_145747_a(CommandSimplyHotSprings.makeAquaTranslatable("simplyhotsprings.command.locationinfo.biome_name", new Object[0]).func_150257_a(CommandSimplyHotSprings.makeSuggestComponent(biome.getRegistryName().toString())));
            if (!BiomeDictionary.hasAnyType((Biome)biome)) {
                sender.func_145747_a(CommandSimplyHotSprings.makeAquaTranslatable("simplyhotsprings.command.locationinfo.biome_types", new Object[0]).func_150257_a(CommandSimplyHotSprings.noneComponent().func_150255_a(new Style().func_150238_a(TextFormatting.WHITE))));
            } else {
                sender.func_145747_a(CommandSimplyHotSprings.makeAquaTranslatable("simplyhotsprings.command.locationinfo.biome_types", new Object[0]).func_150257_a(CommandSimplyHotSprings.makeMultiComponent(BiomeDictionary.getTypes((Biome)biome), CommandSimplyHotSprings.sortType(), type -> CommandSimplyHotSprings.makeSuggestComponent(type.getName()))));
            }
        }
        sender.func_145747_a(CommandSimplyHotSprings.makeAquaTranslatable("simplyhotsprings.command.locationinfo.hot_springs", new Object[0]).func_150257_a(CommandSimplyHotSprings.makeHotSpringsReasonComponent(reason)));
        sender.func_174794_a(CommandResultStats.Type.QUERY_RESULT, reason.allowsGeneration() ? 1 : 0);
    }

    public void sendBiomesList(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        int page;
        if (args.length < 2) {
            throw new WrongUsageException(this.func_71518_a(sender) + " " + BIOMESLIST, new Object[0]);
        }
        int n = page = args.length >= 3 ? CommandBase.func_180528_a((String)args[2], (int)1) - 1 : 0;
        if (args[1].equals(ALL)) {
            sender.func_145747_a(CommandSimplyHotSprings.makeAquaTranslatable("simplyhotsprings.command.biomeslist.all", new Object[0]));
            CommandSimplyHotSprings.sendPaginatedComponents(sender, SimplyHotSpringsConfig.biomeReasons.keySet(), null, id -> CommandSimplyHotSprings.makeLocationInfoComponent(id.toString()), page, "/simplyhotsprings biomeslist all");
            sender.func_174794_a(CommandResultStats.Type.QUERY_RESULT, SimplyHotSpringsConfig.biomeReasons.size());
        } else {
            boolean with;
            if (args[1].equals(WITH)) {
                with = true;
            } else if (args[1].equals(WITHOUT)) {
                with = false;
            } else {
                throw new WrongUsageException(this.func_71518_a(sender) + " " + BIOMESLIST, new Object[0]);
            }
            sender.func_145747_a(new TextComponentTranslation(LANG_BIOMESLIST + (with ? WITH : WITHOUT), new Object[0]).func_150255_a(new Style().func_150238_a(with ? TextFormatting.GREEN : TextFormatting.DARK_RED)));
            Set filteredIds = SimplyHotSpringsConfig.biomeReasons.object2ObjectEntrySet().stream().filter(entry -> with == ((GenerationReason)((Object)((Object)entry.getValue()))).allowsGeneration()).map(entry -> (ResourceLocation)entry.getKey()).collect(Collectors.toSet());
            CommandSimplyHotSprings.sendPaginatedComponents(sender, filteredIds, null, id -> CommandSimplyHotSprings.makeLocationInfoComponent(id.toString()), page, "/simplyhotsprings biomeslist " + (with ? WITH : WITHOUT));
            sender.func_174794_a(CommandResultStats.Type.QUERY_RESULT, filteredIds.size());
        }
    }

    public void sendBiomeTypes(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        int page;
        try {
            page = args.length >= 2 ? CommandBase.func_180528_a((String)args[1], (int)1) - 1 : 0;
        }
        catch (NumberInvalidException excep) {
            for (BiomeDictionary.Type type2 : BiomeDictionary.Type.getAll()) {
                if (!type2.getName().equals(args[1])) continue;
                int page2 = args.length >= 3 ? CommandBase.func_180528_a((String)args[2], (int)1) - 1 : 0;
                sender.func_145747_a(CommandSimplyHotSprings.makeAquaTranslatable("simplyhotsprings.command.biometypes.biomes", type2.getName()));
                Set biomes = BiomeDictionary.getBiomes((BiomeDictionary.Type)type2);
                CommandSimplyHotSprings.sendPaginatedComponents(sender, biomes, CommandSimplyHotSprings.sortBiome(), biome -> CommandSimplyHotSprings.makeLocationInfoComponent(biome.getRegistryName().toString()), page2, "/simplyhotsprings biometypes " + type2);
                sender.func_174794_a(CommandResultStats.Type.QUERY_RESULT, biomes.size());
                return;
            }
            throw new CommandException("simplyhotsprings.command.biometypes.type_not_found", new Object[]{args[1]});
        }
        sender.func_145747_a(CommandSimplyHotSprings.makeAquaTranslatable("simplyhotsprings.command.biometypes.all", new Object[0]));
        CommandSimplyHotSprings.sendPaginatedComponents(sender, BiomeDictionary.Type.getAll(), CommandSimplyHotSprings.sortType(), type -> CommandSimplyHotSprings.makeBiomeTypeComponent(type.getName()), page, "/simplyhotsprings biometypes");
        sender.func_174794_a(CommandResultStats.Type.QUERY_RESULT, BiomeDictionary.Type.getAll().size());
    }

    public void placeSpring(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        BlockPos pos;
        if (args.length == 1) {
            pos = sender.func_180425_c();
        } else if (args.length >= 4) {
            pos = CommandBase.func_175757_a((ICommandSender)sender, (String[])args, (int)1, (boolean)true);
        } else {
            throw new WrongUsageException(this.func_71518_a(sender) + " " + PLACESPRING, new Object[0]);
        }
        World world = sender.func_130014_f_();
        if (!world.func_175667_e(pos)) {
            throw new CommandException("simplyhotsprings.command.locationinfo.block_out_of_world", new Object[0]);
        }
        Random rand = new Random();
        pos = pos.func_177982_a(-8, 0, -8);
        while (pos.func_177956_o() > 5 && world.func_175623_d(pos)) {
            pos = pos.func_177977_b();
        }
        pos = pos.func_177979_c(rand.nextInt(3));
        boolean success = true;
        String reasonKey = "";
        if (pos.func_177956_o() > 4) {
            if (!HotSpringsWorldGen.doGenerate(rand, world, pos, null)) {
                success = false;
                reasonKey = "failed";
            }
        } else {
            success = false;
            reasonKey = "too_low";
        }
        ITextComponent message = CommandSimplyHotSprings.makeTeleportComponent(LANG_PLACESPRING + (success ? "placed" : "not_placed"), pos.func_177982_a(8, 0, 8));
        message.func_150256_b().func_150238_a(success ? TextFormatting.GREEN : TextFormatting.RED);
        if (!reasonKey.isEmpty()) {
            message.func_150257_a((ITextComponent)new TextComponentTranslation(LANG_PLACESPRING + reasonKey, new Object[0]));
        }
        sender.func_145747_a(message);
        sender.func_174794_a(CommandResultStats.Type.QUERY_RESULT, success ? 1 : 0);
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return sender.func_70003_b(this.getRequiredPermissionLevel(), this.func_71517_b());
    }

    public int getRequiredPermissionLevel() {
        return 2;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
        if (args.length == 1) {
            return CommandBase.func_71530_a((String[])args, (String[])new String[]{LOCATIONINFO, BIOMESLIST, BIOMETYPES, PLACESPRING, HELP});
        }
        if (args.length > 1) {
            if (args[0].equals(LOCATIONINFO)) {
                if (args.length == 2) {
                    return CommandBase.func_175762_a((String[])args, (Collection)ForgeRegistries.BIOMES.getKeys());
                }
                if (args.length >= 2 && args.length <= 4 && !args[1].contains(":")) {
                    return CommandBase.func_175771_a((String[])args, (int)1, (BlockPos)targetPos);
                }
            } else if (args[0].equals(BIOMESLIST)) {
                if (args.length == 2) {
                    return CommandBase.func_71530_a((String[])args, (String[])new String[]{ALL, WITH, WITHOUT});
                }
            } else if (args[0].equals(BIOMETYPES)) {
                if (args.length == 2) {
                    return CommandBase.func_175762_a((String[])args, (Collection)BiomeDictionary.Type.getAll());
                }
            } else if (args[0].equals(PLACESPRING)) {
                if (args.length >= 2 && args.length <= 4) {
                    return CommandBase.func_175771_a((String[])args, (int)1, (BlockPos)targetPos);
                }
            } else if (args[0].equals(HELP) && args.length == 2) {
                return CommandBase.func_71530_a((String[])args, (String[])new String[]{LOCATIONINFO, BIOMESLIST, BIOMETYPES, PLACESPRING});
            }
        }
        return Collections.emptyList();
    }

    public boolean func_82358_a(String[] args, int index) {
        return index == 1 && args.length == 2 && args[0].equals(LOCATIONINFO) && !args[1].contains(":");
    }

    private static ITextComponent makeAquaTranslatable(String key, Object ... args) {
        return new TextComponentTranslation(key, args).func_150255_a(new Style().func_150238_a(TextFormatting.AQUA));
    }

    public static ITextComponent makeHotSpringsReasonComponent(GenerationReason reason) {
        return new TextComponentTranslation(reason.getYN(), new Object[0]).func_150255_a(new Style().func_150238_a(reason.getTextFormatting()).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new TextComponentTranslation("simplyhotsprings.command.locationinfo.reason", new Object[0]).func_150258_a("\n").func_150257_a(new TextComponentTranslation(reason.getKey(), new Object[0]).func_150255_a(new Style().func_150238_a(reason.getTextFormatting()))))));
    }

    private static ITextComponent makeSuggestComponent(String toCopy) {
        return new TextComponentString(toCopy).func_150255_a(new Style().func_150238_a(TextFormatting.WHITE).func_150209_a(clickForSuggest).func_150241_a(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, toCopy)));
    }

    private static ITextComponent makeLocationInfoComponent(String location) {
        return new TextComponentString(location).func_150255_a(new Style().func_150209_a(clickForInfo).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/simplyhotsprings locationinfo " + location)));
    }

    private static ITextComponent makeBiomeTypeComponent(String name) {
        return new TextComponentString(name).func_150255_a(new Style().func_150209_a(clickForList).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/simplyhotsprings biometypes " + name)));
    }

    private static ITextComponent makeTeleportComponent(String key, BlockPos pos) {
        return new TextComponentTranslation(key, new Object[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()}).func_150255_a(new Style().func_150209_a(clickForTeleport).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tp " + pos.func_177958_n() + " " + pos.func_177956_o() + " " + pos.func_177952_p())));
    }

    private static ITextComponent makeHelpComponent(String subcommand) {
        String command = "/simplyhotsprings help " + subcommand;
        return new TextComponentString(command).func_150255_a(new Style().func_150209_a(clickForHelp).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, command)));
    }

    private static ITextComponent makePageComponent(int current, int max, String pageCommand) {
        return new TextComponentTranslation("simplyhotsprings.command.page_header", new Object[]{new TextComponentString("<--").func_150255_a(new Style().func_150238_a(TextFormatting.GRAY).func_150209_a(clickForPrevious).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, pageCommand + " " + Math.max(1, current - 1 < 1 ? max : current - 1)))), new TextComponentString("-->").func_150255_a(new Style().func_150238_a(TextFormatting.GRAY).func_150209_a(clickForNext).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, pageCommand + " " + (current + 1 > max ? 1 : current + 1)))), current, max}).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY));
    }

    private static ITextComponent noneComponent() {
        return new TextComponentTranslation("simplyhotsprings.command.none", new Object[0]);
    }

    private static <T> void sendPaginatedComponents(ICommandSender sender, Collection<T> collection, @Nullable Comparator<T> comparator, Function<T, ITextComponent> toTextComponent, int page, String pageCommand) {
        int itemsPerPage = 8;
        int maxPage = collection.size() / itemsPerPage + (collection.size() % itemsPerPage == 0 ? 0 : 1) - 1;
        if (page > maxPage) {
            page = maxPage;
        }
        sender.func_145747_a(CommandSimplyHotSprings.makePageComponent(page + 1, maxPage + 1, pageCommand));
        if (collection.isEmpty()) {
            sender.func_145747_a(new TextComponentString(" ").func_150257_a(CommandSimplyHotSprings.noneComponent()));
        } else {
            ArrayList<T> list = new ArrayList<T>(collection);
            list.sort(comparator);
            for (int i = page * itemsPerPage; i < list.size() && i < (page + 1) * itemsPerPage; ++i) {
                sender.func_145747_a(new TextComponentString(" ").func_150257_a(toTextComponent.apply(list.get(i))));
            }
        }
    }

    private static <T> ITextComponent makeMultiComponent(Collection<T> collection, @Nullable Comparator<T> comparator, Function<T, ITextComponent> toTextComponent) {
        ArrayList<T> list = new ArrayList<T>(collection);
        list.sort(comparator);
        return CommandSimplyHotSprings.func_240649_b_(list, toTextComponent);
    }

    private static Comparator<BiomeDictionary.Type> sortType() {
        return (type1, type2) -> type1.getName().compareTo(type2.getName());
    }

    private static Comparator<Biome> sortBiome() {
        return (biome1, biome2) -> biome1.getRegistryName().compareTo(biome2.getRegistryName());
    }

    public static <T> ITextComponent func_240649_b_(Collection<T> collection, Function<T, ITextComponent> toTextComponent) {
        if (collection.isEmpty()) {
            return new TextComponentString("");
        }
        if (collection.size() == 1) {
            return toTextComponent.apply(collection.iterator().next()).func_150259_f();
        }
        TextComponentString itextcomponent = new TextComponentString("");
        boolean first = true;
        for (T t : collection) {
            if (!first) {
                itextcomponent.func_150257_a(new TextComponentString(", ").func_150255_a(new Style().func_150238_a(TextFormatting.GRAY)));
            }
            itextcomponent.func_150257_a(toTextComponent.apply(t));
            first = false;
        }
        return itextcomponent;
    }
}

