/*
 * Decompiled with CFR 0.152.
 */
package connor135246.simplyhotsprings.common.world;

import com.google.common.base.Predicates;
import connor135246.simplyhotsprings.SimplyHotSprings;
import connor135246.simplyhotsprings.common.blocks.BlockHotSpringWater;
import connor135246.simplyhotsprings.util.SimplyHotSpringsConfig;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSand;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockStateMatcher;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class HotSpringsWorldGen
implements IWorldGenerator {
    public static final HotSpringsWorldGen INSTANCE = new HotSpringsWorldGen();
    protected static final BlockStateMatcher SAND_MATCHER = BlockStateMatcher.func_177638_a((Block)Blocks.field_150354_m).func_177637_a((IProperty)BlockSand.field_176504_a, Predicates.equalTo((Object)BlockSand.EnumType.SAND));
    protected static final BlockStateMatcher RED_SAND_MATCHER = BlockStateMatcher.func_177638_a((Block)Blocks.field_150354_m).func_177637_a((IProperty)BlockSand.field_176504_a, Predicates.equalTo((Object)BlockSand.EnumType.RED_SAND));

    public void generate(Random rand, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (!SimplyHotSpringsConfig.allowedWorld(world)) {
            return;
        }
        BlockPos pos = world.func_175672_r(new BlockPos(chunkX * 16 + rand.nextInt(16), 255, chunkZ * 16 + rand.nextInt(16))).func_177979_c(rand.nextInt(3));
        if (pos.func_177956_o() > 4 && rand.nextInt(Math.max(SimplyHotSpringsConfig.Config.WorldGen.chance, 1)) == 0 && SimplyHotSpringsConfig.allowedBiome(world.getBiomeForCoordsBody(pos))) {
            HotSpringsWorldGen.doGenerate(rand, world, pos, chunkGenerator);
        }
    }

    public static boolean doGenerate(Random rand, World world, BlockPos pos, @Nullable IChunkGenerator chunkGenerator) {
        if (pos.func_177956_o() > 4) {
            int y;
            int x;
            pos = pos.func_177979_c(4);
            boolean[] bls = new boolean[2048];
            int i = rand.nextInt(4) + 4;
            for (int a = 0; a < i; ++a) {
                double d = rand.nextDouble() * 6.0 + 3.0;
                double e = rand.nextDouble() * 4.0 + 2.0;
                double f = rand.nextDouble() * 6.0 + 3.0;
                double g = rand.nextDouble() * (16.0 - d - 2.0) + 1.0 + d / 2.0;
                double h = rand.nextDouble() * (8.0 - e - 4.0) + 2.0 + e / 2.0;
                double k = rand.nextDouble() * (16.0 - f - 2.0) + 1.0 + f / 2.0;
                for (int x2 = 1; x2 < 15; ++x2) {
                    for (int z = 1; z < 15; ++z) {
                        for (int y2 = 1; y2 < 7; ++y2) {
                            double o = ((double)x2 - g) / (d / 2.0);
                            double p = ((double)y2 - h) / (e / 2.0);
                            double q = ((double)z - k) / (f / 2.0);
                            double r = o * o + p * p + q * q;
                            if (!(r < 1.0)) continue;
                            bls[(x2 * 16 + z) * 8 + y2] = true;
                        }
                    }
                }
            }
            for (x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    for (y = 0; y < 8; ++y) {
                        if (bls[(x * 16 + z) * 8 + y]) {
                            if (chunkGenerator == null || x % 5 != 0 || y % 5 != 0 || z % 5 != 0 || !chunkGenerator.func_193414_a(world, "Village", pos.func_177982_a(x, y, z))) continue;
                            return false;
                        }
                        if (!(x < 15 && bls[((x + 1) * 16 + z) * 8 + y] || x > 0 && bls[((x - 1) * 16 + z) * 8 + y] || z < 15 && bls[(x * 16 + z + 1) * 8 + y] || z > 0 && bls[(x * 16 + (z - 1)) * 8 + y] || y < 7 && bls[(x * 16 + z) * 8 + y + 1]) && (y <= 0 || !bls[(x * 16 + z) * 8 + (y - 1)])) continue;
                        IBlockState blockstate = world.func_180495_p(pos.func_177982_a(x, y, z));
                        if (y >= 4 && blockstate.func_185904_a().func_76224_d()) {
                            return false;
                        }
                        if (y >= 4 || blockstate.func_185904_a().func_76220_a() || blockstate.func_177230_c() == BlockHotSpringWater.BLOCK_INSTANCE) continue;
                        return false;
                    }
                }
            }
            if (SimplyHotSpringsConfig.Config.WorldGen.debug) {
                SimplyHotSprings.modlog.info("Generated a hot spring around {} {} {}", (Object)(pos.func_177958_n() + 8), (Object)(pos.func_177956_o() + 4), (Object)(pos.func_177952_p() + 8));
            }
            for (x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    for (y = 0; y < 8; ++y) {
                        BlockPos setBlockPos;
                        IBlockState setBlockState;
                        if (!bls[(x * 16 + z) * 8 + y] || (double)(setBlockState = world.func_180495_p(setBlockPos = pos.func_177982_a(x, y, z))).func_185887_b(world, setBlockPos) == -1.0 || setBlockState.func_177230_c().hasTileEntity(setBlockState)) continue;
                        world.func_180501_a(setBlockPos, y >= 4 || world.field_73011_w.func_177500_n() ? Blocks.field_150350_a.func_176223_P() : BlockHotSpringWater.BLOCK_INSTANCE.func_176223_P(), 2);
                    }
                }
            }
            for (x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    for (y = 0; y < 8; ++y) {
                        IBlockState topBlock;
                        boolean isDirt;
                        if (!bls[(x * 16 + z) * 8 + y] || y > 0 && bls[(x * 16 + z) * 8 + (y - 1)]) continue;
                        BlockPos belowPos = pos.func_177982_a(x, y - 1, z);
                        IBlockState belowState = world.func_180495_p(belowPos);
                        boolean bl = isDirt = belowState.func_177230_c() == Blocks.field_150346_d;
                        if (y < 4) {
                            if (!belowState.func_185904_a().func_76220_a()) continue;
                            if (isDirt || belowState.func_177230_c() == Blocks.field_150433_aE) {
                                world.func_180501_a(belowPos, Blocks.field_150348_b.func_176223_P(), 2);
                                continue;
                            }
                            if (SAND_MATCHER.apply(belowState)) {
                                world.func_180501_a(belowPos, Blocks.field_150322_A.func_176223_P(), 2);
                                continue;
                            }
                            if (!RED_SAND_MATCHER.apply(belowState)) continue;
                            world.func_180501_a(belowPos, Blocks.field_180395_cM.func_176223_P(), 2);
                            continue;
                        }
                        if (y < 4 || !isDirt || world.func_175642_b(EnumSkyBlock.SKY, belowPos.func_177984_a()) <= 0 || (topBlock = world.func_180494_b((BlockPos)belowPos).field_76752_A).func_177230_c() != Blocks.field_150391_bh && topBlock.func_177230_c() != Blocks.field_150349_c && topBlock.func_177230_c() != Blocks.field_150346_d) continue;
                        world.func_180501_a(belowPos, topBlock, 2);
                    }
                }
            }
            return true;
        }
        return false;
    }
}

