/*
 * Decompiled with CFR 0.152.
 */
package connor135246.simplyhotsprings.common.blocks;

import connor135246.simplyhotsprings.client.particles.ParticleSteam;
import connor135246.simplyhotsprings.common.CommonProxy;
import connor135246.simplyhotsprings.util.SimplyHotSpringsConfig;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemBlock;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;

public class BlockHotSpringWater
extends BlockFluidClassic {
    public static final Block BLOCK_INSTANCE = new BlockHotSpringWater();
    public static final ItemBlock ITEMBLOCK_INSTANCE = (ItemBlock)new ItemBlock(BLOCK_INSTANCE).setRegistryName(BLOCK_INSTANCE.getRegistryName());
    public static Potion potionEffect = MobEffects.field_76428_l;
    public static int timer = 50;
    public static int amplifier = 0;

    public BlockHotSpringWater() {
        super(CommonProxy.fluidToUse, Material.field_151586_h, MapColor.field_151648_G);
        this.func_149663_c("hot_spring_water");
        this.setRegistryName("simplyhotsprings", "hot_spring_water");
        this.func_149711_c(100.0f);
        this.func_149713_g(1);
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        super.func_180634_a(world, pos, state, entity);
        if (!world.field_72995_K && potionEffect != null && entity instanceof EntityLivingBase && this.isWithinFluid((IBlockAccess)world, pos, entity.field_70163_u + 1.0 - (double)this.quantaFraction) && !((EntityLivingBase)entity).func_70644_a(potionEffect)) {
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(potionEffect, timer, amplifier, true, true));
        }
    }

    protected boolean causesDownwardCurrent(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        Material material;
        super.func_180655_c(state, world, pos, rand);
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        int level = (Integer)state.func_177229_b((IProperty)LEVEL);
        if (world.getBlockLightOpacity(pos.func_177984_a()) == 0) {
            if (SimplyHotSpringsConfig.Config.alternateParticles) {
                if (rand.nextInt(12) == 0) {
                    world.func_175688_a(EnumParticleTypes.CLOUD, (double)((float)x + 0.1f + rand.nextFloat() * 0.8f), (double)((float)y + 1.2f), (double)((float)z + 0.1f + rand.nextFloat() * 0.8f), 0.0, 0.025 + (double)(rand.nextFloat() / 250.0f), 0.0, new int[0]);
                }
            } else if (rand.nextInt(24) == 0) {
                ParticleSteam steam = new ParticleSteam(world, (float)x + 0.1f + rand.nextFloat() * 0.8f, (float)y + 1.2f, (float)z + 0.1f + rand.nextFloat() * 0.8f);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)steam);
            }
        }
        if (0 < level && level < 8) {
            if (rand.nextInt(64) == 0) {
                world.func_184134_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, SoundEvents.field_187917_gq, SoundCategory.BLOCKS, rand.nextFloat() * 0.25f + 0.75f, rand.nextFloat() + 0.5f, false);
            }
        } else if (rand.nextInt(10) == 0) {
            Particle suspended = Minecraft.func_71410_x().field_71452_i.func_178927_a(EnumParticleTypes.SUSPENDED.func_179348_c(), (double)x + (double)rand.nextFloat(), (double)y + (double)rand.nextFloat(), (double)z + (double)rand.nextFloat(), 0.0, 0.0, 0.0, new int[0]);
            suspended.func_70543_e(rand.nextFloat() * 0.25f);
            suspended.func_70538_b(0.1f, 0.7f, 0.7f);
        }
        if (rand.nextInt(10) == 0 && world.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)world, pos, EnumFacing.UP) && !(material = world.func_180495_p(pos.func_177979_c(2)).func_185904_a()).func_76230_c() && !material.func_76224_d()) {
            world.func_175688_a(EnumParticleTypes.DRIP_WATER, (double)x + (double)rand.nextFloat(), (double)y - 1.05, (double)z + (double)rand.nextFloat(), 0.0, 0.0, 0.0, new int[0]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3d getFogColor(World world, BlockPos pos, IBlockState state, Entity entity, Vec3d originalColor, float partialTicks) {
        if (!this.isWithinFluid((IBlockAccess)world, pos, ActiveRenderInfo.func_178806_a((Entity)entity, (double)((double)partialTicks)).field_72448_b)) {
            BlockPos otherPos = pos.func_177979_c(this.densityDir);
            IBlockState otherState = world.func_180495_p(otherPos);
            return otherState.func_177230_c().getFogColor(world, otherPos, otherState, entity, originalColor, partialTicks);
        }
        if (this.getFluid() != null) {
            float fogModifier = 0.0f;
            if (entity instanceof EntityLivingBase) {
                EntityLivingBase entityLivingBase = (EntityLivingBase)entity;
                fogModifier = (float)EnchantmentHelper.func_185292_c((EntityLivingBase)entityLivingBase) * 0.1f;
                if (entityLivingBase.func_70644_a(MobEffects.field_76427_o)) {
                    fogModifier = fogModifier * 0.3f + 0.3f;
                }
            }
            return new Vec3d((double)(0.01f + fogModifier), (double)(0.3f + fogModifier), (double)(0.3f + fogModifier));
        }
        return super.getFogColor(world, pos, state, entity, originalColor, partialTicks);
    }

    protected boolean isWithinFluid(IBlockAccess world, BlockPos pos, double y) {
        float filled = this.getFilledPercentage(world, pos);
        return filled < 0.0f ? y > (double)((float)pos.func_177956_o() + filled + 1.0f) : y < (double)((float)pos.func_177956_o() + filled);
    }

    public static void updateConfigSettings() {
        ((BlockHotSpringWater)BlockHotSpringWater.BLOCK_INSTANCE).canCreateSources = SimplyHotSpringsConfig.Config.createsSources;
        if (!StringUtils.isBlank((CharSequence)SimplyHotSpringsConfig.Config.potionEffect)) {
            potionEffect = (Potion)ForgeRegistries.POTIONS.getValue(new ResourceLocation(SimplyHotSpringsConfig.Config.potionEffect));
            if (potionEffect == null) {
                SimplyHotSpringsConfig.warnInvalidEntry("Potion Effect", SimplyHotSpringsConfig.Config.potionEffect);
            }
        } else {
            potionEffect = null;
        }
        timer = SimplyHotSpringsConfig.Config.potionEffectSettings.length > 0 ? Math.max(SimplyHotSpringsConfig.Config.potionEffectSettings[0], 1) : 50;
        amplifier = SimplyHotSpringsConfig.Config.potionEffectSettings.length > 1 ? MathHelper.func_76125_a((int)SimplyHotSpringsConfig.Config.potionEffectSettings[1], (int)0, (int)255) : 0;
    }
}

