/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.arrowharvest;

import com.lothrazar.arrowharvest.UtilString;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.logging.log4j.Logger;

@Mod(modid="arrowharvest", certificateFingerprint="1bc8f8dbe770187a854cef35dad0ff40ba441bbe", updateJSON="https://raw.githubusercontent.com/Lothrazar/ChorusArrow/master/update.json", acceptedMinecraftVersions="[1.12.2]")
public class ChorusArrowMod {
    public static final String MODID = "arrowharvest";
    public static Logger logger;
    private Configuration config;
    private List<String> willDropAsBlock;
    private List<String> willDestroyBlock;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.config = new Configuration(event.getSuggestedConfigurationFile());
        this.config.load();
        String category = MODID;
        this.willDestroyBlock = Arrays.asList(this.config.getStringList("willDestroyBlock", category, new String[]{"minecraft:cocoa"}, "Destroy these like a tool"));
        this.willDropAsBlock = Arrays.asList(this.config.getStringList("willDropAsBlock", category, new String[]{"minecraft:chorus_flower", "minecraft:pumpkin", "minecraft:melon_block", "minecraft:web"}, "Drop these as an itemstack"));
        this.config.save();
    }

    public static ItemStack getMetadataDrop(IBlockState state) {
        Item item = Item.func_150898_a((Block)state.func_177230_c());
        int meta = 0;
        if (item.func_77614_k()) {
            meta = state.func_177230_c().func_176201_c(state);
        }
        return new ItemStack(item, 1, meta);
    }

    @SubscribeEvent
    public void onProjectileImpactEvent(ProjectileImpactEvent event) {
        if (event.getRayTraceResult() != null && event.getEntity() instanceof EntityArrow) {
            BlockPos pos = event.getRayTraceResult().func_178782_a();
            Entity arrow = event.getEntity();
            World world = arrow.field_70170_p;
            if (pos == null || world == null) {
                return;
            }
            IBlockState blockState = world.func_180495_p(pos);
            if (UtilString.isInList(this.willDropAsBlock, blockState.func_177230_c().getRegistryName())) {
                if (!world.field_72995_K) {
                    world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), ChorusArrowMod.getMetadataDrop(blockState)));
                }
                world.func_175655_b(pos, false);
                world.func_72900_e(arrow);
            } else if (UtilString.isInList(this.willDestroyBlock, blockState.func_177230_c().getRegistryName())) {
                world.func_175655_b(pos, true);
                world.func_72900_e(arrow);
            }
        }
    }

    @Mod.EventHandler
    public void onFingerprintViolation(FMLFingerprintViolationEvent event) {
        String source = event.getSource() == null ? "" : event.getSource().getName() + " ";
        String msg = "Invalid fingerprint detected! The file " + source + "may have been tampered with. This version will NOT be supported by the author!";
        if (logger == null) {
            System.out.println(msg);
        } else {
            logger.error(msg);
        }
    }
}

