/*
 * Decompiled with CFR 0.152.
 */
package com.Zeno410Utils;

import com.Zeno410Utils.Named;
import com.Zeno410Utils.Settings;
import java.io.File;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.config.Configuration;

public class TaggedConfigManager<Type extends Settings> {
    private final String modConfigName;
    private final String groupDirectoryName;
    public static final String worldSpecificConfigFileName = "worldSpecificConfig";

    public TaggedConfigManager(String generalConfigName, String groupDirectoryName) {
        this.modConfigName = generalConfigName;
        this.groupDirectoryName = groupDirectoryName;
    }

    public void updateConfig(Named<Type> namedSettings, File generalDirectory, File specificDirectory) {
        Settings settings = (Settings)namedSettings.object;
        File generalModFile = new File(generalDirectory, this.modConfigName);
        File generalAddOnDirectory = new File(generalDirectory, this.groupDirectoryName);
        if (!generalAddOnDirectory.exists()) {
            generalAddOnDirectory.mkdir();
        }
        File generalAddonFile = new File(generalAddOnDirectory, namedSettings.name);
        this.readConfigs(generalModFile, generalAddonFile, settings, generalDirectory);
        File specificModFile = new File(specificDirectory, this.modConfigName);
        File specificAddOnDirectory = new File(specificDirectory, this.groupDirectoryName);
        if (!specificAddOnDirectory.exists()) {
            specificAddOnDirectory.mkdir();
        }
        if (!specificAddOnDirectory.exists()) {
            throw new RuntimeException();
        }
        File specificAddonFile = new File(specificAddOnDirectory, namedSettings.name);
        this.readConfigs(specificModFile, specificAddonFile, settings, generalDirectory);
    }

    public void initializeConfig(Named<Type> namedSettings, File generalDirectory) {
        Settings settings = (Settings)namedSettings.object;
        File generalModFile = new File(generalDirectory, this.modConfigName);
        File generalAddOnDirectory = new File(generalDirectory, this.groupDirectoryName);
        File generalAddonFile = new File(generalAddOnDirectory, namedSettings.name);
        this.readConfigs(generalModFile, generalAddonFile, settings, generalDirectory);
    }

    private void readConfigs(File generalFile, File specificFile, Settings settings, File generalDirectory) {
        Configuration specific = null;
        if (specificFile.exists()) {
            specific = new Configuration(specificFile);
            settings.readFrom(specific);
        } else {
            if (generalFile.exists()) {
                settings.readFrom(new Configuration(generalFile));
            }
            specific = new Configuration(specificFile);
            settings.copyTo(specific);
        }
        settings.copyTo(specific);
        specific.save();
    }

    private boolean usable(File tested) {
        return tested != null;
    }

    public void updateConfig(Named<Type> namedSettings, File generalDirectory, WorldServer server) {
        File configDirectory = new File(server.getChunkSaveLocation(), worldSpecificConfigFileName);
        configDirectory.mkdir();
        this.updateConfig(namedSettings, generalDirectory, configDirectory);
    }
}

