/*
 * Decompiled with CFR 0.152.
 */
package climateControl.generator;

import climateControl.api.DistributionPartitioner;
import climateControl.api.IncidenceModifier;
import climateControl.customGenLayer.GenLayerConstant;
import climateControl.customGenLayer.GenLayerLandReport;
import climateControl.customGenLayer.GenLayerLimitedCache;
import climateControl.customGenLayer.GenLayerMountainChains;
import climateControl.genLayerPack.GenLayerRiverInit;
import climateControl.genLayerPack.GenLayerSmooth;
import climateControl.genLayerPack.GenLayerZoom;
import com.Zeno410Utils.Numbered;
import com.Zeno410Utils.StringWriter;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.init.Biomes;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraftforge.common.BiomeDictionary;

public class MountainFormer
extends DistributionPartitioner {
    private GenLayer mountainGens;
    private final boolean mesaMountains;

    public MountainFormer(boolean mesaMountains) {
        super(MountainFormer.incidenceModifiers(mesaMountains));
        this.mesaMountains = mesaMountains;
        this.mountainGens = this.mountainGenLayers();
    }

    @Override
    public void initWorldGenSeed(long par1) {
        this.mountainGens.func_75905_a(par1);
    }

    @Override
    protected IncidenceModifier modifier(int x, int z) {
        int index = this.mountainGens.func_75904_a(x, z, 1, 1)[0];
        return this.modifiers.get(index);
    }

    private GenLayer mountainGenLayers() {
        GenLayer result = new GenLayerConstant(1L, 1);
        result = new GenLayerRiverInit(3001L, result);
        for (int i = 0; i < 3; ++i) {
            result = new GenLayerZoom(3001L + (long)i, result);
            result = new GenLayerSmooth(3001L + (long)i, result);
        }
        result = new GenLayerMountainChains(3005L, result);
        result = new GenLayerLimitedCache(result, 64);
        result = this.reportOn(result, "mountains.txt");
        return result;
    }

    GenLayer reportOn(GenLayer reportedOn, String fileName) {
        try {
            StringWriter target = new StringWriter(new File(fileName));
            reportedOn = new GenLayerLandReport(reportedOn, 40, target);
            return reportedOn;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private static ArrayList<IncidenceModifier> incidenceModifiers(boolean mesaMountains) {
        ArrayList<IncidenceModifier> result = new ArrayList<IncidenceModifier>();
        result.add(new LowlandModifier(mesaMountains));
        result.add(new MountainModifier(mesaMountains));
        return result;
    }

    private static Method getBiomeTypeMethod() {
        Method method = null;
        try {
            method = BiomeDictionary.class.getMethod("isBiomeOfType", Biome.class, BiomeDictionary.Type.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                method = BiomeDictionary.class.getMethod("hasType", Biome.class, BiomeDictionary.Type.class);
            }
            catch (NoSuchMethodException ex) {
                Logger.getLogger(MountainFormer.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (SecurityException ex) {
                Logger.getLogger(MountainFormer.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return method;
    }

    static /* synthetic */ Method access$000() {
        return MountainFormer.getBiomeTypeMethod();
    }

    private static class LowlandModifier
    implements IncidenceModifier {
        private final boolean mesaMountains;
        Method method = MountainFormer.access$000();

        LowlandModifier(boolean mesaMountains) {
            this.mesaMountains = mesaMountains;
        }

        @Override
        public int modifiedIncidence(Numbered<Biome> biomeIncidence) {
            try {
                Biome biome = biomeIncidence.item();
                Boolean isMountain = (Boolean)this.method.invoke(null, biome, BiomeDictionary.Type.MOUNTAIN);
                if (isMountain.booleanValue()) {
                    return 0;
                }
                if (biomeIncidence.item() == Biomes.field_76770_e) {
                    return 0;
                }
                if (this.mesaMountains && (biomeIncidence.item() == Biomes.field_150608_ab || biomeIncidence.item() == Biomes.field_150607_aa)) {
                    return 0;
                }
                Boolean isHill = (Boolean)this.method.invoke(null, biome, BiomeDictionary.Type.HILLS);
                if (isHill.booleanValue()) {
                    return biomeIncidence.count();
                }
                Boolean isOcean = (Boolean)this.method.invoke(null, biome, BiomeDictionary.Type.OCEAN);
                if (isOcean.booleanValue()) {
                    return biomeIncidence.count();
                }
                return biomeIncidence.count() * 4 / 3;
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
            catch (IllegalArgumentException ex) {
                throw new RuntimeException(ex);
            }
            catch (InvocationTargetException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private static class MountainModifier
    implements IncidenceModifier {
        Method method = MountainFormer.access$000();
        private final boolean mesaMountains;

        MountainModifier(boolean mesaMountains) {
            this.mesaMountains = mesaMountains;
        }

        @Override
        public int modifiedIncidence(Numbered<Biome> biomeIncidence) {
            try {
                Biome biome = biomeIncidence.item();
                Boolean isMountain = (Boolean)this.method.invoke(null, biome, BiomeDictionary.Type.MOUNTAIN);
                if (isMountain.booleanValue()) {
                    return biomeIncidence.count() * 4;
                }
                if (biomeIncidence.item() == Biomes.field_76770_e) {
                    return biomeIncidence.count() * 4;
                }
                if (this.mesaMountains && (biomeIncidence.item() == Biomes.field_150608_ab || biomeIncidence.item() == Biomes.field_150607_aa)) {
                    return biomeIncidence.count() * 4;
                }
                Boolean isHill = (Boolean)this.method.invoke(null, biome, BiomeDictionary.Type.HILLS);
                if (isHill.booleanValue()) {
                    return biomeIncidence.count();
                }
                Boolean isOcean = (Boolean)this.method.invoke(null, biome, BiomeDictionary.Type.OCEAN);
                if (isOcean.booleanValue()) {
                    return biomeIncidence.count();
                }
                return 0;
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
            catch (IllegalArgumentException ex) {
                throw new RuntimeException(ex);
            }
            catch (InvocationTargetException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

