/*
 * Decompiled with CFR 0.152.
 */
package com.tfar.randomenchants.ench.enchantment;

import com.tfar.randomenchants.EnchantmentConfig;
import com.tfar.randomenchants.init.ModEnchantment;
import com.tfar.randomenchants.util.EnchantmentUtils;
import com.tfar.randomenchants.util.GlobalVars;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="randomenchantments")
public class EnchantmentRandomness
extends Enchantment {
    public EnchantmentRandomness() {
        super(Enchantment.Rarity.RARE, EnumEnchantmentType.DIGGER, new EntityEquipmentSlot[]{EntityEquipmentSlot.MAINHAND});
        this.setRegistryName("randomness");
        this.func_77322_b("randomness");
    }

    public int func_77321_a(int level) {
        return 5 + 10 * (level - 1);
    }

    public int func_77317_b(int level) {
        return super.func_77321_a(level) + 25;
    }

    public int func_77325_b() {
        return 5;
    }

    public boolean func_92089_a(ItemStack stack) {
        return EnchantmentConfig.tools.enableRandomness != EnchantmentConfig.EnumAccessLevel.DISABLED && super.func_92089_a(stack);
    }

    public boolean func_185261_e() {
        return EnchantmentConfig.tools.enableRandomness == EnchantmentConfig.EnumAccessLevel.ANVIL;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return EnchantmentConfig.tools.enableRandomness != EnchantmentConfig.EnumAccessLevel.DISABLED && super.canApplyAtEnchantingTable(stack);
    }

    public boolean isAllowedOnBooks() {
        return EnchantmentConfig.tools.enableRandomness == EnchantmentConfig.EnumAccessLevel.NORMAL;
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent e) {
        EntityPlayer p = e.getPlayer();
        World world = p.func_130014_f_();
        BlockPos pos = e.getPos();
        int level = EnchantmentHelper.func_185284_a((Enchantment)ModEnchantment.RANDOMNESS, (EntityLivingBase)p);
        if (level > 0 && !world.field_72995_K) {
            for (int i = 0; i < level; ++i) {
                int rand = (int)Math.floor(Math.random() * (double)GlobalVars.size);
                Item item = GlobalVars.itemList.get(rand);
                EntityItem itemStack = new EntityItem(p.field_70170_p, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), new ItemStack(item));
                world.func_72838_d((Entity)itemStack);
            }
        }
    }

    @SubscribeEvent
    public static void removeDefaultDrops(BlockEvent.HarvestDropsEvent e) {
        EntityPlayer p = e.getHarvester();
        if (p == null) {
            return;
        }
        World world = p.func_130014_f_();
        if (EnchantmentUtils.stackHasEnch(p.func_184614_ca(), ModEnchantment.RANDOMNESS) && !world.field_72995_K) {
            e.getDrops().clear();
        }
    }
}

