/*
 * Decompiled with CFR 0.152.
 */
package com.tfar.randomenchants.ench.enchantment;

import com.tfar.randomenchants.EnchantmentConfig;
import com.tfar.randomenchants.RandomEnchants;
import com.tfar.randomenchants.init.ModEnchantment;
import com.tfar.randomenchants.util.EnchantmentUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="randomenchantments")
public class EnchantmentMagnetic
extends Enchantment {
    public EnchantmentMagnetic() {
        super(Enchantment.Rarity.RARE, RandomEnchants.TOOLSANDWEAPONS, new EntityEquipmentSlot[]{EntityEquipmentSlot.MAINHAND});
        this.setRegistryName("magnetic");
        this.func_77322_b("magnetic");
    }

    public int func_77321_a(int level) {
        return 15;
    }

    public int func_77317_b(int level) {
        return 100;
    }

    public int func_77325_b() {
        return 1;
    }

    public boolean func_92089_a(ItemStack stack) {
        return EnchantmentConfig.tools.enableMagnetic != EnchantmentConfig.EnumAccessLevel.DISABLED && super.func_92089_a(stack);
    }

    public boolean func_185261_e() {
        return EnchantmentConfig.tools.enableMagnetic == EnchantmentConfig.EnumAccessLevel.ANVIL;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return EnchantmentConfig.tools.enableMagnetic != EnchantmentConfig.EnumAccessLevel.DISABLED && super.canApplyAtEnchantingTable(stack);
    }

    public boolean isAllowedOnBooks() {
        return EnchantmentConfig.tools.enableMagnetic == EnchantmentConfig.EnumAccessLevel.NORMAL;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onHarvestDrops(BlockEvent.HarvestDropsEvent e) {
        EntityPlayer player = e.getHarvester();
        if (player != null && EnchantmentUtils.stackHasEnch(player.func_184614_ca(), ModEnchantment.MAGNETIC)) {
            e.getDrops().removeIf(arg_0 -> ((EntityPlayer)player).func_191521_c(arg_0));
        }
    }

    @SubscribeEvent
    public static void onEnemyKilled(LivingDropsEvent e) {
        EntityPlayer player;
        Entity attacker = e.getSource().func_76346_g();
        if (attacker instanceof EntityPlayer && EnchantmentUtils.stackHasEnch((player = (EntityPlayer)attacker).func_184614_ca(), ModEnchantment.MAGNETIC)) {
            List<ItemStack> stacks = EnchantmentMagnetic.getStacksFromEntityItems(e.getDrops());
            for (EntityItem entityItem : e.getDrops()) {
                if (!player.func_191521_c(entityItem.func_92059_d())) continue;
                stacks.remove(entityItem.func_92059_d());
            }
        }
    }

    public static List<ItemStack> getStacksFromEntityItems(List<EntityItem> l) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (EntityItem item : l) {
            stacks.add(item.func_92059_d());
        }
        return stacks;
    }
}

