/*
 * Decompiled with CFR 0.152.
 */
package com.tfar.randomenchants;

import com.tfar.randomenchants.entity.EntitySpecialArrow;
import com.tfar.randomenchants.entity.RenderPiercingArrow;
import com.tfar.randomenchants.init.ModEnchantment;
import com.tfar.randomenchants.util.GlobalVars;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemShield;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
@Mod(modid="randomenchantments", name="Random Enchants", version="@VERSION@", dependencies="required:forge@[14.23.5.2796,);", acceptedMinecraftVersions="[1.12.2]")
public class RandomEnchants {
    public static final EnumEnchantmentType WEAPONS = RandomEnchants.addEnchantment("weapons", item -> item instanceof ItemSword || item instanceof ItemBow);
    public static final EnumEnchantmentType PICKAXE = RandomEnchants.addEnchantment("pickaxe", ItemPickaxe.class::isInstance);
    public static final EnumEnchantmentType SHIELDS = RandomEnchants.addEnchantment("shields", ItemShield.class::isInstance);
    public static final EnumEnchantmentType AXE = RandomEnchants.addEnchantment("axe", ItemAxe.class::isInstance);
    public static final EnumEnchantmentType TOOLSANDWEAPONS = RandomEnchants.addEnchantment("tools&weapons", item -> item instanceof ItemSword || item instanceof ItemBow || item instanceof ItemTool);
    public static Logger logger = LogManager.getLogger((String)"randomenchantments");

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        ModEnchantment.registerEvents();
    }

    @Nonnull
    public static EnumEnchantmentType addEnchantment(String name, Predicate<Item> condition) {
        return EnumHelper.addEnchantmentType((String)name, condition::test);
    }

    public static void setup() {
        for (Item item : ForgeRegistries.ITEMS) {
            GlobalVars.itemList.add(item);
            ++GlobalVars.size;
        }
    }

    @SubscribeEvent
    public static void registerentity(RegistryEvent.Register<EntityEntry> e) {
        ResourceLocation resourceLocation = new ResourceLocation("randomenchantments", "piercing_arrow");
        e.getRegistry().register((IForgeRegistryEntry)EntityEntryBuilder.create().entity(EntitySpecialArrow.class).id(resourceLocation, 0).name(resourceLocation.func_110623_a()).tracker(64, 1, true).build());
    }

    @SubscribeEvent
    public static void models(ModelRegistryEvent e) {
        RenderingRegistry.registerEntityRenderingHandler(EntitySpecialArrow.class, RenderPiercingArrow::new);
    }
}

