/*
 * Decompiled with CFR 0.152.
 */
package com.ib.customdisc;

import com.ib.customdisc.DiscConfig;
import com.ib.customdisc.DiscItem;
import java.util.HashMap;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public class ItemRegister {
    private static HashMap<String, DiscItem> discs = new HashMap();
    public static HashMap<String, SoundEvent> sounds = new HashMap();

    private static SoundEvent makeSound(String name) {
        ResourceLocation location = new ResourceLocation("customdisc", name);
        return (SoundEvent)new SoundEvent(location).setRegistryName(location);
    }

    @SubscribeEvent
    public static void onRegItem(RegistryEvent.Register<Item> event) {
        String[] list;
        IForgeRegistry registry = event.getRegistry();
        for (String disc : list = DiscConfig.getDiscList()) {
            SoundEvent newSound = ItemRegister.makeSound(disc);
            DiscItem newDisc = new DiscItem(disc, newSound);
            sounds.put(disc, newSound);
            discs.put(disc, newDisc);
            registry.register((IForgeRegistryEntry)newDisc);
        }
    }

    @SubscribeEvent
    public static void onRegModel(ModelRegistryEvent event) {
        for (DiscItem disc : discs.values()) {
            ItemRegister.regModel((Item)disc, 0);
        }
    }

    private static void regModel(Item item, int meta) {
        ModelResourceLocation modelResourceLocation = new ModelResourceLocation(item.getRegistryName(), "inventory");
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)modelResourceLocation);
    }
}

