/*
 * Decompiled with CFR 0.152.
 */
package com.ib.customdisc;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.ib.customdisc.DiscConfig;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.FolderResourcePack;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Logger;

@Mod(modid="customdisc", name="Custom Disc", version="1.3", dependencies="required-after:forge@[14.23.5.2838,);", acceptedMinecraftVersions="[1.12.2]")
public class CustomDisc {
    public static final String MODID = "customdisc";
    public static final String NAME = "Custom Disc";
    public static final String VERSION = "1.3";
    private static Logger logger;

    private static String generateJSON() {
        JsonObject root = new JsonObject();
        for (String s : DiscConfig.getDiscList()) {
            JsonObject entry = new JsonObject();
            JsonObject sound = new JsonObject();
            JsonArray ja = new JsonArray();
            sound.addProperty("name", "customdisc:" + s);
            sound.addProperty("preload", Boolean.valueOf(true));
            sound.addProperty("stream", Boolean.valueOf(true));
            ja.add((JsonElement)sound);
            entry.add("sounds", (JsonElement)ja);
            root.add(s, (JsonElement)entry);
        }
        return root.toString();
    }

    @SideOnly(value=Side.CLIENT)
    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        File models;
        File textures;
        File sounds;
        FileWriter fw;
        File mcmeta;
        logger = event.getModLog();
        File directory = new File("customdisc/assets/customdisc/");
        if (!directory.exists()) {
            directory.mkdirs();
        }
        if (!(mcmeta = new File("customdisc/pack.mcmeta")).exists()) {
            try {
                fw = new FileWriter("customdisc/pack.mcmeta");
                fw.write("{\n  \"pack\": {\n    \"pack_format\": 3,\n    \"description\": \"Custom disc\"\n  } \n}");
                fw.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            fw = new FileWriter("customdisc/assets/customdisc/sounds.json");
            fw.write(CustomDisc.generateJSON());
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        File lang = new File("customdisc/assets/customdisc/lang/");
        if (!lang.exists()) {
            lang.mkdir();
        }
        if (!(sounds = new File("customdisc/assets/customdisc/sounds/")).exists()) {
            sounds.mkdir();
        }
        if (!(textures = new File("customdisc/assets/customdisc/textures/items/")).exists()) {
            textures.mkdirs();
        }
        if (!(models = new File("customdisc/assets/customdisc/models/item/")).exists()) {
            models.mkdirs();
        }
        for (String s : DiscConfig.getDiscList()) {
            try {
                FileWriter fw2 = new FileWriter("customdisc/assets/customdisc/models/item/" + s + ".json");
                JsonObject root = new JsonObject();
                JsonObject tts = new JsonObject();
                tts.addProperty("layer0", "customdisc:items/" + s);
                root.addProperty("parent", "minecraft:item/generated");
                root.add("textures", (JsonElement)tts);
                fw2.write(root.toString());
                fw2.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        FolderResourcePack forDisc = new FolderResourcePack(new File("customdisc/"));
        List defaultResourcePacks = (List)ObfuscationReflectionHelper.getPrivateValue(Minecraft.class, (Object)Minecraft.func_71410_x(), (String)"field_110449_ao");
        defaultResourcePacks.add(forDisc);
        ObfuscationReflectionHelper.setPrivateValue(Minecraft.class, (Object)Minecraft.func_71410_x(), (Object)defaultResourcePacks, (String)"field_110449_ao");
        Minecraft.func_71410_x().func_110436_a();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
    }
}

