/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.templates;

import cd4017be.lib.TickRegistry;
import cd4017be.lib.templates.NetworkNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.util.math.BlockPos;

public abstract class SharedNetwork<C extends NetworkNode<C, N, ?>, N extends SharedNetwork<C, N>>
implements TickRegistry.IUpdatable {
    protected C core;
    public final HashMap<Long, C> components;
    public boolean update = false;
    private static final byte[] defaultSides = new byte[]{0, 1, 2, 3, 4, 5};
    private static final int spreader = 549568949;

    public SharedNetwork(C core) {
        this.components = new HashMap();
        this.components.put(((NetworkNode)core).uid, core);
        this.core = core;
        ((NetworkNode)core).network = this;
    }

    protected SharedNetwork(HashMap<Long, C> comps) {
        this.components = comps;
    }

    public abstract N onSplit(HashMap<Long, C> var1);

    public void onMerged(N network) {
        for (NetworkNode c : ((SharedNetwork)network).components.values()) {
            c.network = this;
        }
        this.components.putAll(((SharedNetwork)network).components);
        ((SharedNetwork)network).components.clear();
    }

    public void add(C comp) {
        if (((NetworkNode)comp).network == this || ((NetworkNode)comp).invalid() || ((NetworkNode)comp).tile.isClient()) {
            return;
        }
        if (this.components.size() >= ((SharedNetwork)((NetworkNode)comp).network).components.size()) {
            this.onMerged(((NetworkNode)comp).network);
        } else {
            ((NetworkNode)comp).network.onMerged((SharedNetwork)this);
        }
    }

    public void remove(C comp) {
        this.components.remove(((NetworkNode)comp).uid);
        ((NetworkNode)comp).network = null;
        if (this.core == comp) {
            this.core = null;
        }
        if (!this.components.isEmpty()) {
            this.markDirty();
        }
    }

    public void onDisconnect(C comp, byte side) {
        if (((NetworkNode)comp).getNeighbor(side) != null && !((NetworkNode)comp).tile.isClient()) {
            this.markDirty();
        }
    }

    @Override
    public void process() {
        if (this.update) {
            Iterator<C> iterator;
            if (this.core == null && (iterator = this.components.values().iterator()).hasNext()) {
                NetworkNode c = (NetworkNode)iterator.next();
                this.core = c;
            }
            this.reassembleNetwork();
            this.update = false;
        }
    }

    public void markDirty() {
        if (!this.update) {
            this.update = true;
            TickRegistry.instance.updates.add(this);
        }
    }

    protected byte[] sides() {
        return defaultSides;
    }

    protected void reassembleNetwork() {
        ArrayList queue = new ArrayList();
        while (this.components.size() > 1) {
            HashMap<Long, NetworkNode> comps = new HashMap<Long, NetworkNode>();
            queue.clear();
            queue.add(this.core);
            while (!queue.isEmpty()) {
                NetworkNode obj = (NetworkNode)queue.remove(queue.size() - 1);
                if (comps.put(obj.uid, obj) != null) continue;
                for (byte i : this.sides()) {
                    Object obj1;
                    if (!obj.canConnect(i) || (obj1 = obj.getNeighbor(i)) == null || !this.components.containsKey(((NetworkNode)obj1).uid)) continue;
                    queue.add(obj1);
                }
            }
            if (comps.size() == this.components.size()) {
                return;
            }
            N network = this.onSplit(comps);
            for (Map.Entry e : comps.entrySet()) {
                ((NetworkNode)e.getValue()).network = network;
                this.components.remove(e.getKey());
            }
            Iterator iterator = this.components.values().iterator();
            if (!iterator.hasNext()) continue;
            NetworkNode c = (NetworkNode)((Object)iterator.next());
            this.core = c;
        }
    }

    public static long ExtPosUID(BlockPos pos, int dimId) {
        return pos.func_177986_g() ^ (long)(dimId *= 549568949) << 32;
    }

    public static long SidedPosUID(long base, int side) {
        return base ^ (long)(side * 549568949);
    }
}

