/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.network;

import cd4017be.lib.BlockGuiHandler;
import cd4017be.lib.Lib;
import cd4017be.lib.network.IGuiHandlerBlock;
import cd4017be.lib.network.IGuiHandlerEntity;
import cd4017be.lib.network.IGuiHandlerItem;
import cd4017be.lib.network.IGuiHandlerTile;
import cd4017be.lib.network.IPlayerPacketReceiver;
import cd4017be.lib.network.IServerPacketReceiver;
import cd4017be.lib.network.NetworkHandler;
import io.netty.buffer.Unpooled;
import java.util.ArrayDeque;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class GuiNetworkHandler
extends NetworkHandler
implements IGuiHandler {
    public static final int BLOCK_GUI_ID = 0;
    public static final int ENTITY_GUI_ID = -1;
    public static final int ITEM_GUI_ID = -256;
    public static GuiNetworkHandler GNH_INSTANCE;
    private static final int MAX_QUEUED = 16;
    private ArrayDeque<PacketBuffer> packetQueue = new ArrayDeque(16);

    public static void register() {
        if (GNH_INSTANCE == null) {
            GNH_INSTANCE = new GuiNetworkHandler("4017g");
        }
    }

    private GuiNetworkHandler(String channel) {
        super(channel);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)Lib.instance, (IGuiHandler)this);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleServerPacket(PacketBuffer pkt) throws Exception {
        Container container = Minecraft.func_71410_x().field_71439_g.field_71070_bA;
        int curId = container.field_75152_c;
        int id = pkt.markReaderIndex().readInt();
        if ((curId == id || curId == 0) && container instanceof IServerPacketReceiver) {
            ((IServerPacketReceiver)container).handleServerPacket(pkt);
            if (pkt.readableBytes() > 0) {
                StringBuilder sb = new StringBuilder("Packet > GUI: ");
                GuiNetworkHandler.printPacketData(sb, pkt);
                Lib.LOG.info(NETWORK, sb.toString());
            }
        } else if (id > curId) {
            if (this.packetQueue.size() >= 16) {
                this.packetQueue.remove();
                Lib.LOG.warn(NETWORK, "GUI packet queue overflow!");
            }
            pkt.resetReaderIndex();
            this.packetQueue.add(pkt);
        } else {
            Lib.LOG.warn(NETWORK, "received packet for invalid GUI {} @CLIENT, expected id {} ({})", (Object)id, (Object)container.field_75152_c, container.getClass());
        }
    }

    @Override
    public void handlePlayerPacket(PacketBuffer pkt, EntityPlayerMP sender) throws Exception {
        int id = pkt.readInt();
        Container container = sender.field_71070_bA;
        if (container.field_75152_c == id && container instanceof IPlayerPacketReceiver) {
            ((IPlayerPacketReceiver)container).handlePlayerPacket(pkt, sender);
            if (pkt.readableBytes() > 0) {
                StringBuilder sb = new StringBuilder("Packet > SERVER: ");
                GuiNetworkHandler.printPacketData(sb, pkt);
                Lib.LOG.info(NETWORK, sb.toString());
            }
        } else {
            Lib.LOG.warn(NETWORK, "received packet for invalid GUI {} @SERVER, expected id {} ({})", (Object)id, (Object)container.field_75152_c, container.getClass());
        }
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        if (ID >= 0) {
            BlockPos pos = new BlockPos(x, y, z);
            if (!world.func_175667_e(pos)) {
                return null;
            }
            IBlockState state = world.func_180495_p(pos);
            Block block = state.func_177230_c();
            if (block instanceof IGuiHandlerBlock) {
                return ((IGuiHandlerBlock)block).getContainer(state, world, pos, player, ID);
            }
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof IGuiHandlerTile) {
                return ((IGuiHandlerTile)te).getContainer(player, ID);
            }
        } else if (ID == -1) {
            Entity entity = world.func_73045_a(z);
            if (entity instanceof IGuiHandlerEntity) {
                return ((IGuiHandlerEntity)entity).getContainer(player, x, y);
            }
        } else if (ID >= -256) {
            if ((ID += 256) >= player.field_71071_by.func_70302_i_()) {
                return null;
            }
            ItemStack stack = player.field_71071_by.func_70301_a(ID);
            Item item = stack.func_77973_b();
            if (item instanceof IGuiHandlerItem) {
                return ((IGuiHandlerItem)item).getContainer(stack, player, ID, x, y, z);
            }
        }
        return null;
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        if (ID >= 0) {
            BlockPos pos = new BlockPos(x, y, z);
            if (!world.func_175667_e(pos)) {
                return null;
            }
            IBlockState state = world.func_180495_p(pos);
            Block block = state.func_177230_c();
            if (block instanceof IGuiHandlerBlock) {
                return ((IGuiHandlerBlock)block).getGuiScreen(state, world, pos, player, ID);
            }
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof IGuiHandlerTile) {
                return ((IGuiHandlerTile)te).getGuiScreen(player, ID);
            }
        } else if (ID == -1) {
            Entity entity = world.func_73045_a(z);
            if (entity instanceof IGuiHandlerEntity) {
                return ((IGuiHandlerEntity)entity).getGuiScreen(player, x, y);
            }
        } else if (ID >= -256) {
            if ((ID += 256) >= player.field_71071_by.func_70302_i_()) {
                return null;
            }
            ItemStack stack = player.field_71071_by.func_70301_a(ID);
            Item item = stack.func_77973_b();
            if (item instanceof IGuiHandlerItem) {
                return ((IGuiHandlerItem)item).getGuiScreen(stack, player, ID, x, y, z);
            }
        }
        return null;
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onGuiOpened(GuiScreenEvent.InitGuiEvent.Post event) {
        if (event.getGui() instanceof GuiContainer) {
            for (int i = this.packetQueue.size(); i > 0; --i) {
                PacketBuffer buf = this.packetQueue.remove();
                try {
                    this.handleServerPacket(buf);
                    continue;
                }
                catch (Exception e) {
                    this.logError(buf, "QUEUED", e);
                }
            }
        }
    }

    public static void openBlockGui(EntityPlayer player, BlockPos pos, int id) {
        if (id < 0) {
            throw new IllegalArgumentException("id must not be negative!");
        }
        if (player.field_70170_p.field_72995_K && !BlockGuiHandler.OPEN_CLIENT) {
            return;
        }
        player.openGui((Object)Lib.instance, 0 + id, player.field_70170_p, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public static void openEntityGui(EntityPlayer player, Entity entity, int x, int y) {
        if (player.field_70170_p.field_72995_K && !BlockGuiHandler.OPEN_CLIENT) {
            return;
        }
        player.openGui((Object)Lib.instance, -1, player.field_70170_p, x, y, entity.func_145782_y());
    }

    public static void openItemGui(EntityPlayer player, int slot, int x, int y, int z) {
        if (slot < 0 || slot >= player.field_71071_by.func_70302_i_()) {
            throw new IndexOutOfBoundsException("slot index out of range: " + slot);
        }
        if (player.field_70170_p.field_72995_K && !BlockGuiHandler.OPEN_CLIENT) {
            return;
        }
        player.openGui((Object)Lib.instance, -256 + slot, player.field_70170_p, x, y, z);
    }

    public static void openHeldItemGui(EntityPlayer player, EnumHand hand, int x, int y, int z) {
        GuiNetworkHandler.openItemGui(player, hand == EnumHand.OFF_HAND ? 40 : player.field_71071_by.field_70461_c, x, y, z);
    }

    public static PacketBuffer preparePacket(Container container) {
        PacketBuffer pkt = new PacketBuffer(Unpooled.buffer());
        pkt.writeInt(container.field_75152_c);
        return pkt;
    }
}

