/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.capability;

import cd4017be.lib.capability.AbstractInventory;
import java.util.Arrays;
import java.util.function.ObjIntConsumer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class BasicInventory
extends AbstractInventory {
    public final ItemStack[] items;
    public ObjIntConsumer<ItemStack> onModify;
    public Restriction restriction;

    public BasicInventory(int slots) {
        this.items = new ItemStack[slots];
        this.restriction = (x$0, x$1) -> super.insertAm(x$0, x$1);
        Arrays.fill(this.items, ItemStack.field_190927_a);
    }

    public ItemStack getStackInSlot(int s) {
        return this.items[s];
    }

    public int getSlots() {
        return this.items.length;
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        if (this.onModify != null) {
            this.onModify.accept(stack, slot);
        }
        this.items[slot] = stack;
    }

    @Override
    public int insertAm(int slot, ItemStack item) {
        return this.restriction.insertAmount(slot, item);
    }

    public static int insertAmount(int slot, ItemStack item) {
        return Math.min(64, item.func_77976_d());
    }

    public void read(NBTTagList list) {
        Arrays.fill(this.items, ItemStack.field_190927_a);
        for (NBTBase nbt : list) {
            NBTTagCompound tag = (NBTTagCompound)nbt;
            int slot = tag.func_74771_c("Slot") & 0xFF;
            if (slot >= this.items.length) continue;
            this.items[slot] = new ItemStack(tag);
        }
    }

    public NBTTagList write() {
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.items.length; ++i) {
            ItemStack item = this.items[i];
            if (item.func_190926_b()) continue;
            NBTTagCompound tag = item.func_77955_b(new NBTTagCompound());
            tag.func_74774_a("Slot", (byte)i);
            list.func_74742_a((NBTBase)tag);
        }
        return list;
    }

    @FunctionalInterface
    public static interface Restriction {
        public int insertAmount(int var1, ItemStack var2);
    }
}

