/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.api.recipes.vanilla;

import cd4017be.api.recipes.ItemOperand;
import cd4017be.lib.script.obj.Array;
import cd4017be.lib.script.obj.IOperand;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;

public class SmeltingIterator
implements IOperand.OperandIterator {
    private final ArrayList<ItemStack> keys = new ArrayList();
    private final Map<ItemStack, ItemStack> recipes = FurnaceRecipes.func_77602_a().func_77599_b();
    private ItemStack in;
    private ItemStack out;
    private int idx;

    public SmeltingIterator(Predicate<Object> key, boolean res) {
        for (Map.Entry<ItemStack, ItemStack> e : this.recipes.entrySet()) {
            if (!key.test(res ? e.getValue() : e.getKey())) continue;
            this.keys.add(e.getKey());
        }
        this.idx = -1;
    }

    @Override
    public boolean hasNext() {
        while (++this.idx < this.keys.size()) {
            this.in = this.keys.get(this.idx);
            this.out = this.recipes.get(this.in);
            if (this.out == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public IOperand next() {
        return new Array(new ItemOperand(this.in), new ItemOperand(this.out));
    }

    @Override
    public Object value() {
        return this.recipes;
    }

    @Override
    public void set(IOperand obj) {
        Object[] arr;
        if (obj instanceof Array && (arr = (Object[])obj.value())[0] instanceof ItemStack && arr[1] instanceof ItemStack) {
            ItemStack a = (ItemStack)arr[0];
            ItemStack b = (ItemStack)arr[1];
            if (a != this.in || b != this.out) {
                if (a != this.in) {
                    this.recipes.remove(this.in);
                }
                this.recipes.put(a, b);
            }
            return;
        }
        this.recipes.remove(this.in);
    }

    @Override
    public void reset() {
        this.idx = -1;
    }
}

