/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.minetraps.world;

import com.google.common.base.Predicate;
import java.util.ArrayDeque;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.logging.log4j.Level;
import xxrexraptorxx.minetraps.configs.ConfigTraps;
import xxrexraptorxx.minetraps.main.MineTraps;
import xxrexraptorxx.minetraps.main.ModBlocks;
import xxrexraptorxx.minetraps.world.WorldTickHandler;

public class WorldGenerator
implements IWorldGenerator {
    public static final String RETRO_NAME = "MineTraps";
    public static WorldGenerator instance = new WorldGenerator();

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        this.generateWorld(random, chunkX, chunkZ, world, true);
    }

    public void generateWorld(Random random, int chunkX, int chunkZ, World world, boolean newGen) {
        if (!newGen && !ConfigTraps.activateRetroGen) {
            return;
        }
        if (ConfigTraps.activateWorldGeneration) {
            if (world.field_73011_w.getDimension() == DimensionType.OVERWORLD.func_186068_a()) {
                this.addOre(ModBlocks.quicksand.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 15, 1, 50, 128, (Predicate<IBlockState>)BlockMatcher.func_177642_a((Block)Blocks.field_150354_m));
                this.addOre(ModBlocks.mud.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 20, 1, 50, 128, (Predicate<IBlockState>)BlockMatcher.func_177642_a((Block)Blocks.field_150435_aG));
            }
            if (world.field_73011_w.getDimension() == DimensionType.NETHER.func_186068_a()) {
                this.addOre(ModBlocks.toxin.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 10, 1, 3, 20, (Predicate<IBlockState>)BlockMatcher.func_177642_a((Block)Blocks.field_150424_aL));
            }
        }
        if (!newGen) {
            world.func_72964_e(chunkX, chunkZ).func_76630_e();
        }
    }

    private void addOre(IBlockState block, World world, Random random, int blockXPos, int blockZPos, int maxVeinSize, int chance, int minY, int maxY, Predicate<IBlockState> blockToSpawnIn) {
        int diffMinMaxY = maxY - minY;
        for (int x = 0; x < chance; ++x) {
            int posX = blockXPos + random.nextInt(16);
            int posY = minY + random.nextInt(diffMinMaxY);
            int posZ = blockZPos + random.nextInt(16);
            new WorldGenMinable(block, maxVeinSize, blockToSpawnIn).func_180709_b(world, random, new BlockPos(posX, posY, posZ));
        }
    }

    @SubscribeEvent
    public void handleChunkSaveEvent(ChunkDataEvent.Save event) {
        NBTTagCompound genTag = event.getData().func_74775_l(RETRO_NAME);
        if (!genTag.func_74764_b("generated")) {
            genTag.func_74757_a("generated", true);
        }
        event.getData().func_74782_a(RETRO_NAME, (NBTBase)genTag);
    }

    @SubscribeEvent
    public void handleChunkLoadEvent(ChunkDataEvent.Load event) {
        int dim = event.getWorld().field_73011_w.getDimension();
        boolean regen = false;
        NBTTagCompound tag = (NBTTagCompound)event.getData().func_74781_a(RETRO_NAME);
        ChunkPos coord = event.getChunk().func_76632_l();
        if (tag != null) {
            boolean generated;
            boolean bl = generated = ConfigTraps.activateRetroGen && !tag.func_74764_b("generated");
            if (generated) {
                if (ConfigTraps.activateVerbose) {
                    MineTraps.logger.log(Level.DEBUG, "Queuing Retrogen for chunk: " + coord.toString() + ".");
                }
                regen = true;
            }
        } else {
            regen = ConfigTraps.activateRetroGen;
        }
        if (regen) {
            ArrayDeque chunks = (ArrayDeque)WorldTickHandler.chunksToGen.get(dim);
            if (chunks == null) {
                WorldTickHandler.chunksToGen.put(dim, new ArrayDeque(128));
                chunks = (ArrayDeque)WorldTickHandler.chunksToGen.get(dim);
            }
            if (chunks != null) {
                chunks.addLast(coord);
                WorldTickHandler.chunksToGen.put(dim, (Object)chunks);
            }
        }
    }
}

