/*
 * Decompiled with CFR 0.152.
 */
package wards.function;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentDurability;
import net.minecraft.enchantment.EnchantmentFrostWalker;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityFishHook;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemFishingRod;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.ItemFishedEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerPickupXpEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import wards.Wards;
import wards.effect.WardEffect;

public class WardFunctionEvent {
    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void loadTooltip(ItemTooltipEvent event) {
        if (event.getItemStack().func_77973_b() == Item.func_150898_a((Block)Wards.ward)) {
            event.getToolTip().add("Place an enchanted book on it!");
            event.getToolTip().add("Powered by lapis.");
        }
    }

    @SubscribeEvent
    public void onPlayerHurt(LivingHurtEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            float damage = event.getAmount();
            for (PotionEffect effect : entity.func_70651_bq()) {
                Potion potion = effect.func_188419_a();
                int level = effect.func_76458_c();
                DamageSource source = event.getSource();
                if (potion == WardEffect.byEnchant(Enchantments.field_180310_c) && EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_180310_c, (EntityLivingBase)player) < level) {
                    damage = (float)((double)damage - (double)MathHelper.func_76128_c((double)((double)damage * (double)((float)level * 0.1f))));
                }
                if (potion == WardEffect.byEnchant(Enchantments.field_185297_d) && source.func_94541_c() && EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_185297_d, (EntityLivingBase)player) < level) {
                    damage = (float)((double)damage - (double)MathHelper.func_76128_c((double)((double)damage * (double)((float)level * 0.15f))));
                }
                if (potion == WardEffect.byEnchant(Enchantments.field_77329_d) && source.func_76347_k() && EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_77329_d, (EntityLivingBase)player) < level) {
                    damage = (float)((double)damage - (double)MathHelper.func_76128_c((double)((double)damage * (double)((float)level * 0.15f))));
                }
                if (potion == WardEffect.byEnchant(Enchantments.field_180308_g) && source.func_76352_a() && EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_180308_g, (EntityLivingBase)player) < level) {
                    damage = (float)((double)damage - (double)MathHelper.func_76128_c((double)((double)damage * (double)((float)level * 0.15f))));
                }
                if (potion == WardEffect.byEnchant(Enchantments.field_180309_e) && source == DamageSource.field_76379_h && EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_180309_e, (EntityLivingBase)player) < level) {
                    damage = (float)((double)damage - (double)MathHelper.func_76128_c((double)((double)damage * (double)((float)level * 0.15f))));
                }
                if (potion == WardEffect.byEnchant(Enchantments.field_92091_k) && event.getSource().func_76346_g() != null && EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_92091_k, (EntityLivingBase)player) < level && player.func_130014_f_().field_73012_v.nextInt(6) < 1 + level) {
                    event.getSource().func_76346_g().func_70097_a(DamageSource.field_76376_m, 1.0f * (float)level);
                }
                if (potion != WardEffect.byEnchant(Enchantments.field_185307_s)) continue;
                for (ItemStack item : player.func_184193_aE()) {
                    if (!(item.func_77973_b() instanceof ItemArmor) || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185307_s, (ItemStack)item) >= level || item.func_190926_b() || !item.func_77951_h() || !EnchantmentDurability.func_92097_a((ItemStack)item, (int)level, (Random)player.func_70681_au()) || !player.func_70681_au().nextBoolean()) continue;
                    item.func_77964_b(item.func_77952_i() - 1);
                }
            }
            event.setAmount(damage);
        }
    }

    @SubscribeEvent
    public void onPlayerAttack(AttackEntityEvent event) {
        if (event.getTarget() instanceof EntityLivingBase) {
            EntityLivingBase target = (EntityLivingBase)event.getTarget();
            EntityPlayer player = event.getEntityPlayer();
            ItemStack weapon = player.func_184614_ca();
            for (PotionEffect effect : player.func_70651_bq()) {
                Potion potion = effect.func_188419_a();
                int level = effect.func_76458_c();
                EnumCreatureAttribute creatureAttr = target.func_70668_bt();
                if (potion == WardEffect.byEnchant(Enchantments.field_185302_k) && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185302_k, (ItemStack)weapon) < level) {
                    target.func_70097_a(DamageSource.field_76376_m, (float)(1.0 * (double)level));
                }
                if (potion == WardEffect.byEnchant(Enchantments.field_180312_n) && creatureAttr == EnumCreatureAttribute.ARTHROPOD && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_180312_n, (ItemStack)weapon) < level) {
                    target.func_70097_a(DamageSource.field_76376_m, (float)(1.0 * (double)level));
                }
                if (potion == WardEffect.byEnchant(Enchantments.field_185303_l) && creatureAttr == EnumCreatureAttribute.UNDEAD && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185303_l, (ItemStack)weapon) < level) {
                    target.func_70097_a(DamageSource.field_76376_m, (float)(1.0 * (double)level));
                }
                if (potion == WardEffect.byEnchant(Enchantments.field_180313_o) && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_180313_o, (ItemStack)weapon) < level) {
                    double xRatio = MathHelper.func_76126_a((float)(player.field_70177_z * ((float)Math.PI / 180)));
                    double zRatio = -MathHelper.func_76134_b((float)(player.field_70177_z * ((float)Math.PI / 180)));
                    target.func_70653_a((Entity)player, 0.5f * (float)level, xRatio, zRatio);
                }
                if (potion == WardEffect.byEnchant(Enchantments.field_77334_n) && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_77334_n, (ItemStack)weapon) < level) {
                    target.func_70015_d(level * 3);
                }
                if (potion == WardEffect.byEnchant(Enchantments.field_191530_r) && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_191530_r, (ItemStack)weapon) < level && player.func_130014_f_().field_73012_v.nextInt(10) < 1 + level) {
                    World world = player.func_130014_f_();
                    for (EntityLivingBase entity : world.func_72872_a(EntityLivingBase.class, target.func_174813_aQ().func_72314_b(1.0, 0.25, 1.0))) {
                        if (entity == player || entity == target || player.func_184191_r((Entity)entity) || !(player.func_70068_e((Entity)entity) < 9.0)) continue;
                        double xRatio = MathHelper.func_76126_a((float)(player.field_70177_z * ((float)Math.PI / 180)));
                        double zRatio = -MathHelper.func_76134_b((float)(player.field_70177_z * ((float)Math.PI / 180)));
                        entity.func_70653_a((Entity)player, 0.4f, xRatio, zRatio);
                        entity.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), 1.0f + 0.5f * (float)level);
                    }
                    double x = player.field_70165_t;
                    double y = player.field_70163_u;
                    double z = player.field_70161_v;
                    world.func_184148_a((EntityPlayer)null, x, y, z, SoundEvents.field_187730_dW, player.func_184176_by(), 1.0f, 1.0f);
                    player.func_184810_cG();
                }
                if (potion != WardEffect.byEnchant(Enchantments.field_185307_s) || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185307_s, (ItemStack)weapon) >= level) continue;
                Random rand = player.func_70681_au();
                if (weapon.func_190926_b() || !weapon.func_77951_h() || !EnchantmentDurability.func_92097_a((ItemStack)weapon, (int)level, (Random)rand) || !rand.nextBoolean()) continue;
                weapon.func_77964_b(weapon.func_77952_i() - 1);
            }
        }
    }

    @SubscribeEvent
    public void onBreakingBlock(PlayerEvent.BreakSpeed event) {
        float speed = event.getOriginalSpeed();
        EntityPlayer player = event.getEntityPlayer();
        for (PotionEffect effect : player.func_70651_bq()) {
            Potion potion = effect.func_188419_a();
            int level = effect.func_76458_c();
            if (potion == WardEffect.byEnchant(Enchantments.field_185299_g) && player.func_70055_a(Material.field_151586_h) && !EnchantmentHelper.func_185287_i((EntityLivingBase)player)) {
                speed = (float)((double)speed * 3.0);
            }
            if (potion != WardEffect.byEnchant(Enchantments.field_185305_q) || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185305_q, (ItemStack)player.func_184614_ca()) >= level) continue;
            speed = (float)((double)speed + (double)level * 1.0);
        }
        event.setNewSpeed(speed);
    }

    @SubscribeEvent
    public void onCastFishingRod(EntityJoinWorldEvent event) {
        EntityPlayer player;
        ItemStack rod;
        EntityFishHook hook;
        if (event.getEntity() instanceof EntityFishHook && (hook = (EntityFishHook)event.getEntity()).func_190619_l() != null && (rod = (player = hook.func_190619_l()).func_184614_ca()).func_77973_b() instanceof ItemFishingRod) {
            for (PotionEffect effect : player.func_70651_bq()) {
                Potion potion = effect.func_188419_a();
                int level = effect.func_76458_c();
                if (potion == WardEffect.byEnchant(Enchantments.field_151370_z) && EnchantmentHelper.func_191529_b((ItemStack)rod) < level) {
                    hook.func_191517_b(level);
                }
                if (potion != WardEffect.byEnchant(Enchantments.field_151369_A) || EnchantmentHelper.func_191528_c((ItemStack)rod) >= level) continue;
                hook.func_191516_a(level);
            }
        }
    }

    @SubscribeEvent
    public void onFishItem(ItemFishedEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        for (PotionEffect effect : player.func_70651_bq()) {
            Potion potion = effect.func_188419_a();
            int level = effect.func_76458_c();
            if (potion != WardEffect.byEnchant(Enchantments.field_185307_s) || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185307_s, (ItemStack)event.getEntityPlayer().func_184614_ca()) >= level) continue;
            Random rand = player.func_70681_au();
            if (!EnchantmentDurability.func_92097_a((ItemStack)player.func_184614_ca(), (int)level, (Random)rand)) continue;
            event.damageRodBy(0);
        }
    }

    @SubscribeEvent
    public void onPickupXP(PlayerPickupXpEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        for (PotionEffect effect : player.func_70651_bq()) {
            Potion potion = effect.func_188419_a();
            Random rand = player.func_130014_f_().field_73012_v;
            if (potion != WardEffect.byEnchant(Enchantments.field_185296_A) || !rand.nextBoolean()) continue;
            ItemStack[] stack = (ItemStack[])Iterables.toArray((Iterable)player.func_184209_aF(), ItemStack.class);
            int slot = rand.nextInt(stack.length);
            int count = 0;
            while (!stack[slot].func_77951_h()) {
                slot = rand.nextInt(stack.length);
                if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185296_A, (ItemStack)stack[slot]) > 0) continue;
                if (count == 10) break;
                ++count;
            }
            if (stack[slot].func_190926_b() || !stack[slot].func_77951_h()) continue;
            EntityXPOrb orb = event.getOrb();
            int i = Math.min(orb.func_70526_d() * 2, stack[slot].func_77952_i());
            orb.field_70530_e -= i / 2;
            stack[slot].func_77964_b(stack[slot].func_77952_i() - i);
        }
    }

    @SubscribeEvent
    public void onShootArrow(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityArrow) {
            EntityArrow arrow = (EntityArrow)event.getEntity();
            if (arrow.field_70250_c instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)arrow.field_70250_c;
                for (PotionEffect effect : player.func_70651_bq()) {
                    Potion potion = effect.func_188419_a();
                    int level = effect.func_76458_c();
                    if (potion == WardEffect.byEnchant(Enchantments.field_185309_u) && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)player.func_184614_ca()) < level) {
                        double power = 0.5 * (double)level;
                        arrow.func_70239_b(arrow.func_70242_d() + power);
                    }
                    if (potion == WardEffect.byEnchant(Enchantments.field_185310_v) && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)player.func_184614_ca()) < level) {
                        arrow.func_70240_a(level);
                    }
                    if (potion != WardEffect.byEnchant(Enchantments.field_185311_w) || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)player.func_184614_ca()) >= level) continue;
                    arrow.func_70015_d(100);
                }
            }
        }
    }

    @SubscribeEvent
    public void handleInfinity(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityTippedArrow) {
            EntityTippedArrow arrow = (EntityTippedArrow)event.getEntity();
            if (arrow.field_70250_c instanceof EntityPlayer && arrow.func_184557_n() == -1) {
                EntityPlayer player = (EntityPlayer)arrow.field_70250_c;
                for (PotionEffect effect : player.func_70651_bq()) {
                    Potion potion = effect.func_188419_a();
                    if (potion != WardEffect.byEnchant(Enchantments.field_185312_x) || player.func_184812_l_() || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)player.func_184614_ca()) > 0) continue;
                    arrow.field_70251_a = EntityArrow.PickupStatus.DISALLOWED;
                    if (!player.func_191521_c(new ItemStack(Items.field_151032_g, 1))) continue;
                    Wards.logger.debug("returned arrow");
                }
            }
        }
    }

    @SubscribeEvent
    public void onShootArrow(ArrowLooseEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        for (PotionEffect effect : player.func_70651_bq()) {
            Random rand;
            Potion potion = effect.func_188419_a();
            int level = effect.func_76458_c();
            ItemStack bow = event.getBow();
            if (potion != WardEffect.byEnchant(Enchantments.field_185307_s) || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185307_s, (ItemStack)bow) >= level || !EnchantmentDurability.func_92097_a((ItemStack)bow, (int)level, (Random)(rand = player.func_70681_au())) || !rand.nextBoolean() || !bow.func_77951_h()) continue;
            bow.func_77964_b(bow.func_77952_i() - 1);
        }
    }

    @SubscribeEvent
    public void onPlayerUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            Random rand = player.func_130014_f_().field_73012_v;
            for (PotionEffect effect : player.func_70651_bq()) {
                Potion potion = effect.func_188419_a();
                int level = effect.func_76458_c();
                if (potion == WardEffect.byEnchant(Enchantments.field_185298_f) && EnchantmentHelper.func_185292_c((EntityLivingBase)player) < level && player.func_70086_ai() < 300 && rand.nextInt(3) == 0 && rand.nextInt(level + 1) > 0) {
                    player.func_70050_g(player.func_70086_ai() + 1);
                }
                if (potion != WardEffect.byEnchant(Enchantments.field_185300_i) || !player.func_70090_H() || EnchantmentHelper.func_185294_d((EntityLivingBase)player) < level) {
                    // empty if block
                }
                if (potion != WardEffect.byEnchant(Enchantments.field_185301_j)) continue;
                BlockPos prevPos = new BlockPos(player.field_70169_q, player.field_70167_r, player.field_70166_s);
                BlockPos pos = player.func_180425_c();
                if (!EnchantmentHelper.func_189869_j((EntityLivingBase)player)) {
                    if (Objects.equal((Object)prevPos, (Object)pos)) continue;
                    EnchantmentFrostWalker.func_185266_a((EntityLivingBase)player, (World)player.field_70170_p, (BlockPos)player.func_180425_c(), (int)level);
                    continue;
                }
                if (EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_185301_j, (EntityLivingBase)player) >= level || Objects.equal((Object)prevPos, (Object)pos)) continue;
                EnchantmentFrostWalker.func_185266_a((EntityLivingBase)player, (World)player.field_70170_p, (BlockPos)player.func_180425_c(), (int)level);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerBreakBlock(BlockEvent.HarvestDropsEvent event) {
        if (event.getHarvester() != null) {
            EntityPlayer player = event.getHarvester();
            IBlockState state = event.getState();
            Block block = state.func_177230_c();
            for (PotionEffect effect : player.func_70651_bq()) {
                Potion potion = effect.func_188419_a();
                int level = effect.func_76458_c();
                if (potion == WardEffect.byEnchant(Enchantments.field_185306_r) && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)player.func_184614_ca()) <= 0 && block.canSilkHarvest(event.getWorld(), event.getPos(), state, player)) {
                    ItemStack item = new ItemStack(Item.func_150898_a((Block)block), 1, block.func_176201_c(state));
                    Block.func_180635_a((World)event.getWorld(), (BlockPos)event.getPos(), (ItemStack)item);
                    event.getDrops().clear();
                }
                if (potion != WardEffect.byEnchant(Enchantments.field_185308_t) || event.getFortuneLevel() >= level) continue;
                block.func_176226_b(event.getWorld(), event.getPos(), state, level);
                event.getDrops().clear();
            }
        }
    }

    @SubscribeEvent
    public void onPlayerBreakBlock(BlockEvent.BreakEvent event) {
        if (event.getPlayer() != null) {
            EntityPlayer player = event.getPlayer();
            IBlockState state = event.getState();
            Block block = state.func_177230_c();
            for (PotionEffect effect : player.func_70651_bq()) {
                Random rand;
                ItemStack item;
                Potion potion = effect.func_188419_a();
                int level = effect.func_76458_c();
                if (potion == WardEffect.byEnchant(Enchantments.field_185306_r) && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)player.func_184614_ca()) <= 0) {
                    event.setExpToDrop(0);
                }
                if (potion == WardEffect.byEnchant(Enchantments.field_185308_t) && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)player.func_184614_ca()) < level) {
                    int xp = block.getExpDrop(state, (IBlockAccess)event.getWorld(), event.getPos(), level);
                    event.setExpToDrop(xp);
                }
                if (potion != WardEffect.byEnchant(Enchantments.field_185307_s) || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185307_s, (ItemStack)(item = player.func_184614_ca())) >= level || item.func_190926_b() || !item.func_77951_h() || !EnchantmentDurability.func_92097_a((ItemStack)item, (int)level, (Random)(rand = player.func_70681_au())) || !rand.nextBoolean() || !item.func_77951_h()) continue;
                item.func_77964_b(item.func_77952_i() - 1);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerKillMob(LootingLevelEvent event) {
        DamageSource source = event.getDamageSource();
        if (source.func_76346_g() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)source.func_76346_g();
            for (PotionEffect effect : player.func_70651_bq()) {
                Potion potion = effect.func_188419_a();
                int level = effect.func_76458_c();
                if (potion != WardEffect.byEnchant(Enchantments.field_185304_p) || event.getLootingLevel() >= level) continue;
                event.setLootingLevel(level);
            }
        }
    }
}

