/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.item;

import doggytalents.entity.ai.DogLocationManager;
import doggytalents.item.ItemDT;
import doggytalents.item.ItemRadarCreative;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class ItemRadar
extends ItemDT {
    public ItemRadar() {
        this.func_77625_d(1);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        if (!worldIn.field_72995_K) {
            int dimCurr = playerIn.field_71093_bK;
            playerIn.func_145747_a((ITextComponent)new TextComponentString(""));
            DogLocationManager locationManager = DogLocationManager.getHandler(worldIn);
            List<DogLocationManager.DogLocation> ownDogs = locationManager.getList(dimCurr, loc -> loc.getOwner(worldIn) == playerIn);
            if (ownDogs.isEmpty()) {
                playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("dogradar.errornull", new Object[]{String.valueOf(dimCurr)}));
            } else {
                boolean noRadioCollars = true;
                for (DogLocationManager.DogLocation loc2 : ownDogs) {
                    if (!loc2.hasRadioCollar(worldIn)) continue;
                    noRadioCollars = false;
                    String translateStr = ItemRadar.getDirectionTranslationKey(loc2, (Entity)playerIn);
                    playerIn.func_145747_a((ITextComponent)new TextComponentTranslation(translateStr, new Object[]{loc2.getName(worldIn), (int)Math.ceil(playerIn.func_70011_f(loc2.x, loc2.y, loc2.z))}));
                }
                if (noRadioCollars) {
                    playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("dogradar.errornoradio", new Object[0]));
                }
            }
            HashSet<Integer> otherDogs = new HashSet<Integer>();
            List<DogLocationManager.DogLocation> allDogs = locationManager.getAll(loc -> loc.getOwner(worldIn) == playerIn && loc.hasRadioCollar(worldIn));
            for (DogLocationManager.DogLocation loc3 : allDogs) {
                if (dimCurr == loc3.dim) continue;
                otherDogs.add(loc3.dim);
            }
            if (otherDogs.size() > 0) {
                playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("dogradar.notindim", new Object[]{otherDogs.stream().map(ItemRadarCreative::getDimensionName).collect(Collectors.joining(", "))}));
            }
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)playerIn.func_184586_b(handIn));
    }

    public static String getDirectionTranslationKey(DogLocationManager.DogLocation loc, Entity entity) {
        double angle = MathHelper.func_181159_b((double)(loc.x - entity.field_70165_t), (double)(loc.z - entity.field_70161_v));
        if (angle < -2.748893571891069) {
            return "dogradar.north";
        }
        if (angle < -1.9634954084936207) {
            return "dogradar.north.west";
        }
        if (angle < -1.1780972450961724) {
            return "dogradar.west";
        }
        if (angle < -0.39269908169872414) {
            return "dogradar.south.west";
        }
        if (angle < 0.39269908169872414) {
            return "dogradar.south";
        }
        if (angle < 1.178097245096172) {
            return "dogradar.south.east";
        }
        if (angle < 1.9634954084936211) {
            return "dogradar.east";
        }
        if (angle < 2.7488935718910685) {
            return "dogradar.north.east";
        }
        return "dogradar.north";
    }
}

