/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.helper;

import doggytalents.DoggyTalents;
import doggytalents.ModItems;
import doggytalents.ModTalents;
import doggytalents.api.inferface.Talent;
import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.datafix.IFixableData;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class Compatibility {
    public static final ResourceLocation DOGGY_BEAM = new ResourceLocation("doggytalents", "attackbeam");
    public static final ResourceLocation COMMAND_EMBLEM = new ResourceLocation("doggytalents", "command_emblem");
    public static final ResourceLocation CREATIVE_RADAR = new ResourceLocation("doggytalents", "creative");
    public static final ResourceLocation FANCY_COLLAR = new ResourceLocation("doggytalents", "fancy_collar");
    private static HashMap<String, Supplier<Talent>> OLD_NEW_TALENT = new HashMap();

    public static Talent getTalentOldNamingScheme(String name) {
        return OLD_NEW_TALENT.containsKey(name) ? OLD_NEW_TALENT.get(name).get() : null;
    }

    static {
        OLD_NEW_TALENT.put("bedfinder", () -> ModTalents.BED_FINDER);
        OLD_NEW_TALENT.put("blackpelt", () -> ModTalents.BLACK_PELT);
        OLD_NEW_TALENT.put("creepersweeper", () -> ModTalents.CREEPER_SWEEPER);
        OLD_NEW_TALENT.put("doggydash", () -> ModTalents.DOGGY_DASH);
        OLD_NEW_TALENT.put("fisherdog", () -> ModTalents.FISHER_DOG);
        OLD_NEW_TALENT.put("guarddog", () -> ModTalents.GUARD_DOG);
        OLD_NEW_TALENT.put("happyeater", () -> ModTalents.HAPPY_EATER);
        OLD_NEW_TALENT.put("hellhound", () -> ModTalents.HELL_HOUND);
        OLD_NEW_TALENT.put("hunterdog", () -> ModTalents.HUNTER_DOG);
        OLD_NEW_TALENT.put("packpuppy", () -> ModTalents.PACK_PUPPY);
        OLD_NEW_TALENT.put("pestfighter", () -> ModTalents.PEST_FIGHTER);
        OLD_NEW_TALENT.put("pillowpaw", () -> ModTalents.PILLOW_PAW);
        OLD_NEW_TALENT.put("poisonfang", () -> ModTalents.POISON_FANG);
        OLD_NEW_TALENT.put("puppyeyes", () -> ModTalents.PUPPY_EYES);
        OLD_NEW_TALENT.put("quickhealer", () -> ModTalents.QUICK_HEALER);
        OLD_NEW_TALENT.put("rangedattacker", () -> ModTalents.RANGED_ATTACKER);
        OLD_NEW_TALENT.put("rescuedog", () -> ModTalents.RESCUE_DOG);
        OLD_NEW_TALENT.put("roaringgale", () -> ModTalents.ROARING_GALE);
        OLD_NEW_TALENT.put("shepherddog", () -> ModTalents.SHEPHERD_DOG);
        OLD_NEW_TALENT.put("swimmerdog", () -> ModTalents.SWIMMER_DOG);
        OLD_NEW_TALENT.put("wolfmount", () -> ModTalents.WOLF_MOUNT);
    }

    public static class EntityDogDataFixer
    implements IFixableData {
        public int func_188216_a() {
            return 1;
        }

        public NBTTagCompound func_188217_a(NBTTagCompound compound) {
            String s = compound.func_74779_i("id");
            if ("minecraft:doggytalents.dog".equals(s) || "minecraft:doggytalents:dog".equals(s) || "doggytalents.doggytalents:dog".equals(s)) {
                compound.func_74778_a("id", "doggytalents.dog");
                DoggyTalents.LOGGER.debug("Fixer: EntityDog id fixed");
            }
            return compound;
        }
    }

    public static class ThrowBoneDataFixer
    implements IFixableData {
        public int func_188216_a() {
            return 1;
        }

        public NBTTagCompound func_188217_a(NBTTagCompound compound) {
            String id = compound.func_74779_i("id");
            short damage = compound.func_74765_d("Damage");
            if (id.equals("doggytalents:throw_bone") && damage > 0) {
                Item replacement = null;
                if (damage == 1) {
                    replacement = ModItems.THROW_BONE_WET;
                } else if (damage == 2) {
                    replacement = ModItems.THROW_STICK;
                } else if (damage == 3) {
                    replacement = ModItems.THROW_STICK_WET;
                }
                if (replacement != null) {
                    compound.func_74778_a("id", ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)replacement).toString());
                }
                compound.func_74777_a("Damage", (short)0);
                DoggyTalents.LOGGER.debug("Throw bone damage fixed");
            } else if (id.equals("doggytalents:fancy_collar")) {
                Item replacement = null;
                if (damage == 0) {
                    replacement = ModItems.CREATIVE_COLLAR;
                } else if (damage == 1) {
                    replacement = ModItems.SPOTTED_COLLAR;
                } else if (damage == 2) {
                    replacement = ModItems.MULTICOLOURED_COLLAR;
                }
                if (replacement != null) {
                    compound.func_74778_a("id", ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)replacement).toString());
                }
                compound.func_74777_a("Damage", (short)0);
                DoggyTalents.LOGGER.debug("Fancy Collar damage fixed");
            }
            return compound;
        }
    }
}

