/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.entity.ai;

import doggytalents.api.inferface.IWaterMovement;
import doggytalents.entity.EntityDog;
import doggytalents.entity.ai.WaterMovementHandler;
import doggytalents.helper.DogUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityAIFollowOwnerDog
extends EntityAIBase {
    private final EntityDog dog;
    private EntityLivingBase owner;
    private World world;
    private final double followSpeed;
    private final PathNavigate petPathfinder;
    private int timeToRecalcPath;
    private float exeDis;
    private float finDis;
    private double oldRangeSense;
    private IWaterMovement waterMovement;

    public EntityAIFollowOwnerDog(EntityDog thePetIn, double followSpeedIn, float executeDistance, float finishedDistance) {
        this.dog = thePetIn;
        this.world = thePetIn.field_70170_p;
        this.followSpeed = followSpeedIn;
        this.petPathfinder = thePetIn.func_70661_as();
        this.exeDis = executeDistance;
        this.finDis = finishedDistance;
        this.waterMovement = new WaterMovementHandler((EntityLiving)this.dog);
        this.func_75248_a(3);
        if (!(thePetIn.func_70661_as() instanceof PathNavigateGround)) {
            throw new IllegalArgumentException("Unsupported mob type for FollowOwnerGoal");
        }
    }

    public boolean func_75250_a() {
        EntityLivingBase entitylivingbase = this.dog.func_70902_q();
        if (entitylivingbase == null) {
            return false;
        }
        if (entitylivingbase instanceof EntityPlayer && ((EntityPlayer)entitylivingbase).func_175149_v()) {
            return false;
        }
        if (this.dog.func_70906_o()) {
            return false;
        }
        if (this.dog.canWander()) {
            return false;
        }
        double distSq = this.dog.func_70068_e((Entity)entitylivingbase);
        if (this.isCommanding(entitylivingbase) ? distSq >= 16.0 && distSq <= 100.0 : distSq < (double)(this.exeDis * this.exeDis)) {
            return false;
        }
        this.owner = entitylivingbase;
        return true;
    }

    public boolean func_75253_b() {
        return !this.petPathfinder.func_75500_f() && this.isCommanding(this.owner) ? true : this.dog.func_70068_e((Entity)this.owner) > (double)(this.finDis * this.finDis) && !this.dog.func_70906_o();
    }

    public void func_75249_e() {
        this.timeToRecalcPath = 0;
        this.waterMovement.startExecuting();
        this.oldRangeSense = this.dog.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111126_e();
        this.dog.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(32.0);
    }

    public void func_75251_c() {
        this.owner = null;
        this.petPathfinder.func_75499_g();
        this.waterMovement.resetTask();
        this.dog.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(this.oldRangeSense);
    }

    public void func_75246_d() {
        if (!this.dog.func_70906_o() && --this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = 10;
            double distSq = this.dog.func_70068_e((Entity)this.owner);
            if (this.isCommanding(this.owner)) {
                Vec3d diffVec = null;
                if (distSq < 25.0) {
                    diffVec = this.dog.func_174791_d().func_186678_a(1.7).func_178788_d(this.owner.func_174791_d().func_186678_a(0.7));
                } else if (distSq > 100.0) {
                    diffVec = this.owner.func_174791_d().func_178787_e(this.dog.func_174791_d()).func_186678_a(0.5);
                }
                if (diffVec != null) {
                    if (!this.dog.func_70661_as().func_75492_a(diffVec.field_72450_a, this.dog.field_70163_u, diffVec.field_72449_c, this.followSpeed)) {
                        if (!this.dog.func_110167_bD() && !this.dog.func_184218_aH() && distSq >= 350.0) {
                            DogUtil.teleportDogToOwner((Entity)this.owner, (Entity)this.dog, this.world, this.petPathfinder);
                        }
                    } else {
                        this.dog.func_70671_ap().func_75650_a(diffVec.field_72450_a, this.dog.field_70163_u + 1.0, diffVec.field_72449_c, 10.0f, (float)this.dog.func_70646_bf());
                    }
                }
            } else {
                this.dog.func_70671_ap().func_75651_a((Entity)this.owner, 10.0f, (float)this.dog.func_70646_bf());
                if (!this.petPathfinder.func_75497_a((Entity)this.owner, this.followSpeed) && !this.dog.func_110167_bD() && !this.dog.func_184218_aH() && distSq >= 144.0) {
                    DogUtil.teleportDogToOwner((Entity)this.owner, (Entity)this.dog, this.world, this.petPathfinder);
                }
            }
        }
    }

    public boolean isCommanding(EntityLivingBase entitylivingbase) {
        ItemStack mainStack = entitylivingbase.func_184614_ca();
        return mainStack.func_77973_b() instanceof ItemSword || mainStack.func_77973_b() instanceof ItemTool;
    }
}

