/*
 * Decompiled with CFR 0.152.
 */
package mod.acgaming.extrasounds.sound;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import javax.annotation.Nullable;
import mod.acgaming.extrasounds.ExtraSounds;
import mod.acgaming.extrasounds.config.ESConfig;
import mod.acgaming.extrasounds.sound.ESSoundEvents;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.UniversalBucket;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;

public class ESSoundManager {
    public static Map<String, SoundEvent> soundCategoryMap = new Object2ObjectOpenHashMap();
    public static Map<Item, String> soundItemMap = new Object2ObjectOpenHashMap();
    public static Map<Item, SoundEvent> soundFinalMap = new Object2ObjectOpenHashMap();
    private static long lastPlayed = System.currentTimeMillis();

    public static void init() {
        ESSoundManager.initSoundCategoryMap();
        ESSoundManager.initSoundItemMap();
        ESSoundManager.initSoundFinalMap();
    }

    public static void initSoundCategoryMap() {
        soundCategoryMap.clear();
        soundCategoryMap.put("dirt", ESSoundEvents.pick_place_dirt);
        soundCategoryMap.put("dust", ESSoundEvents.pick_place_dust);
        if (ExtraSounds.assetmover) {
            soundCategoryMap.put("gem", ESSoundEvents.pick_place_gem);
        } else {
            soundCategoryMap.put("gem", ESSoundEvents.pick_place_generic);
        }
        soundCategoryMap.put("grass", ESSoundEvents.pick_place_grass);
        soundCategoryMap.put("gravel", ESSoundEvents.pick_place_gravel);
        if (ExtraSounds.assetmover) {
            soundCategoryMap.put("ingot", ESSoundEvents.pick_place_ingot);
        } else {
            soundCategoryMap.put("ingot", ESSoundEvents.pick_place_generic);
        }
        if (ExtraSounds.assetmover) {
            soundCategoryMap.put("nugget", ESSoundEvents.pick_place_nugget);
        } else {
            soundCategoryMap.put("nugget", ESSoundEvents.pick_place_generic);
        }
        soundCategoryMap.put("sand", ESSoundEvents.pick_place_sand);
        soundCategoryMap.put("snow", ESSoundEvents.pick_place_snow);
        soundCategoryMap.put("stone", ESSoundEvents.pick_place_stone);
        soundCategoryMap.put("wood", ESSoundEvents.pick_place_wood);
        soundCategoryMap.put("wool", ESSoundEvents.pick_place_wool);
    }

    public static void initSoundItemMap() {
        soundItemMap.clear();
        try {
            for (String entry : ESConfig.soundCategories.soundArray) {
                String[] splitsConfig = entry.split(";");
                String sCategory = splitsConfig[0];
                String sResLoc = splitsConfig[1];
                String[] splitsRegistry = splitsConfig[1].split(":");
                String sRegNamespace = splitsRegistry[0];
                String sRegPath = splitsRegistry[1];
                if (sRegNamespace.equals("ore")) {
                    for (String oreName : OreDictionary.getOreNames()) {
                        if ((!sRegPath.contains("*") || !oreName.contains(sRegPath.replace("*", ""))) && !oreName.equals(sRegPath)) continue;
                        for (ItemStack oreStack : OreDictionary.getOres((String)oreName)) {
                            if (oreStack.func_190926_b() || soundItemMap.containsKey(oreStack.func_77973_b())) continue;
                            ExtraSounds.LOGGER.info("Adding item " + oreStack.func_82833_r() + " to category " + sCategory.toUpperCase());
                            soundItemMap.put(oreStack.func_77973_b(), sCategory);
                        }
                    }
                    continue;
                }
                ResourceLocation resLoc = new ResourceLocation(sResLoc);
                if (!ForgeRegistries.ITEMS.containsKey(resLoc)) continue;
                ExtraSounds.LOGGER.info("Adding item " + new ItemStack((Item)ForgeRegistries.ITEMS.getValue(resLoc)).func_82833_r() + " to category " + sCategory.toUpperCase());
                soundItemMap.put((Item)ForgeRegistries.ITEMS.getValue(resLoc), sCategory);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void initSoundFinalMap() {
        soundFinalMap.clear();
        try {
            for (Item item : ForgeRegistries.ITEMS.getValuesCollection()) {
                IRecipe recipe;
                SoundEvent soundEvent = null;
                if (item instanceof ItemBlock) {
                    soundEvent = ((ItemBlock)item).func_179223_d().func_185467_w().func_185841_e();
                } else if (item instanceof ItemFood) {
                    soundEvent = ESSoundEvents.pick_place_food;
                } else if (item instanceof ItemArmor) {
                    soundEvent = ((ItemArmor)item).func_82812_d().func_185017_b();
                } else if (item == Items.field_151131_as || item == Items.field_151117_aB) {
                    soundEvent = SoundEvents.field_187630_M;
                } else if (item == Items.field_151129_at) {
                    soundEvent = SoundEvents.field_187633_N;
                } else if (item instanceof UniversalBucket) {
                    FluidStack fluidStack = ((UniversalBucket)item).getFluid(new ItemStack(item));
                    if (fluidStack != null) {
                        soundEvent = fluidStack.getFluid().getFillSound();
                    }
                } else if (item.getRegistryName() != null && CraftingManager.field_193380_a.func_148741_d((Object)item.getRegistryName()) && (recipe = (IRecipe)CraftingManager.field_193380_a.func_82594_a((Object)item.getRegistryName())) != null) {
                    ArrayList ingredientList = new ArrayList(recipe.func_192400_c());
                    ArrayList<Object> ingredientStackList = new ArrayList<Object>();
                    for (Ingredient ingredient : ingredientList) {
                        ingredientStackList.addAll(Arrays.asList(ingredient.func_193365_a()));
                    }
                    if (ingredientStackList.size() > 0) {
                        ingredientStackList.sort(Comparator.comparing(i -> Collections.frequency(ingredientStackList, i)).reversed());
                        Item ingredientItem = ((ItemStack)ingredientStackList.get(0)).func_77973_b();
                        if (soundItemMap.containsKey(ingredientItem)) {
                            soundEvent = soundCategoryMap.get(soundItemMap.get(ingredientItem));
                        } else if (ingredientItem instanceof ItemBlock) {
                            soundEvent = ((ItemBlock)ingredientItem).func_179223_d().func_185467_w().func_185841_e();
                        }
                    }
                }
                if (soundEvent == null) continue;
                soundFinalMap.put(item, soundEvent);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void playSoundPlayer(World world, EntityPlayer player, SoundEvent soundEvent, float pitch, float volume) {
        if (player == null) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now - lastPlayed > 5L) {
            world.func_184133_a(player, player.func_180425_c(), soundEvent, SoundCategory.PLAYERS, volume, pitch - 0.1f + ESSoundManager.randomOffset(world));
            lastPlayed = now;
        }
    }

    public static void playSoundPlayer(World world, EntityPlayer player, SoundEvent soundEvent) {
        if (player == null) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now - lastPlayed > 5L) {
            world.func_184133_a(player, player.func_180425_c(), soundEvent, SoundCategory.PLAYERS, 1.0f, 0.9f + ESSoundManager.randomOffset(world));
            lastPlayed = now;
        }
    }

    public static void playSoundWorld(World world, @Nullable EntityPlayer player, SoundEvent soundEvent, BlockPos blockPos, float pitch, float volume) {
        if (world == null) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now - lastPlayed > 5L) {
            world.func_184133_a(player, blockPos, soundEvent, SoundCategory.BLOCKS, volume, pitch - 0.1f + ESSoundManager.randomOffset(world));
            lastPlayed = now;
        }
    }

    public static void playSoundWorld(World world, @Nullable EntityPlayer player, SoundEvent soundEvent, BlockPos blockPos) {
        if (world == null) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now - lastPlayed > 5L) {
            world.func_184133_a(player, blockPos, soundEvent, SoundCategory.BLOCKS, 1.0f, 0.9f + ESSoundManager.randomOffset(world));
            lastPlayed = now;
        }
    }

    public static void playClickSound(World world, EntityPlayer player, ItemStack stackIn) {
        if (stackIn.func_190926_b()) {
            return;
        }
        Item item = stackIn.func_77973_b();
        if (soundItemMap.containsKey(item)) {
            ESSoundManager.playSoundPlayer(world, player, soundCategoryMap.get(soundItemMap.get(item)));
        } else if (soundFinalMap.containsKey(item)) {
            ESSoundManager.playSoundPlayer(world, player, soundFinalMap.get(item), 2.0f, 0.4f);
        } else {
            ESSoundManager.playSoundPlayer(world, player, ESSoundEvents.pick_place_generic);
        }
    }

    public static float randomOffset(World world) {
        return world != null ? world.field_73012_v.nextFloat() * 0.2f : 0.1f;
    }
}

