/*
 * Decompiled with CFR 0.152.
 */
package mod.acgaming.extrasounds.mixin;

import mod.acgaming.extrasounds.ExtraSounds;
import mod.acgaming.extrasounds.config.ESConfig;
import mod.acgaming.extrasounds.sound.ESSoundEvents;
import mod.acgaming.extrasounds.sound.ESSoundManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EntityPlayer.class})
public abstract class EntityPlayerMixin
extends EntityLivingBase {
    public EntityPlayerMixin(World worldIn) {
        super(worldIn);
    }

    @Inject(at={@At(value="TAIL")}, method={"dropItem(Lnet/minecraft/item/ItemStack;ZZ)Lnet/minecraft/entity/item/EntityItem;"})
    public void esDropItemSound(ItemStack droppedItem, boolean dropAround, boolean traceItem, CallbackInfoReturnable<EntityItem> cir) {
        if (ESConfig.soundToggles.esDropItemSound && traceItem && !droppedItem.func_190926_b()) {
            float range = 0.1f;
            float pitch = 1.0f + range * (1.0f * (float)droppedItem.func_77973_b().func_77639_j() / (float)droppedItem.func_190916_E()) - range / 2.0f;
            ESSoundManager.playSoundWorld(this.field_70170_p, null, ESSoundEvents.drop_item, this.func_180425_c(), pitch, 1.0f);
        }
    }

    public void func_70670_a(PotionEffect id) {
        super.func_70670_a(id);
        if (ESConfig.soundToggles.esPotionSound && ExtraSounds.assetmover) {
            if (id.func_188419_a().func_76398_f()) {
                ESSoundManager.playSoundWorld(this.field_70170_p, null, ESSoundEvents.effect_add_negative, this.func_180425_c());
                ESSoundManager.playSoundWorld(this.field_70170_p, null, ESSoundEvents.effect_add_negative, this.func_180425_c());
            } else {
                ESSoundManager.playSoundWorld(this.field_70170_p, null, ESSoundEvents.effect_add_positive, this.func_180425_c());
                ESSoundManager.playSoundWorld(this.field_70170_p, null, ESSoundEvents.effect_add_positive, this.func_180425_c());
            }
        }
    }

    public void func_70688_c(PotionEffect effect) {
        super.func_70688_c(effect);
        if (ESConfig.soundToggles.esPotionSound && ExtraSounds.assetmover) {
            if (effect.func_188419_a().func_76398_f()) {
                ESSoundManager.playSoundWorld(this.field_70170_p, null, ESSoundEvents.effect_remove_negative, this.func_180425_c());
                ESSoundManager.playSoundWorld(this.field_70170_p, null, ESSoundEvents.effect_remove_negative, this.func_180425_c());
            } else {
                ESSoundManager.playSoundWorld(this.field_70170_p, null, ESSoundEvents.effect_remove_positive, this.func_180425_c());
                ESSoundManager.playSoundWorld(this.field_70170_p, null, ESSoundEvents.effect_remove_positive, this.func_180425_c());
            }
        }
    }
}

