/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.gamblingstyle.network.message;

import com.fuzs.gamblingstyle.GamblingStyle;
import com.fuzs.gamblingstyle.client.gui.GuiVillager;
import com.fuzs.gamblingstyle.network.message.Message;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.village.MerchantRecipeList;

public class STradingListMessage
extends Message<STradingListMessage> {
    private PacketBuffer data;

    public STradingListMessage() {
    }

    public STradingListMessage(PacketBuffer bufIn) {
        this.data = bufIn;
        if (bufIn.writerIndex() > 0x100000) {
            throw new IllegalArgumentException("Payload may not be larger than 1048576 bytes");
        }
    }

    @Override
    public void read(ByteBuf buf) {
        int bytes = buf.readableBytes();
        if (bytes < 0 || bytes > 0x100000) {
            throw new IllegalArgumentException("Payload may not be larger than 1048576 bytes");
        }
        this.data = new PacketBuffer(buf.readBytes(bytes));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(ByteBuf buf) {
        PacketBuffer packetBuffer = this.data;
        synchronized (packetBuffer) {
            this.data.markReaderIndex();
            buf.writeBytes((ByteBuf)this.data);
            this.data.resetReaderIndex();
        }
    }

    @Override
    protected Message.MessageProcessor createProcessor() {
        return new TradingListProcessor();
    }

    private class TradingListProcessor
    implements Message.MessageProcessor {
        private TradingListProcessor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void accept(EntityPlayer player) {
            try {
                Minecraft mc = Minecraft.func_71410_x();
                int windowId = STradingListMessage.this.data.readInt();
                GuiScreen screen = mc.field_71462_r;
                if (screen instanceof GuiVillager && windowId == mc.field_71439_g.field_71070_bA.field_75152_c) {
                    MerchantRecipeList merchantRecipes = MerchantRecipeList.func_151390_b((PacketBuffer)STradingListMessage.this.data);
                    ((GuiVillager)screen).setMerchantRecipes(merchantRecipes);
                }
            }
            catch (IOException e) {
                GamblingStyle.LOGGER.error("Couldn't load trade info", (Throwable)e);
            }
            finally {
                if (STradingListMessage.this.data != null) {
                    STradingListMessage.this.data.release();
                }
            }
        }
    }
}

