/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.gamblingstyle.network.message;

import com.fuzs.gamblingstyle.capability.container.ITradingInfo;
import com.fuzs.gamblingstyle.client.gui.GuiVillager;
import com.fuzs.gamblingstyle.network.message.Message;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.NpcMerchant;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class SOpenWindowMessage
extends Message<SOpenWindowMessage> {
    private int windowId;
    private ITextComponent windowTitle;
    private int slotCount;
    private int merchantId;
    private int lastTradeIndex;
    private ITradingInfo.FilterMode filterMode;
    private byte[] favoriteTrades;

    public SOpenWindowMessage() {
    }

    public SOpenWindowMessage(int windowId, ITextComponent windowTitle, int slotCount, int merchantId, int lastTradeIndex, ITradingInfo.FilterMode filterMode, byte[] favoriteTrades) {
        this.windowId = windowId;
        this.windowTitle = windowTitle;
        this.slotCount = slotCount;
        this.merchantId = merchantId;
        this.lastTradeIndex = lastTradeIndex;
        this.filterMode = filterMode;
        this.favoriteTrades = favoriteTrades;
    }

    @Override
    public void write(ByteBuf buf) {
        buf.writeByte(this.windowId);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)ITextComponent.Serializer.func_150696_a((ITextComponent)this.windowTitle));
        buf.writeByte(this.slotCount);
        buf.writeInt(this.merchantId);
        buf.writeByte(this.lastTradeIndex);
        buf.writeByte(this.filterMode.ordinal());
        buf.writeByte(this.favoriteTrades.length);
        for (byte favorite : this.favoriteTrades) {
            buf.writeByte((int)favorite);
        }
    }

    @Override
    public void read(ByteBuf buf) {
        this.windowId = buf.readUnsignedByte();
        this.windowTitle = ITextComponent.Serializer.func_150699_a((String)ByteBufUtils.readUTF8String((ByteBuf)buf));
        this.slotCount = buf.readUnsignedByte();
        this.merchantId = buf.readInt();
        this.lastTradeIndex = buf.readUnsignedByte();
        this.filterMode = ITradingInfo.FilterMode.values()[buf.readUnsignedByte()];
        int tradesLength = buf.readUnsignedByte();
        this.favoriteTrades = new byte[tradesLength];
        for (int i = 0; i < tradesLength; ++i) {
            this.favoriteTrades[i] = (byte)buf.readUnsignedByte();
        }
    }

    @Override
    protected Message.MessageProcessor createProcessor() {
        return new OpenWindowProcessor();
    }

    private class OpenWindowProcessor
    implements Message.MessageProcessor {
        private OpenWindowProcessor() {
        }

        @Override
        public void accept(EntityPlayer player) {
            World worldIn = player.field_70170_p;
            Entity entity = worldIn.func_73045_a(SOpenWindowMessage.this.merchantId);
            if (entity instanceof EntityLivingBase && entity instanceof IMerchant) {
                GuiVillager guiContainer = new GuiVillager(player.field_71071_by, (IMerchant)new NpcMerchant(player, SOpenWindowMessage.this.windowTitle), (EntityLivingBase)entity, SOpenWindowMessage.this.lastTradeIndex, SOpenWindowMessage.this.filterMode, SOpenWindowMessage.this.favoriteTrades);
                Minecraft.func_71410_x().func_147108_a((GuiScreen)guiContainer);
                player.field_71070_bA.field_75152_c = SOpenWindowMessage.this.windowId;
            }
        }
    }
}

