/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.gamblingstyle.network.message;

import com.fuzs.gamblingstyle.GamblingStyle;
import io.netty.buffer.ByteBuf;
import java.util.function.Consumer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.IThreadListener;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public abstract class Message<T extends Message<T>>
implements IMessage,
IMessageHandler<T, T> {
    public final T onMessage(T message, MessageContext ctx) {
        EntityPlayerMP serverPlayer = null;
        MinecraftServer minecraftServer = null;
        if (ctx.side.isServer()) {
            NetHandlerPlayServer netHandlerPlayServer = ctx.getServerHandler();
            serverPlayer = netHandlerPlayServer.field_147369_b;
            minecraftServer = serverPlayer.field_71133_b;
        }
        IThreadListener threadListener = GamblingStyle.proxy.getInstance((IThreadListener)minecraftServer);
        EntityPlayer player = GamblingStyle.proxy.getPlayer(serverPlayer);
        threadListener.func_152344_a(() -> message.process(player));
        return null;
    }

    public final void toBytes(ByteBuf buf) {
        this.write(buf);
    }

    public final void fromBytes(ByteBuf buf) {
        this.read(buf);
    }

    protected abstract void write(ByteBuf var1);

    protected abstract void read(ByteBuf var1);

    public final void process(EntityPlayer player) {
        this.createProcessor().accept(player);
    }

    protected abstract MessageProcessor createProcessor();

    protected static interface MessageProcessor
    extends Consumer<EntityPlayer> {
    }
}

