/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.gamblingstyle.inventory;

import net.minecraft.entity.IMerchant;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ContainerMerchant;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryMerchant;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotMerchantResult;
import net.minecraft.item.ItemStack;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.World;

public class ContainerVillager
extends ContainerMerchant {
    private final IMerchant merchant;
    private final InventoryMerchant merchantInventory;
    private final World world;
    private final EntityPlayer player;
    private int lastIndex = 3;

    public ContainerVillager(InventoryPlayer playerInventory, IMerchant merchant, World worldIn) {
        super(playerInventory, merchant, worldIn);
        this.field_75151_b.clear();
        this.field_75153_a.clear();
        this.merchant = merchant;
        this.world = worldIn;
        this.player = playerInventory.field_70458_d;
        this.merchantInventory = new InventoryMerchant(this.player, merchant);
        this.addContainerSlots(playerInventory, merchant);
    }

    private void addContainerSlots(InventoryPlayer playerInventory, IMerchant merchant) {
        this.func_75146_a(new Slot((IInventory)this.merchantInventory, 0, 76, 22));
        this.func_75146_a(new Slot((IInventory)this.merchantInventory, 1, 76, 48));
        this.func_75146_a((Slot)new SlotMerchantResult(this.player, merchant, this.merchantInventory, 2, 134, 35));
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.func_75146_a(new Slot((IInventory)playerInventory, k, 8 + k * 18, 142));
        }
    }

    public InventoryMerchant func_75174_d() {
        return this.merchantInventory;
    }

    public void func_75130_a(IInventory inventoryIn) {
        this.merchantInventory.func_70470_g();
        this.func_75142_b();
    }

    public void func_75175_c(int currentRecipeIndex) {
        this.merchantInventory.func_70471_c(currentRecipeIndex);
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        return this.merchant.func_70931_l_() == playerIn;
    }

    public ItemStack func_82846_b(EntityPlayer playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot indexSlot = (Slot)this.field_75151_b.get(index);
        if (indexSlot != null && indexSlot.func_75216_d()) {
            ItemStack stackAtIndex = indexSlot.func_75211_c();
            itemstack = stackAtIndex.func_77946_l();
            if (index == 2) {
                if (!this.func_75135_a(stackAtIndex, 3, 39, true)) {
                    return ItemStack.field_190927_a;
                }
                indexSlot.func_75220_a(stackAtIndex, itemstack);
            } else if (index != 0 && index != 1) {
                if (index >= 3 && index < 39) {
                    ItemStack itemToBuy = this.merchantInventory.func_70301_a(0);
                    ItemStack secondItemToBuy = this.merchantInventory.func_70301_a(1);
                    boolean flag = false;
                    if (!ItemStack.func_185132_d((ItemStack)secondItemToBuy, (ItemStack)stackAtIndex) || !itemToBuy.func_190926_b()) {
                        boolean bl = flag = !this.func_75135_a(stackAtIndex, 0, 1, false);
                    }
                    if (!ItemStack.func_185132_d((ItemStack)itemToBuy, (ItemStack)stackAtIndex) || !secondItemToBuy.func_190926_b()) {
                        boolean bl = flag = !this.func_75135_a(stackAtIndex, 1, 2, false);
                    }
                    if (flag) {
                        return ItemStack.field_190927_a;
                    }
                    this.func_75130_a((IInventory)this.merchantInventory);
                }
            } else if (!this.func_75135_a(stackAtIndex, 3, 39, false)) {
                return ItemStack.field_190927_a;
            }
            if (stackAtIndex.func_190926_b()) {
                indexSlot.func_75215_d(ItemStack.field_190927_a);
            } else {
                indexSlot.func_75218_e();
            }
            if (stackAtIndex.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            indexSlot.func_190901_a(playerIn, stackAtIndex);
        }
        return itemstack;
    }

    public boolean areSlotsFilled() {
        return !this.merchantInventory.func_70301_a(0).func_190926_b() || !this.merchantInventory.func_70301_a(1).func_190926_b();
    }

    public void clearTradingSlots() {
        ItemStack itemToBuy = this.merchantInventory.func_70301_a(0);
        ItemStack secondItemToBuy = this.merchantInventory.func_70301_a(1);
        if (!itemToBuy.func_190926_b()) {
            this.func_75135_a(itemToBuy, 3, 39, true);
        }
        if (!secondItemToBuy.func_190926_b()) {
            this.func_75135_a(secondItemToBuy, 3, 39, true);
        }
        this.func_75130_a((IInventory)this.merchantInventory);
    }

    private boolean getItemsSwitched(ItemStack itemToBuy, ItemStack secondItemToBuy, ItemStack itemToBuyRecipe, ItemStack secondItemToBuyRecipe) {
        boolean itemToBuySwitched = !itemToBuy.func_190926_b() && ItemStack.func_179545_c((ItemStack)itemToBuy, (ItemStack)secondItemToBuyRecipe);
        boolean secondItemToBuySwitched = !secondItemToBuy.func_190926_b() && ItemStack.func_179545_c((ItemStack)secondItemToBuy, (ItemStack)itemToBuyRecipe);
        return (itemToBuySwitched || secondItemToBuySwitched) && !ItemStack.func_179545_c((ItemStack)itemToBuy, (ItemStack)itemToBuyRecipe) && !ItemStack.func_179545_c((ItemStack)secondItemToBuy, (ItemStack)secondItemToBuyRecipe);
    }

    public void handleClickedButtonItems(int recipeIndex, boolean clear, boolean quickMove, boolean skipMove) {
        block7: {
            ItemStack itemstack6;
            ItemStack itemstack5;
            boolean isTradeAvailable;
            MerchantRecipeList merchantrecipelist = this.merchant.func_70934_b(this.player);
            if (merchantrecipelist == null || merchantrecipelist.size() <= recipeIndex) break block7;
            MerchantRecipe recipe = (MerchantRecipe)merchantrecipelist.get(recipeIndex);
            ItemStack itemToBuy = this.merchantInventory.func_70301_a(0);
            ItemStack secondItemToBuy = this.merchantInventory.func_70301_a(1);
            ItemStack itemToBuyRecipe = recipe.func_77394_a();
            ItemStack secondItemToBuyRecipe = recipe.func_77396_b();
            boolean slotsSwitched = this.getItemsSwitched(itemToBuy, secondItemToBuy, itemToBuyRecipe, secondItemToBuyRecipe);
            if (!itemToBuy.func_190926_b() && (clear && !skipMove || !ItemStack.func_179545_c((ItemStack)itemToBuy, (ItemStack)itemToBuyRecipe) && !slotsSwitched || !ItemStack.func_179545_c((ItemStack)itemToBuy, (ItemStack)secondItemToBuyRecipe) && slotsSwitched)) {
                if (!this.func_75135_a(itemToBuy, 3, 39, true)) {
                    return;
                }
                this.merchantInventory.func_70299_a(0, itemToBuy);
            }
            if (!secondItemToBuy.func_190926_b() && (clear && !skipMove || !ItemStack.func_179545_c((ItemStack)secondItemToBuy, (ItemStack)secondItemToBuyRecipe) && !slotsSwitched || !ItemStack.func_179545_c((ItemStack)secondItemToBuy, (ItemStack)itemToBuyRecipe) && slotsSwitched)) {
                if (!this.func_75135_a(secondItemToBuy, 3, 39, true)) {
                    return;
                }
                this.merchantInventory.func_70299_a(1, secondItemToBuy);
            }
            do {
                int secondItemToBuyCount;
                int itemToBuyCount = slotsSwitched ? secondItemToBuyRecipe.func_190916_E() : itemToBuyRecipe.func_190916_E();
                int n = secondItemToBuyCount = slotsSwitched ? itemToBuyRecipe.func_190916_E() : secondItemToBuyRecipe.func_190916_E();
                if (skipMove) {
                    itemToBuyCount -= this.merchantInventory.func_70301_a(0).func_190916_E();
                    secondItemToBuyCount -= this.merchantInventory.func_70301_a(1).func_190916_E();
                }
                this.moveAndTrade(quickMove, skipMove, slotsSwitched ? secondItemToBuyRecipe : itemToBuyRecipe, slotsSwitched ? itemToBuyRecipe : secondItemToBuyRecipe, itemToBuyCount, secondItemToBuyCount);
                itemstack5 = this.merchantInventory.func_70301_a(0);
                itemstack6 = this.merchantInventory.func_70301_a(1);
                isTradeAvailable = this.isTradeAvailable(itemToBuyRecipe, secondItemToBuyRecipe, slotsSwitched ? itemstack6 : itemstack5, slotsSwitched ? itemstack5 : itemstack6);
                if (!skipMove || !isTradeAvailable) continue;
                this.tradeAutomatically(recipe.func_77397_d());
            } while (quickMove && skipMove && !recipe.func_82784_g() && isTradeAvailable);
            if (quickMove && skipMove) {
                this.func_75135_a(itemstack5, 3, 39, true);
                this.func_75135_a(itemstack6, 3, 39, true);
            }
            this.func_75130_a((IInventory)this.merchantInventory);
        }
    }

    private void moveAndTrade(boolean quickMove, boolean skipMove, ItemStack itemToBuy, ItemStack secondItemToBuy, int itemToBuyCount, int secondItemToBuyCount) {
        if (itemToBuyCount > 0) {
            this.moveItemsToSlot(0, itemToBuy, itemToBuyCount, quickMove, skipMove);
        }
        if (secondItemToBuyCount > 0) {
            this.moveItemsToSlot(1, secondItemToBuy, secondItemToBuyCount, quickMove, skipMove);
        }
    }

    private void moveItemsToSlot(int targetSlot, ItemStack itemstack, int count, boolean quickMove, boolean skipMove) {
        if (!itemstack.func_190926_b()) {
            int leftover = 0;
            for (int i = this.lastIndex; i < 39; ++i) {
                ItemStack inventorystack = ((Slot)this.field_75151_b.get(i)).func_75211_c();
                if (!inventorystack.func_190926_b() && ItemStack.func_179545_c((ItemStack)itemstack, (ItemStack)inventorystack)) {
                    int int_6;
                    ItemStack currentitemstack = this.merchantInventory.func_70301_a(targetSlot);
                    if (!currentitemstack.func_190926_b() && !ItemStack.func_77970_a((ItemStack)currentitemstack, (ItemStack)inventorystack) && !skipMove) continue;
                    int int_3 = currentitemstack.func_190926_b() ? 0 : currentitemstack.func_190916_E();
                    int int_32 = leftover > 0 ? leftover : count;
                    int int_33 = Math.min(inventorystack.func_190916_E(), int_32);
                    leftover = int_32 - int_33;
                    int int_34 = quickMove ? inventorystack.func_190916_E() : int_33;
                    int int_4 = Math.min(itemstack.func_77976_d() - int_3, int_34);
                    ItemStack newitemstack = inventorystack.func_77946_l();
                    int int_5 = int_3 + int_4;
                    inventorystack.func_190918_g(int_4);
                    newitemstack.func_190920_e(int_5);
                    this.merchantInventory.func_70299_a(targetSlot, newitemstack);
                    int n = int_6 = quickMove ? itemstack.func_77976_d() : Math.min(itemstack.func_77976_d(), int_32 + int_3);
                    if (int_5 >= int_6) {
                        this.lastIndex = i;
                        break;
                    }
                }
                if (i == (this.lastIndex - 1 + 33) % 36 + 3) {
                    this.lastIndex = 3;
                    break;
                }
                i = (i - 2) % 36 + 2;
            }
        }
    }

    private boolean isTradeAvailable(ItemStack itemToBuyRecipe, ItemStack secondItemToBuyRecipe, ItemStack firstInvItem, ItemStack secondInvItem) {
        if (firstInvItem.func_77973_b() == itemToBuyRecipe.func_77973_b() && firstInvItem.func_190916_E() >= itemToBuyRecipe.func_190916_E()) {
            if (!secondItemToBuyRecipe.func_190926_b() && !secondInvItem.func_190926_b() && secondItemToBuyRecipe.func_77973_b() == secondInvItem.func_77973_b() && secondInvItem.func_190916_E() >= secondItemToBuyRecipe.func_190916_E()) {
                return true;
            }
            return secondItemToBuyRecipe.func_190926_b() && secondInvItem.func_190926_b();
        }
        return false;
    }

    private void tradeAutomatically(ItemStack itemstack) {
        ItemStack itemToSellCopy;
        ItemStack itemToSell = this.func_75139_a(2).func_190901_a(this.player, itemstack);
        if (!itemToSell.func_190926_b() && !this.func_75135_a(itemToSellCopy = itemToSell.func_77946_l(), 3, 39, true)) {
            this.player.func_71019_a(itemToSellCopy, false);
        }
    }

    public void func_75134_a(EntityPlayer playerIn) {
        InventoryPlayer inventoryplayer = playerIn.field_71071_by;
        if (!inventoryplayer.func_70445_o().func_190926_b()) {
            playerIn.func_71019_a(inventoryplayer.func_70445_o(), false);
            inventoryplayer.func_70437_b(ItemStack.field_190927_a);
        }
        this.merchant.func_70932_a_(null);
        this.merchantInventory.func_70304_b(2);
        if (!this.world.field_72995_K) {
            this.func_193327_a(playerIn, this.world, (IInventory)this.merchantInventory);
        }
    }
}

