/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.gamblingstyle.handler;

import com.fuzs.gamblingstyle.GamblingStyle;
import com.fuzs.gamblingstyle.capability.CapabilityController;
import com.fuzs.gamblingstyle.capability.container.ITradingInfo;
import com.fuzs.gamblingstyle.inventory.ContainerVillager;
import com.fuzs.gamblingstyle.network.NetworkHandler;
import com.fuzs.gamblingstyle.network.message.SOpenWindowMessage;
import com.fuzs.gamblingstyle.network.message.STradingListMessage;
import io.netty.buffer.Unpooled;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ContainerMerchant;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.InventoryMerchant;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.village.MerchantRecipeList;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class OpenContainerHandler {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public <T extends EntityLivingBase> void onContainerOpen(PlayerContainerEvent.Open evt) {
        IMerchant merchant;
        if (evt.getContainer() instanceof ContainerMerchant && (merchant = this.getMerchant((ContainerMerchant)evt.getContainer())) instanceof EntityLivingBase && evt.getEntityPlayer() instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)evt.getEntityPlayer();
            MerchantRecipeList merchantrecipelist = merchant.func_70934_b(evt.getEntityPlayer());
            if (merchantrecipelist != null && !merchantrecipelist.isEmpty() && merchant.func_70931_l_() == player) {
                player.func_71128_l();
                merchant.func_70932_a_((EntityPlayer)player);
                this.displayVillagerTradeGui(player, (EntityLivingBase)merchant);
                this.sendTradingList(player, merchantrecipelist);
            }
        }
    }

    @Nullable
    private IMerchant getMerchant(ContainerMerchant container) {
        try {
            return (IMerchant)ObfuscationReflectionHelper.getPrivateValue(ContainerMerchant.class, (Object)container, (String)"field_75178_e");
        }
        catch (Exception e) {
            GamblingStyle.LOGGER.error("getMerchant() failed", (Throwable)e);
            return null;
        }
    }

    private <T extends EntityLivingBase> void displayVillagerTradeGui(EntityPlayerMP player, T merchant) {
        player.func_71117_bO();
        player.field_71070_bA = new ContainerVillager(player.field_71071_by, (IMerchant)merchant, player.field_70170_p);
        player.field_71070_bA.field_75152_c = player.field_71139_cq;
        player.field_71070_bA.func_75132_a((IContainerListener)player);
        InventoryMerchant iinventory = ((ContainerVillager)player.field_71070_bA).func_75174_d();
        ITextComponent itextcomponent = merchant.func_145748_c_();
        ITradingInfo tradingInfo = CapabilityController.getCapability(merchant, CapabilityController.TRADING_INFO_CAPABILITY);
        NetworkHandler.get().sendTo(new SOpenWindowMessage(player.field_71139_cq, itextcomponent, iinventory.func_70302_i_(), merchant.func_145782_y(), tradingInfo.getLastTradeIndex(), tradingInfo.getFilterMode(), tradingInfo.getFavoriteTrades()), player);
    }

    private void sendTradingList(EntityPlayerMP player, MerchantRecipeList merchantrecipelist) {
        PacketBuffer packetbuffer = new PacketBuffer(Unpooled.buffer());
        packetbuffer.writeInt(player.field_71139_cq);
        merchantrecipelist.func_151391_a(packetbuffer);
        NetworkHandler.get().sendTo(new STradingListMessage(packetbuffer), player);
    }
}

