/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.gamblingstyle.client.gui.data;

import com.fuzs.gamblingstyle.capability.container.ITradingInfo;
import com.fuzs.gamblingstyle.client.gui.data.TradingRecipe;
import com.fuzs.gamblingstyle.inventory.ContainerVillager;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TradingRecipeList
extends ArrayList<TradingRecipe> {
    public TradingRecipeList(MerchantRecipeList merchantRecipes) {
        this.convertMerchantRecipes(merchantRecipes);
    }

    private void convertMerchantRecipes(MerchantRecipeList merchantRecipes) {
        for (MerchantRecipe recipe : merchantRecipes) {
            if (!this.isValidRecipe(recipe)) continue;
            this.add(new TradingRecipe(recipe.func_77394_a(), recipe.func_77396_b(), recipe.func_77397_d()));
        }
    }

    private boolean isValidRecipe(MerchantRecipe recipe) {
        return !recipe.func_77394_a().func_190926_b() && !recipe.func_77397_d().func_190926_b();
    }

    public int getActiveRecipeAmount() {
        return (int)this.stream().filter(TradingRecipe::isVisible).count();
    }

    public void search(Minecraft mc, String query, ITradingInfo.FilterMode filterMode) {
        ITooltipFlag.TooltipFlags tooltipFlag = mc.field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL;
        String trimmed = query.trim().toLowerCase(Locale.ROOT);
        for (TradingRecipe recipe : this) {
            boolean visible = recipe.shouldBeIncluded(filterMode);
            if (!trimmed.isEmpty() && visible) {
                visible = recipe.getSearchTooltip((EntityPlayer)mc.field_71439_g, (ITooltipFlag)tooltipFlag).stream().map(tooltipLine -> tooltipLine.toLowerCase(Locale.ROOT)).anyMatch(tooltipLine -> tooltipLine.contains(trimmed));
            }
            recipe.setVisible(visible);
        }
    }

    public void countTradeMaterials(ContainerVillager container) {
        for (TradingRecipe recipe : this) {
            recipe.itemIngredients = 0;
            recipe.secondItemIngredients = 0;
        }
        List collect = container.field_75151_b.stream().map(Slot::func_75211_c).collect(Collectors.toList());
        for (int i = 0; i < collect.size(); ++i) {
            ItemStack itemstack = (ItemStack)collect.get(i);
            if (i == 2) continue;
            for (TradingRecipe recipe : this) {
                if (ItemStack.func_179545_c((ItemStack)itemstack, (ItemStack)recipe.getItemToBuy())) {
                    recipe.itemIngredients += itemstack.func_190916_E();
                }
                if (!recipe.hasSecondItemToBuy() || !ItemStack.func_179545_c((ItemStack)itemstack, (ItemStack)recipe.getSecondItemToBuy())) continue;
                recipe.secondItemIngredients += itemstack.func_190916_E();
            }
        }
    }
}

