/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.gamblingstyle.client.gui.data;

import com.fuzs.gamblingstyle.capability.container.ITradingInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TradingRecipe {
    private final ItemStack[] recipe = new ItemStack[3];
    private boolean visible = true;
    private boolean selected;
    private boolean favorite;
    int itemIngredients;
    int secondItemIngredients;

    public TradingRecipe(ItemStack itemToBuy, ItemStack secondItemToBuy, ItemStack itemToSell) {
        this.recipe[0] = itemToBuy;
        this.recipe[1] = secondItemToBuy;
        this.recipe[2] = itemToSell;
    }

    public ItemStack getItemToBuy() {
        return this.recipe[0];
    }

    public ItemStack getSecondItemToBuy() {
        return this.recipe[1];
    }

    public boolean hasSecondItemToBuy() {
        return !this.getSecondItemToBuy().func_190926_b();
    }

    public ItemStack getItemToSell() {
        return this.recipe[2];
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public boolean isFavorite() {
        return this.favorite;
    }

    public void favorite() {
        this.favorite = true;
    }

    public void toggleFavorite() {
        this.favorite = !this.favorite;
    }

    private boolean isSale() {
        return this.getItemToBuy().func_77973_b() == Items.field_151166_bC || this.getSecondItemToBuy().func_77973_b() == Items.field_151166_bC;
    }

    private boolean isPurchase() {
        return this.getItemToSell().func_77973_b() == Items.field_151166_bC;
    }

    public boolean shouldBeIncluded(ITradingInfo.FilterMode mode) {
        switch (mode) {
            case FAVORITES: {
                return this.isFavorite();
            }
            case SELLS: {
                return this.isSale();
            }
            case BUYS: {
                return this.isPurchase();
            }
        }
        return true;
    }

    public boolean hasRecipeContents() {
        boolean secondItem = !this.hasSecondItemToBuy() || this.secondItemIngredients >= this.getSecondItemToBuy().func_190916_E();
        return secondItem && this.itemIngredients >= this.getItemToBuy().func_190916_E();
    }

    public List<String> getSearchTooltip(EntityPlayer player, ITooltipFlag tooltipFlag) {
        ArrayList list = Lists.newArrayList();
        list.addAll(this.getItemToBuy().func_82840_a(player, tooltipFlag));
        list.addAll(this.getItemToSell().func_82840_a(player, tooltipFlag));
        if (this.hasSecondItemToBuy()) {
            list.addAll(this.getSecondItemToBuy().func_82840_a(player, tooltipFlag));
        }
        return list;
    }
}

