/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.gamblingstyle.client.gui;

import com.fuzs.gamblingstyle.capability.container.ITradingInfo;
import com.fuzs.gamblingstyle.client.gui.GhostTrade;
import com.fuzs.gamblingstyle.client.gui.GuiTradingBook;
import com.fuzs.gamblingstyle.inventory.ContainerVillager;
import com.fuzs.gamblingstyle.network.NetworkHandler;
import com.fuzs.gamblingstyle.network.message.CMoveIngredientsMessage;
import com.fuzs.gamblingstyle.network.message.CSelectedRecipeMessage;
import com.fuzs.gamblingstyle.network.message.CSyncTradingInfoMessage;
import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiVillager
extends GuiContainer {
    private static final ResourceLocation MERCHANT_GUI_TEXTURE = new ResourceLocation("gamblingstyle", "textures/gui/container/merchant.png");
    private final IMerchant merchant;
    private final EntityLivingBase traderEntity;
    private final ITextComponent windowTitle;
    private int currentRecipeIndex;
    private final byte[] favoriteTrades;
    private final GuiTradingBook tradingBookGui;
    private final GhostTrade ghostTrade;

    public GuiVillager(InventoryPlayer playerInventory, IMerchant merchant, EntityLivingBase traderEntity, int currentRecipeIndex, ITradingInfo.FilterMode filterMode, byte[] favoriteTrades) {
        super((Container)new ContainerVillager(playerInventory, merchant, traderEntity.field_70170_p));
        this.merchant = merchant;
        this.traderEntity = traderEntity;
        this.windowTitle = merchant.func_145748_c_();
        this.currentRecipeIndex = currentRecipeIndex;
        this.tradingBookGui = new GuiTradingBook(filterMode);
        this.ghostTrade = new GhostTrade();
        this.favoriteTrades = favoriteTrades;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_147003_i = (this.field_146294_l - this.field_146999_f) / 2 + 57;
        this.tradingBookGui.initGui(this.field_146297_k, this.field_146294_l, this.field_146295_m);
        this.ghostTrade.initGui(this.field_146297_k);
    }

    public void func_146281_b() {
        this.tradingBookGui.onGuiClosed();
        if (this.merchant.func_70931_l_() != null && this.merchant.func_70934_b(this.merchant.func_70931_l_()) != null) {
            NetworkHandler.get().sendToServer(new CSyncTradingInfoMessage(this.traderEntity.func_145782_y(), this.currentRecipeIndex, this.tradingBookGui.getCurrentFilterMode(), this.tradingBookGui.getFavoriteTrades()));
        }
        super.func_146281_b();
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        String windowTitle = this.windowTitle.func_150260_c();
        this.field_146289_q.func_78276_b(windowTitle, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(windowTitle) / 2 + 23, 6, 0x404040);
        this.field_146289_q.func_78276_b(new TextComponentTranslation("container.inventory", new Object[0]).func_150260_c(), 62, this.field_147000_g - 96 + 2, 0x404040);
    }

    public void func_73876_c() {
        Slot hoveredSlot;
        super.func_73876_c();
        MerchantRecipeList merchantRecipes = this.merchant.func_70934_b((EntityPlayer)this.field_146297_k.field_71439_g);
        if (merchantRecipes != null) {
            this.tradingBookGui.updateScreen(merchantRecipes, (ContainerVillager)this.field_147002_h);
        }
        int n = (hoveredSlot = this.getSlotUnderMouse()) != null ? (hoveredSlot.func_75216_d() ? 2 : 1) : (this.tradingBookGui.hoveredSlot = 0);
        if (((ContainerVillager)this.field_147002_h).areSlotsFilled()) {
            this.ghostTrade.clear();
        }
    }

    protected boolean func_193983_c(int mouseX, int mouseY, int guiLeft, int guiTop) {
        boolean flag = mouseX < guiLeft || mouseY < guiTop || mouseX >= guiLeft + this.field_146999_f || mouseY >= guiTop + this.field_147000_g;
        return this.tradingBookGui.hasClickedOutside(mouseX, mouseY, this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g) && flag;
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        int selectedRecipe;
        MerchantRecipe merchantrecipe;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(MERCHANT_GUI_TEXTURE);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        MerchantRecipeList merchantrecipelist = this.merchant.func_70934_b((EntityPlayer)this.field_146297_k.field_71439_g);
        if (merchantrecipelist != null && (merchantrecipe = (MerchantRecipe)merchantrecipelist.get(selectedRecipe = this.currentRecipeIndex)).func_82784_g()) {
            this.field_146297_k.func_110434_K().func_110577_a(MERCHANT_GUI_TEXTURE);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179140_f();
            this.func_73729_b(this.field_147003_i + 97, this.field_147009_r + 32, 212, 0, 28, 21);
        }
        GuiInventory.func_147046_a((int)(this.field_147003_i + 33), (int)(this.field_147009_r + 75), (int)30, (float)(this.field_147003_i + 33 - mouseX), (float)(this.field_147009_r + 75 - 50 - mouseY), (EntityLivingBase)this.traderEntity);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (!this.tradingBookGui.mouseClicked(mouseX, mouseY, mouseButton)) {
            int recipeIndex = this.tradingBookGui.mouseClickedTradeButtons(mouseX, mouseY, mouseButton);
            if (recipeIndex != -1) {
                this.updateSelectedRecipe(recipeIndex, mouseButton == 1);
            } else {
                super.func_73864_a(mouseX, mouseY, mouseButton);
            }
        }
    }

    private void updateSelectedRecipe(int recipeIndex, boolean skipMove) {
        MerchantRecipeList merchantrecipelist = this.merchant.func_70934_b((EntityPlayer)this.field_146297_k.field_71439_g);
        if (merchantrecipelist != null) {
            MerchantRecipe recipe = (MerchantRecipe)merchantrecipelist.get(recipeIndex);
            boolean isNotSelected = this.currentRecipeIndex != recipeIndex;
            boolean hasIngredients = this.tradingBookGui.hasRecipeContents(recipeIndex);
            boolean isDisabled = recipe.func_82784_g();
            if (isNotSelected) {
                this.currentRecipeIndex = recipeIndex;
                this.sendSelectedRecipe(!hasIngredients || isDisabled);
            }
            if (hasIngredients) {
                this.ghostTrade.clear();
                if (!isDisabled) {
                    this.moveRecipeIngredients(isNotSelected, GuiScreen.func_146272_n(), skipMove);
                }
            } else {
                this.ghostTrade.setRecipe(recipe.func_77394_a(), recipe.func_77396_b(), recipe.func_77397_d());
                if (((ContainerVillager)this.field_147002_h).areSlotsFilled()) {
                    this.sendSelectedRecipe(true);
                }
            }
        }
    }

    private void sendSelectedRecipe(boolean clearSlots) {
        ((ContainerVillager)this.field_147002_h).func_75175_c(this.currentRecipeIndex);
        if (clearSlots) {
            ((ContainerVillager)this.field_147002_h).clearTradingSlots();
        }
        this.tradingBookGui.setSelectedTradingRecipe(this.currentRecipeIndex);
        NetworkHandler.get().sendToServer(new CSelectedRecipeMessage(this.currentRecipeIndex, clearSlots));
    }

    private void moveRecipeIngredients(boolean clear, boolean quickMove, boolean skipMove) {
        ((ContainerVillager)this.field_147002_h).handleClickedButtonItems(this.currentRecipeIndex, clear, quickMove, skipMove);
        NetworkHandler.get().sendToServer(new CMoveIngredientsMessage(this.currentRecipeIndex, clear, quickMove, skipMove));
    }

    protected void func_184098_a(Slot slotIn, int slotId, int mouseButton, ClickType type) {
        MerchantRecipeList merchantrecipelist;
        super.func_184098_a(slotIn, slotId, mouseButton, type);
        this.tradingBookGui.countTradeMaterials((ContainerVillager)this.field_147002_h);
        if (slotIn != null && slotId <= 2 && (merchantrecipelist = this.merchant.func_70934_b((EntityPlayer)this.field_146297_k.field_71439_g)) != null && merchantrecipelist.size() > this.currentRecipeIndex) {
            if (!((MerchantRecipe)merchantrecipelist.get(this.currentRecipeIndex)).func_77398_c() && slotId == 1) {
                return;
            }
            this.ghostTrade.clear();
        }
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        this.tradingBookGui.mouseReleased(mouseX, mouseY, state);
        super.func_146286_b(mouseX, mouseY, state);
    }

    public void func_146274_d() throws IOException {
        this.tradingBookGui.handleMouseInput();
        super.func_146274_d();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.tradingBookGui.drawScreen(mouseX, mouseY, partialTicks);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.ghostTrade.render(this.field_147003_i, this.field_147009_r);
        MerchantRecipeList merchantrecipelist = this.merchant.func_70934_b((EntityPlayer)this.field_146297_k.field_71439_g);
        if (merchantrecipelist != null) {
            MerchantRecipe merchantrecipe = (MerchantRecipe)merchantrecipelist.get(this.currentRecipeIndex);
            GlStateManager.func_179094_E();
            RenderHelper.func_74520_c();
            GlStateManager.func_179140_f();
            GlStateManager.func_179091_B();
            GlStateManager.func_179142_g();
            if (merchantrecipe.func_82784_g() && this.func_146978_c(97, 32, 28, 21, mouseX, mouseY)) {
                this.func_146279_a(new TextComponentTranslation("merchant.deprecated", new Object[0]).func_150260_c(), mouseX, mouseY);
            }
            GlStateManager.func_179121_F();
            GlStateManager.func_179145_e();
            GlStateManager.func_179126_j();
            RenderHelper.func_74519_b();
        }
        this.func_191948_b(mouseX, mouseY);
        this.tradingBookGui.renderHoveredTooltip(mouseX, mouseY);
        this.ghostTrade.renderHoveredTooltip(mouseX, mouseY, this.field_147003_i, this.field_147009_r);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (!this.tradingBookGui.keyTyped(typedChar, keyCode)) {
            super.func_73869_a(typedChar, keyCode);
        }
    }

    public void setMerchantRecipes(@Nullable MerchantRecipeList merchantRecipes) {
        this.merchant.func_70930_a(merchantRecipes);
        if (merchantRecipes != null) {
            if (this.currentRecipeIndex >= merchantRecipes.size()) {
                this.currentRecipeIndex = 0;
            }
            this.sendSelectedRecipe(false);
            this.tradingBookGui.setRecipes(merchantRecipes, (ContainerVillager)this.field_147002_h, this.favoriteTrades);
        }
    }
}

