/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.gamblingstyle.client.gui;

import com.fuzs.gamblingstyle.capability.container.ITradingInfo;
import com.fuzs.gamblingstyle.client.gui.GuiButtonFilter;
import com.fuzs.gamblingstyle.client.gui.GuiButtonTradingRecipe;
import com.fuzs.gamblingstyle.client.gui.core.IGuiExtension;
import com.fuzs.gamblingstyle.client.gui.core.ITooltipButton;
import com.fuzs.gamblingstyle.client.gui.data.TradingRecipe;
import com.fuzs.gamblingstyle.client.gui.data.TradingRecipeList;
import com.fuzs.gamblingstyle.inventory.ContainerVillager;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public class GuiTradingBook
extends Gui
implements IGuiExtension {
    private static final ResourceLocation RECIPE_BOOK = new ResourceLocation("gamblingstyle", "textures/gui/container/merchant_book.png");
    public static final int MAX_BUTTONS = 6;
    private Minecraft mc;
    private final int xSize = 112;
    private final int ySize = 166;
    public int hoveredSlot;
    private ITooltipButton hoveredButton;
    private final GuiButtonTradingRecipe[] tradeButtons = new GuiButtonTradingRecipe[6];
    private GuiTextField searchField;
    private final GuiButtonFilter filterButton;
    private String lastSearch = "";
    private int guiLeft;
    private int guiTop;
    private boolean requiresRefresh;
    private TradingRecipeList tradingRecipeList;
    private float currentScroll;
    private int scrollPosition;
    private boolean isScrolling;
    private boolean wasClicking;
    private GuiButton clickedButton;
    private int selectedTradingRecipe;
    private boolean clearSearch;
    private int timesInventoryChanged;

    public GuiTradingBook(ITradingInfo.FilterMode filterMode) {
        this.filterButton = new GuiButtonFilter(this.tradeButtons.length, this.guiLeft + 94, this.guiTop + 8, filterMode);
        for (int i = 0; i < this.tradeButtons.length; ++i) {
            this.tradeButtons[i] = new GuiButtonTradingRecipe(i, this.guiLeft + 10, this.guiTop + 24 + 22 * i);
        }
    }

    @Override
    public void initGui(Minecraft mc, int width, int height) {
        this.mc = mc;
        this.requiresRefresh = true;
        Keyboard.enableRepeatEvents((boolean)true);
        this.guiLeft = (width - this.xSize) / 2 - 88;
        this.guiTop = (height - this.ySize) / 2;
        this.timesInventoryChanged = this.mc.field_71439_g.field_71071_by.func_194015_p();
        this.initSearchField();
        this.filterButton.setPosition(this.guiLeft + 94, this.guiTop + 8);
        for (int i = 0; i < this.tradeButtons.length; ++i) {
            this.tradeButtons[i].setPosition(this.guiLeft + 10, this.guiTop + 24 + 22 * i);
        }
        if (!this.lastSearch.isEmpty()) {
            this.lastSearch = "";
            this.invalidate(true);
        }
    }

    private void initSearchField() {
        this.searchField = new GuiTextField(0, this.mc.field_71466_p, this.guiLeft + 9, this.guiTop + 9, 76, this.mc.field_71466_p.field_78288_b);
        this.searchField.func_146203_f(50);
        this.searchField.func_146185_a(false);
        this.searchField.func_146193_g(0xFFFFFF);
    }

    @Override
    public void onGuiClosed() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void setSelectedTradingRecipe(int recipeIndex) {
        if (this.tradingRecipeList != null) {
            ((TradingRecipe)this.tradingRecipeList.get(this.selectedTradingRecipe)).setSelected(false);
            this.selectedTradingRecipe = recipeIndex;
            ((TradingRecipe)this.tradingRecipeList.get(this.selectedTradingRecipe)).setSelected(true);
            this.requiresRefresh = true;
        } else {
            this.selectedTradingRecipe = recipeIndex;
        }
    }

    @Override
    public void updateScreen(MerchantRecipeList merchantrecipelist, ContainerVillager container) {
        if (this.timesInventoryChanged != this.mc.field_71439_g.field_71071_by.func_194015_p()) {
            this.countTradeMaterials(container);
            this.timesInventoryChanged = this.mc.field_71439_g.field_71071_by.func_194015_p();
        }
        if (this.clearSearch) {
            this.searchField.func_146202_e();
            this.searchField.func_146199_i(0);
        }
        if (this.requiresRefresh) {
            this.requiresRefresh = false;
            if (this.tradingRecipeList != null && this.tradingRecipeList.size() == merchantrecipelist.size()) {
                this.updateVisibleTrades(merchantrecipelist);
            }
        }
    }

    public void setRecipes(MerchantRecipeList merchantrecipelist, ContainerVillager container, byte[] favorites) {
        this.tradingRecipeList = new TradingRecipeList(merchantrecipelist);
        ((TradingRecipe)this.tradingRecipeList.get(this.selectedTradingRecipe)).setSelected(true);
        for (byte favorite : favorites) {
            if (favorite >= this.tradingRecipeList.size()) continue;
            ((TradingRecipe)this.tradingRecipeList.get(favorite)).favorite();
        }
        this.countTradeMaterials(container);
        this.invalidate(true);
    }

    public void countTradeMaterials(ContainerVillager container) {
        if (this.tradingRecipeList != null) {
            this.tradingRecipeList.countTradeMaterials(container);
            this.requiresRefresh = true;
        }
    }

    private void updateVisibleTrades(MerchantRecipeList merchantrecipelist) {
        int scrollPosition = this.scrollPosition;
        block0: for (GuiButtonTradingRecipe tradeButton : this.tradeButtons) {
            tradeButton.field_146125_m = false;
            for (int i = scrollPosition; i < this.tradingRecipeList.size(); ++i) {
                TradingRecipe tradingRecipe = (TradingRecipe)this.tradingRecipeList.get(i);
                if (tradingRecipe.isVisible()) {
                    tradeButton.setContents(i, tradingRecipe, ((MerchantRecipe)merchantrecipelist.get(i)).func_82784_g());
                    scrollPosition = i + 1;
                    tradeButton.field_146125_m = true;
                    continue block0;
                }
                ++scrollPosition;
            }
        }
    }

    @Override
    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        RenderHelper.func_74520_c();
        GlStateManager.func_179140_f();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)100.0f);
        this.mc.func_110434_K().func_110577_a(RECIPE_BOOK);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        this.searchField.func_146194_f();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.renderScrollBar(mouseX, mouseY);
        RenderHelper.func_74518_a();
        this.renderButtons(mouseX, mouseY, partialTicks);
        GlStateManager.func_179121_F();
    }

    private void renderScrollBar(int mouseX, int mouseY) {
        if (this.tradingRecipeList == null) {
            return;
        }
        boolean isClicked = Mouse.isButtonDown((int)0);
        int recipes = this.tradingRecipeList.getActiveRecipeAmount();
        int barPosition = (int)(136.0f / (float)Math.sqrt(Math.max(recipes - 6 + 1, 1)));
        int startX = this.guiLeft + 98;
        int startY = this.guiTop + 21;
        int endX = startX + 6;
        int endY = startY + 136;
        boolean scrollable = recipes > 6;
        this.mc.func_110434_K().func_110577_a(RECIPE_BOOK);
        this.func_73729_b(startX, startY + (int)((float)(endY - startY - barPosition) * this.currentScroll), scrollable ? 196 : 202, 0, 6, barPosition);
        this.func_73729_b(startX, startY + barPosition + (int)((float)(endY - startY - barPosition) * this.currentScroll), scrollable ? 196 : 202, 136, 6, 1);
        if (!this.wasClicking && isClicked && mouseX >= startX && mouseY >= startY && mouseX < endX && mouseY < endY + 1) {
            this.isScrolling = scrollable;
        }
        if (!isClicked) {
            this.isScrolling = false;
        }
        this.wasClicking = isClicked;
        if (this.isScrolling) {
            this.currentScroll = ((float)(mouseY - startY) - 7.5f) / ((float)(endY - startY) - 15.0f);
            this.currentScroll = MathHelper.func_76131_a((float)this.currentScroll, (float)0.0f, (float)1.0f);
            this.updateScrollPosition();
        }
    }

    private void renderButtons(int mouseX, int mouseY, float partialTicks) {
        this.hoveredButton = null;
        this.filterButton.func_191745_a(this.mc, mouseX, mouseY, partialTicks);
        for (GuiButtonTradingRecipe tradeButton : this.tradeButtons) {
            tradeButton.func_191745_a(this.mc, mouseX, mouseY, partialTicks);
            if (!tradeButton.func_146115_a() || !tradeButton.field_146125_m) continue;
            this.hoveredButton = tradeButton;
        }
        if (this.hoveredButton == null && this.filterButton.func_146115_a()) {
            this.hoveredButton = this.filterButton;
        }
    }

    public void renderHoveredTooltip(int mouseX, int mouseY) {
        List<String> tooltip;
        if (this.mc.field_71462_r != null && this.hoveredButton != null && (tooltip = this.hoveredButton.getToolTip(this.mc.field_71462_r, mouseX, mouseY)) != null && this.mc.field_71439_g.field_71071_by.func_70445_o().func_190926_b()) {
            this.mc.field_71462_r.func_146283_a(tooltip, mouseX, mouseY);
        }
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (this.searchField.func_146192_a(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if ((mouseButton == 0 || mouseButton == 1) && this.filterButton.func_146116_c(this.mc, mouseX, mouseY)) {
            this.filterButton.cycleFilterMode(this.getFavorites() == 0);
            this.filterButton.func_146113_a(this.mc.func_147118_V());
            this.invalidate(true);
            return true;
        }
        return false;
    }

    public int mouseClickedTradeButtons(int mouseX, int mouseY, int mouseButton) {
        if (mouseButton == 0 || mouseButton == 1) {
            for (GuiButtonTradingRecipe tradeButton : this.tradeButtons) {
                if (tradeButton.mousePressedOnFavorite(mouseX, mouseY)) {
                    ((TradingRecipe)this.tradingRecipeList.get(tradeButton.getRecipeId())).toggleFavorite();
                    if (this.getFavorites() == 0 && this.getCurrentFilterMode() == ITradingInfo.FilterMode.FAVORITES) {
                        this.filterButton.cycleFilterMode(false);
                        this.invalidate(true);
                    } else {
                        this.invalidate(false);
                    }
                    return -1;
                }
                if (!tradeButton.func_146116_c(this.mc, mouseX, mouseY)) continue;
                this.clearSearch = true;
                this.clickedButton = tradeButton;
                tradeButton.func_146113_a(this.mc.func_147118_V());
                return tradeButton.getRecipeId();
            }
        }
        return -1;
    }

    @Override
    public void mouseReleased(int mouseX, int mouseY, int state) {
        if (this.clickedButton != null && state == 0) {
            this.clickedButton.func_146118_a(mouseX, mouseY);
            this.clickedButton = null;
        }
    }

    @Override
    public void handleMouseInput() {
        int recipes;
        int scrollAmount = Mouse.getEventDWheel();
        if (scrollAmount != 0 && this.tradingRecipeList != null && (recipes = this.tradingRecipeList.getActiveRecipeAmount()) > 6) {
            if (scrollAmount > 0) {
                scrollAmount = 1;
            }
            if (scrollAmount < 0) {
                scrollAmount = -1;
            }
            this.currentScroll = (float)((double)this.currentScroll - (double)scrollAmount / (double)recipes);
            this.currentScroll = MathHelper.func_76131_a((float)this.currentScroll, (float)0.0f, (float)1.0f);
            this.updateScrollPosition();
        }
    }

    public boolean hasRecipeContents(int id) {
        if (this.tradingRecipeList != null && this.tradingRecipeList.size() > id) {
            return ((TradingRecipe)this.tradingRecipeList.get(id)).hasRecipeContents();
        }
        return false;
    }

    @Override
    public boolean hasClickedOutside(int mouseX, int mouseY, int guiLeft, int guiTop, int xSize, int ySize) {
        boolean flag = mouseX < guiLeft || mouseY < guiTop || mouseX >= guiLeft + xSize || mouseY >= guiTop + ySize;
        boolean flag1 = guiLeft - this.xSize < mouseX && mouseX < guiLeft && guiTop < mouseY && mouseY < guiTop + ySize;
        return flag && !flag1;
    }

    @Override
    public boolean keyTyped(char typedChar, int keyCode) {
        if (this.isKeyValid(keyCode)) {
            return false;
        }
        if (this.clearSearch) {
            this.searchField.func_146180_a("");
            this.clearSearch = false;
        }
        if (this.searchField.func_146201_a(typedChar, keyCode)) {
            String searchQuery = this.searchField.func_146179_b();
            if (!searchQuery.equals(this.lastSearch) && this.tradingRecipeList != null) {
                this.lastSearch = searchQuery;
                this.invalidate(true);
            }
            return true;
        }
        return false;
    }

    private void invalidate(boolean resetScroll) {
        this.tradingRecipeList.search(this.mc, this.lastSearch, this.getCurrentFilterMode());
        if (resetScroll) {
            this.currentScroll = 0.0f;
            this.updateScrollPosition();
        }
        this.requiresRefresh = true;
    }

    private boolean isKeyValid(int keyCode) {
        if (this.mc.field_71439_g.field_71071_by.func_70445_o().func_190926_b() && this.hoveredSlot > 0) {
            GameSettings settings = this.mc.field_71474_y;
            for (int i = 0; i < 9; ++i) {
                if (!settings.field_151456_ac[i].isActiveAndMatches(keyCode)) continue;
                return true;
            }
            if (this.hoveredSlot > 1) {
                return settings.field_74316_C.isActiveAndMatches(keyCode);
            }
        }
        return false;
    }

    private void updateScrollPosition() {
        if (this.tradingRecipeList != null) {
            int[] activeTradeIndices;
            int activeRecipes = this.tradingRecipeList.getActiveRecipeAmount();
            int scrollAmount = (int)((double)(this.currentScroll * (float)Math.max(activeRecipes - 6, 0)) + 0.5);
            if ((scrollAmount = Math.max(0, scrollAmount)) < (activeTradeIndices = this.getActiveTradeIndices(activeRecipes)).length && this.scrollPosition != activeTradeIndices[scrollAmount]) {
                this.scrollPosition = activeTradeIndices[scrollAmount];
                this.requiresRefresh = true;
            }
        }
    }

    private int[] getActiveTradeIndices(int activeRecipes) {
        int[] activeTradeIndices = activeRecipes < this.tradingRecipeList.size() ? IntStream.range(0, this.tradingRecipeList.size()).map(recipeIndex -> ((TradingRecipe)this.tradingRecipeList.get(recipeIndex)).isVisible() ? recipeIndex : -1).filter(recipeIndex -> recipeIndex >= 0).toArray() : IntStream.range(0, this.tradingRecipeList.size()).toArray();
        return activeTradeIndices;
    }

    public ITradingInfo.FilterMode getCurrentFilterMode() {
        return this.filterButton.getFilterMode();
    }

    public byte[] getFavoriteTrades() {
        byte[] favorites = new byte[this.getFavorites()];
        int i = 0;
        int j = 0;
        while (i < favorites.length) {
            if (((TradingRecipe)this.tradingRecipeList.get(j)).isFavorite()) {
                favorites[i++] = (byte)j;
            }
            ++j;
        }
        return favorites;
    }

    private int getFavorites() {
        return (int)this.tradingRecipeList.stream().filter(TradingRecipe::isFavorite).count();
    }
}

