/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.gamblingstyle.client.gui;

import com.fuzs.gamblingstyle.client.gui.core.ITooltipButton;
import com.fuzs.gamblingstyle.client.gui.data.TradingRecipe;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiButtonTradingRecipe
extends GuiButton
implements ITooltipButton {
    private static final ResourceLocation RECIPE_BOOK = new ResourceLocation("gamblingstyle", "textures/gui/container/merchant_book.png");
    private final ItemStack[] recipe = new ItemStack[]{ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a};
    private int recipeId;
    private boolean isSelectedRecipe;
    private boolean hasContents;
    private boolean soldOut;
    private boolean favorite;

    public GuiButtonTradingRecipe(int id, int posX, int posY) {
        super(id, posX, posY, 84, 22, "");
        this.field_146125_m = false;
    }

    public void setContents(int id, TradingRecipe recipe, boolean soldOut) {
        this.recipeId = id;
        this.recipe[0] = recipe.getItemToBuy();
        this.recipe[1] = recipe.getSecondItemToBuy();
        this.recipe[2] = recipe.getItemToSell();
        this.isSelectedRecipe = recipe.isSelected();
        this.hasContents = recipe.hasRecipeContents();
        this.soldOut = soldOut;
        this.favorite = recipe.isFavorite();
    }

    public int getRecipeId() {
        return this.recipeId;
    }

    @Override
    public void setPosition(int posX, int posY) {
        this.field_146128_h = posX;
        this.field_146129_i = posY;
    }

    public boolean mousePressedOnFavorite(int mouseX, int mouseY) {
        boolean pressed;
        int buttonSize = 9;
        boolean bl = pressed = this.field_146124_l && this.field_146125_m && mouseX >= this.field_146128_h - 3 && mouseY >= this.field_146129_i + 6 && mouseX < this.field_146128_h - 3 + 9 && mouseY < this.field_146129_i + 6 + 9;
        if (pressed) {
            this.favorite = !this.favorite;
        }
        return pressed;
    }

    public void func_191745_a(@Nonnull Minecraft mc, int mouseX, int mouseY, float partialTicks) {
        if (this.field_146125_m) {
            int favoriteButtonSize = 9;
            boolean isFavoriteHovered = mouseX >= this.field_146128_h - 3 && mouseY >= this.field_146129_i + 6 && mouseX < this.field_146128_h - 3 + 9 && mouseY < this.field_146129_i + 6 + 9;
            this.field_146123_n = !isFavoriteHovered && mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
            RenderHelper.func_74520_c();
            GlStateManager.func_179140_f();
            mc.func_110434_K().func_110577_a(RECIPE_BOOK);
            this.func_73729_b(this.field_146128_h, this.field_146129_i, 112, this.getTextureY(), this.field_146120_f, this.field_146121_g);
            if (this.soldOut) {
                this.func_73729_b(this.field_146128_h + 47, this.field_146129_i + 3, this.hasContents ? 0 : 10, 166, 10, 15);
            }
            this.func_73729_b(this.field_146128_h - 3, this.field_146129_i + 6, this.favorite ? 20 : 29, 166, 9, 9);
            this.renderItemAndEffect(mc, this.recipe[0], this.field_146128_h + 6, this.field_146129_i + 2);
            this.renderItemAndEffect(mc, this.recipe[2], this.field_146128_h + 61, this.field_146129_i + 2);
            if (!this.recipe[1].func_190926_b()) {
                this.renderItemAndEffect(mc, this.recipe[1], this.field_146128_h + 27, this.field_146129_i + 2);
            }
            GlStateManager.func_179145_e();
            RenderHelper.func_74518_a();
        }
    }

    private int getTextureY() {
        int textureY = 0;
        if (this.field_146123_n) {
            textureY += 22;
        }
        if (!this.hasContents) {
            textureY += 88;
        }
        if (this.isSelectedRecipe) {
            textureY += 44;
        }
        return textureY;
    }

    private void renderItemAndEffect(Minecraft mc, ItemStack itemStack, int xPosition, int yPosition) {
        mc.func_175599_af().func_180450_b(itemStack, xPosition, yPosition);
        mc.func_175599_af().func_175030_a(mc.field_71466_p, itemStack, xPosition, yPosition);
    }

    @Override
    public List<String> getToolTip(GuiScreen screen, int mouseX, int mouseY) {
        ItemStack itemstack = this.getItemStackInRegion(mouseX, mouseY);
        List<String> list = Lists.newArrayList();
        if (!itemstack.func_190926_b()) {
            list = screen.func_191927_a(itemstack);
        } else if (this.soldOut && this.isPointInRegion(47, 3, 10, 15, mouseX, mouseY)) {
            list.add(new TextComponentTranslation("merchant.deprecated", new Object[0]).func_150260_c());
        }
        if (!list.isEmpty() && TextFormatting.func_110646_a((String)list.get(list.size() - 1).trim()).isEmpty()) {
            list.remove(list.size() - 1);
        }
        return list;
    }

    private ItemStack getItemStackInRegion(int mouseX, int mouseY) {
        if (this.isPointInRegion(6, 2, 16, 16, mouseX, mouseY)) {
            return this.recipe[0];
        }
        if (this.isPointInRegion(27, 2, 16, 16, mouseX, mouseY)) {
            return this.recipe[1];
        }
        if (this.isPointInRegion(61, 2, 16, 16, mouseX, mouseY)) {
            return this.recipe[2];
        }
        return ItemStack.field_190927_a;
    }

    private boolean isPointInRegion(int rectX, int rectY, int rectWidth, int rectHeight, int pointX, int pointY) {
        return (pointX -= this.field_146128_h) >= rectX - 1 && pointX < rectX + rectWidth + 1 && (pointY -= this.field_146129_i) >= rectY - 1 && pointY < rectY + rectHeight + 1;
    }
}

