/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.gamblingstyle.client.gui;

import com.fuzs.gamblingstyle.capability.container.ITradingInfo;
import com.fuzs.gamblingstyle.client.gui.core.ITooltipButton;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;

public class GuiButtonFilter
extends GuiButton
implements ITooltipButton {
    private static final ResourceLocation FILTER_BUTTON = new ResourceLocation("gamblingstyle", "textures/gui/container/merchant_filter.png");
    private ITradingInfo.FilterMode filterMode;

    public GuiButtonFilter(int buttonId, int x, int y, ITradingInfo.FilterMode filterMode) {
        super(buttonId, x, y, 10, 10, "");
        this.filterMode = filterMode;
    }

    @Override
    public void setPosition(int posX, int posY) {
        this.field_146128_h = posX;
        this.field_146129_i = posY;
    }

    public void func_191745_a(@Nonnull Minecraft mc, int mouseX, int mouseY, float partialTicks) {
        if (this.field_146125_m) {
            this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
            mc.func_110434_K().func_110577_a(FILTER_BUTTON);
            GlStateManager.func_179097_i();
            int buttonSize = 10;
            int textureX = 10 * this.filterMode.ordinal();
            int textureY = 10;
            if (this.field_146123_n) {
                textureY += 10;
            }
            this.func_73729_b(this.field_146128_h, this.field_146129_i, textureX, textureY, this.field_146120_f, this.field_146121_g);
            GlStateManager.func_179126_j();
        }
    }

    @Override
    public List<String> getToolTip(GuiScreen screen, int mouseX, int mouseY) {
        TextComponentTranslation tooltipComponent = new TextComponentTranslation("gui.button.show", new Object[]{new TextComponentTranslation(this.filterMode.key, new Object[0])});
        return Lists.newArrayList((Object[])new String[]{tooltipComponent.func_150260_c()});
    }

    public void cycleFilterMode(boolean skipFavorites) {
        int nextIndex = (this.filterMode.ordinal() + 1) % ITradingInfo.FilterMode.values().length;
        this.filterMode = ITradingInfo.FilterMode.values()[nextIndex];
        if (skipFavorites && this.filterMode == ITradingInfo.FilterMode.FAVORITES) {
            this.cycleFilterMode(false);
        }
    }

    public ITradingInfo.FilterMode getFilterMode() {
        return this.filterMode;
    }
}

