/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.gamblingstyle.capability.core;

import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.INBTSerializable;

public class CapabilityDispatcher<T extends INBTSerializable<NBTTagCompound>>
implements ICapabilitySerializable<NBTTagCompound> {
    private final Capability<T> capability;
    private final T storage;

    public CapabilityDispatcher(T storage, Capability<T> capability) {
        this.storage = storage;
        this.capability = capability;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing facing) {
        return capability == this.capability;
    }

    public <S> S getCapability(@Nonnull Capability<S> capability, EnumFacing facing) {
        return capability == this.capability ? (S)this.storage : null;
    }

    public NBTTagCompound serializeNBT() {
        return (NBTTagCompound)this.storage.serializeNBT();
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.storage.deserializeNBT((NBTBase)nbt);
    }
}

