/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.artisanworktables.modules.worktables.tile;

import com.codetaylor.mc.artisanworktables.modules.worktables.particle.ParticleWorktableMage;
import com.codetaylor.mc.artisanworktables.modules.worktables.tile.spi.TileEntityBase;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumParticleTypes;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityMageDelegate {
    private Random random;
    private boolean activeDirty = true;
    private boolean active;
    private TileEntityBase tileEntity;

    public TileEntityMageDelegate(TileEntityBase tileEntity) {
        this.tileEntity = tileEntity;
        this.random = new Random();
    }

    public void update() {
        if (this.tileEntity.func_145831_w() == null) {
            return;
        }
        if (this.tileEntity.func_145831_w().field_72995_K) {
            if (!this.tileEntity.hasTool()) {
                return;
            }
            if ((double)this.random.nextFloat() < 0.5) {
                this.spawnParticles();
            }
        } else {
            boolean active = this.tileEntity.hasTool();
            if (this.active != active || this.activeDirty) {
                this.activeDirty = false;
                this.active = active;
                this.tileEntity.notifyBlockUpdate();
            }
        }
    }

    public void onDataPacket(NetworkManager manager, SPacketUpdateTileEntity packet) {
        this.tileEntity.notifyBlockUpdate();
    }

    public ItemStack getItemStackForTabDisplay(IBlockState state) {
        Block block = state.func_177230_c();
        Item item = Item.func_150898_a((Block)block);
        if (this.tileEntity.hasTool()) {
            return new ItemStack(item, 1, 16383 + block.func_176201_c(state));
        }
        return new ItemStack(item, 1, block.func_176201_c(state));
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnParticles() {
        this.tileEntity.func_145831_w().func_175688_a(EnumParticleTypes.PORTAL, (double)this.tileEntity.func_174877_v().func_177958_n() + 0.5 + (double)this.random.nextFloat() * 0.5 - 0.25, (double)this.tileEntity.func_174877_v().func_177956_o() + 0.5, (double)this.tileEntity.func_174877_v().func_177952_p() + 0.5 + (double)this.random.nextFloat() * 0.5 - 0.25, 0.0, (double)this.random.nextFloat(), 0.0, new int[0]);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticleWorktableMage(this.tileEntity.func_145831_w(), (double)this.tileEntity.func_174877_v().func_177958_n() + 0.5 + (double)this.random.nextFloat() * 0.5 - 0.25, (double)this.tileEntity.func_174877_v().func_177956_o() + 1.5, (double)this.tileEntity.func_174877_v().func_177952_p() + 0.5 + (double)this.random.nextFloat() * 0.5 - 0.25, 0.0, this.random.nextFloat(), 0.0));
    }
}

